/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import org.jruby.runtime.backtrace.FrameType;

public class RubyStackTraceElement {
    public static final RubyStackTraceElement[] EMPTY_ARRAY = new RubyStackTraceElement[0];
    private final StackTraceElement element;
    private final boolean binding;
    private final FrameType frameType;

    public RubyStackTraceElement(StackTraceElement element) {
        this.element = element;
        this.binding = false;
        this.frameType = FrameType.METHOD;
    }

    public RubyStackTraceElement(String cls, String method2, String file2, int line, boolean binding2) {
        this(cls, method2, file2, line, binding2, FrameType.METHOD);
    }

    public RubyStackTraceElement(String cls, String method2, String file2, int line, boolean binding2, FrameType frameType) {
        this.element = new StackTraceElement(cls, method2, file2, line);
        this.binding = binding2;
        this.frameType = frameType;
    }

    public StackTraceElement getElement() {
        return this.element;
    }

    public boolean isBinding() {
        return this.binding;
    }

    public String getClassName() {
        return this.element.getClassName();
    }

    public String getFileName() {
        return this.element.getFileName();
    }

    public int getLineNumber() {
        return this.element.getLineNumber();
    }

    public String getMethodName() {
        return this.element.getMethodName();
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public String toString() {
        return this.element.toString();
    }
}

