/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.CompoundJarURLStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyClassLoader
extends URLClassLoader
implements ClassDefiningClassLoader {
    private static final ProtectionDomain DEFAULT_DOMAIN = JRubyClassLoader.class.getProtectionDomain();
    private final Map<URL, Set<String>> jarIndexes = new LinkedHashMap<URL, Set<String>>();
    private Runnable unloader;

    public JRubyClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
        this.indexJarContents(url);
    }

    public void tearDown(boolean debug) {
        block2: {
            try {
                this.getJDBCDriverUnloader().run();
            }
            catch (Exception e) {
                if (!debug) break block2;
                e.printStackTrace(System.out);
            }
        }
    }

    public synchronized Runnable getJDBCDriverUnloader() {
        if (this.unloader == null) {
            try {
                int bytesRead;
                InputStream unloaderStream = this.getClass().getResourceAsStream("/org/jruby/util/JDBCDriverUnloader.class");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((bytesRead = unloaderStream.read(buf)) != -1) {
                    baos.write(buf, 0, bytesRead);
                }
                Class<?> unloaderClass = this.defineClass("org.jruby.util.JDBCDriverUnloader", baos.toByteArray());
                this.unloader = (Runnable)unloaderClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.unloader;
    }

    @Override
    public Class<?> defineClass(String name2, byte[] bytes2) {
        return super.defineClass(name2, bytes2, 0, bytes2.length, DEFAULT_DOMAIN);
    }

    public Class<?> defineClass(String name2, byte[] bytes2, ProtectionDomain domain) {
        return super.defineClass(name2, bytes2, 0, bytes2.length, domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            return super.findClass(className);
        }
        catch (ClassNotFoundException ex) {
            String resourceName = className.replace('.', '/').concat(".class");
            URL classUrl = null;
            Map<URL, Set<String>> map = this.jarIndexes;
            synchronized (map) {
                for (URL jarUrl : this.jarIndexes.keySet()) {
                    if (!this.jarIndexes.get(jarUrl).contains(resourceName)) continue;
                    try {
                        classUrl = CompoundJarURLStreamHandler.createUrl(jarUrl, resourceName);
                        break;
                    }
                    catch (IOException e) {
                    }
                }
            }
            if (classUrl != null) {
                try {
                    Class<?> clazz;
                    InputStream input = classUrl.openStream();
                    try {
                        byte[] buffer = new byte[4096];
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        int count2 = input.read(buffer);
                        while (count2 > 0) {
                            output.write(buffer, 0, count2);
                            count2 = input.read(buffer);
                        }
                        byte[] data = output.toByteArray();
                        clazz = this.defineClass(className, data, 0, data.length);
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        JRubyClassLoader.close(input);
                        throw throwable;
                    }
                    JRubyClassLoader.close(input);
                    return clazz;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(String resourceName) {
        URL result2 = super.findResource(resourceName);
        if (result2 == null) {
            Map<URL, Set<String>> map = this.jarIndexes;
            synchronized (map) {
                for (URL jarUrl : this.jarIndexes.keySet()) {
                    if (!this.jarIndexes.get(jarUrl).contains(resourceName)) continue;
                    try {
                        return CompoundJarURLStreamHandler.createUrl(jarUrl, resourceName);
                    }
                    catch (IOException e) {
                    }
                }
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> findResources(String resourceName) throws IOException {
        final ArrayList<URL> embeddedUrls = new ArrayList<URL>();
        Map<URL, Set<String>> map = this.jarIndexes;
        synchronized (map) {
            for (URL jarUrl : this.jarIndexes.keySet()) {
                if (!this.jarIndexes.get(jarUrl).contains(resourceName)) continue;
                try {
                    embeddedUrls.add(CompoundJarURLStreamHandler.createUrl(jarUrl, resourceName));
                }
                catch (IOException e) {}
            }
        }
        if (embeddedUrls.isEmpty()) {
            return super.findResources(resourceName);
        }
        final Enumeration<URL> originalResult = super.findResources(resourceName);
        return new Enumeration<URL>(){
            private Iterator<URL> extendedResult;

            @Override
            public URL nextElement() {
                if (this.extendedResult == null) {
                    return (URL)originalResult.nextElement();
                }
                return this.extendedResult.next();
            }

            @Override
            public boolean hasMoreElements() {
                if (this.extendedResult == null) {
                    boolean result2 = originalResult.hasMoreElements();
                    if (!result2) {
                        this.extendedResult = embeddedUrls.iterator();
                        result2 = this.extendedResult.hasNext();
                    }
                    return result2;
                }
                return this.extendedResult.hasNext();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexJarContents(URL jarUrl) {
        String proto = jarUrl.getProtocol();
        if (proto.equals("jar") || proto.equals("compoundjar")) {
            Map<URL, Set<String>> map = this.jarIndexes;
            synchronized (map) {
                HashSet<String> entries2 = new HashSet<String>();
                this.jarIndexes.put(jarUrl, entries2);
                try {
                    InputStream baseInputStream = jarUrl.openStream();
                    try {
                        JarInputStream baseJar = new JarInputStream(baseInputStream);
                        JarEntry entry = baseJar.getNextJarEntry();
                        while (entry != null) {
                            entries2.add(entry.getName());
                            entry = baseJar.getNextJarEntry();
                        }
                        Object var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        JRubyClassLoader.close(baseInputStream);
                        throw throwable;
                    }
                    JRubyClassLoader.close(baseInputStream);
                    {
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
    }

    private static void close(Closeable resource2) {
        if (resource2 != null) {
            try {
                resource2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

