/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.IArityNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.DefinedMessage;

public class InstVarNode
extends Node
implements IArityNode,
INameNode {
    private String name;
    private VariableAccessor accessor = VariableAccessor.DUMMY_ACCESSOR;

    public InstVarNode(ISourcePosition position, String name2) {
        super(position);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.INSTVARNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitInstVarNode(this);
    }

    @Override
    public Arity getArity() {
        return Arity.noArguments();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        return this.getVariable(runtime, self2, true);
    }

    private IRubyObject getVariable(Ruby runtime, IRubyObject self2, boolean warn2) {
        IRubyObject value2 = this.getValue(runtime, self2);
        if (value2 != null) {
            return value2;
        }
        if (warn2 && runtime.isVerbose()) {
            this.warnAboutUninitializedIvar(runtime);
        }
        return runtime.getNil();
    }

    private IRubyObject getValue(Ruby runtime, IRubyObject self2) {
        IRubyObject value2;
        RubyClass cls = self2.getMetaClass().getRealClass();
        VariableAccessor localAccessor = this.accessor;
        if (localAccessor.getClassId() != cls.hashCode()) {
            localAccessor = cls.getVariableAccessorForRead(this.name);
            if (localAccessor == null) {
                return runtime.getNil();
            }
            value2 = (IRubyObject)localAccessor.get(self2);
            this.accessor = localAccessor;
        } else {
            value2 = (IRubyObject)localAccessor.get(self2);
        }
        return value2;
    }

    private void warnAboutUninitializedIvar(Ruby runtime) {
        runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, this.getPosition(), "instance variable " + this.name + " not initialized");
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        return this.getValue(runtime, self2) == null ? null : runtime.getDefinedMessage(DefinedMessage.INSTANCE_VARIABLE);
    }
}

