/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.AttributeName;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.LocalContextProvider;

public class LocalContext {
    private RubyInstanceConfig config;
    private LocalVariableBehavior behavior;
    private boolean lazy;
    Ruby runtime = null;
    private BiVariableMap varMap = null;
    private HashMap attribute = null;
    boolean initialized = false;

    public LocalContext(RubyInstanceConfig config, LocalVariableBehavior behavior, boolean lazy) {
        this.initialize(config, behavior, lazy);
    }

    private void initialize(RubyInstanceConfig config, LocalVariableBehavior behavior, boolean lazy) {
        this.config = config;
        this.behavior = behavior;
        this.lazy = lazy;
    }

    public Ruby getThreadSafeRuntime() {
        if (this.runtime == null) {
            this.runtime = Ruby.newInstance(this.config);
            this.initialized = true;
        }
        return this.runtime;
    }

    public BiVariableMap getVarMap(LocalContextProvider provider) {
        if (this.varMap == null) {
            this.varMap = new BiVariableMap(provider, this.lazy);
        }
        return this.varMap;
    }

    public LocalVariableBehavior getLocalVariableBehavior() {
        return this.behavior;
    }

    public HashMap getAttributeMap() {
        if (this.attribute == null) {
            this.attribute = new HashMap();
            this.attribute.put(AttributeName.READER, new InputStreamReader(System.in));
            this.attribute.put(AttributeName.WRITER, new PrintWriter(System.out, true));
            this.attribute.put(AttributeName.ERROR_WRITER, new PrintWriter(System.err, true));
        }
        return this.attribute;
    }

    public void remove() {
        if (this.attribute == null) {
            return;
        }
        this.attribute.clear();
        this.varMap.clear();
    }
}

