/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.delegate;

import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class NativeDelegateLibrary
implements Library {
    @Override
    public void load(Ruby runtime, boolean wrap2) {
        assert (!runtime.is1_8()) : "the native delegator extension is not compatible with 1.8";
        RubyClass delegateClass = runtime.getClass("Delegator");
        delegateClass.defineAnnotatedMethods(NativeDelegateLibrary.class);
    }

    @JRubyMethod(omit=true)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block) {
        String methodName = arg0.asJavaString();
        RubyBasicObject object = (RubyBasicObject)self2.callMethod(context, "__getobj__");
        DynamicMethod method2 = object.getMetaClass().searchMethod(methodName);
        if (method2.isUndefined()) {
            if (object.callMethod(context, "respond_to?", arg0).isTrue()) {
                return object.callMethod(context, methodName, IRubyObject.NULL_ARRAY, block);
            }
            RubyKernel.methodMissing(context, self2, methodName, Visibility.PUBLIC, CallType.FUNCTIONAL, IRubyObject.NULL_ARRAY, block);
        } else if (method2.getVisibility().isPrivate()) {
            RubyKernel.methodMissing(context, self2, methodName, Visibility.PRIVATE, CallType.FUNCTIONAL, IRubyObject.NULL_ARRAY, block);
        }
        return method2.call(context, (IRubyObject)object, (RubyModule)object.getMetaClass(), methodName, block);
    }

    @JRubyMethod(omit=true)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) {
        String methodName = arg0.asJavaString();
        RubyBasicObject object = (RubyBasicObject)self2.callMethod(context, "__getobj__");
        DynamicMethod method2 = object.getMetaClass().searchMethod(methodName);
        if (method2.isUndefined()) {
            if (object.callMethod(context, "respond_to?", arg0).isTrue()) {
                return object.callMethod(context, methodName, new IRubyObject[]{arg1}, block);
            }
            RubyKernel.methodMissing(context, self2, methodName, Visibility.PUBLIC, CallType.FUNCTIONAL, new IRubyObject[]{arg1}, block);
        } else if (method2.getVisibility().isPrivate()) {
            RubyKernel.methodMissing(context, self2, methodName, Visibility.PRIVATE, CallType.FUNCTIONAL, new IRubyObject[]{arg1}, block);
        }
        return method2.call(context, (IRubyObject)object, (RubyModule)object.getMetaClass(), methodName, arg1, block);
    }

    @JRubyMethod(omit=true)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        String methodName = arg0.asJavaString();
        RubyBasicObject object = (RubyBasicObject)self2.callMethod(context, "__getobj__");
        DynamicMethod method2 = object.getMetaClass().searchMethod(methodName);
        if (method2.isUndefined()) {
            if (object.callMethod(context, "respond_to?", arg0).isTrue()) {
                return object.callMethod(context, methodName, new IRubyObject[]{arg1, arg2}, block);
            }
            RubyKernel.methodMissing(context, self2, methodName, Visibility.PUBLIC, CallType.FUNCTIONAL, new IRubyObject[]{arg1, arg2}, block);
        } else if (method2.getVisibility().isPrivate()) {
            RubyKernel.methodMissing(context, self2, methodName, Visibility.PRIVATE, CallType.FUNCTIONAL, new IRubyObject[]{arg1, arg2}, block);
        }
        return method2.call(context, (IRubyObject)object, (RubyModule)object.getMetaClass(), methodName, arg1, arg2, block);
    }

    @JRubyMethod(required=1, rest=true, omit=true)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        IRubyObject[] newArgs = new IRubyObject[args2.length - 1];
        System.arraycopy(args2, 1, newArgs, 0, newArgs.length);
        String methodName = args2[0].asJavaString();
        RubyBasicObject object = (RubyBasicObject)self2.callMethod(context, "__getobj__");
        DynamicMethod method2 = object.getMetaClass().searchMethod(methodName);
        if (method2.isUndefined()) {
            if (object.callMethod(context, "respond_to?", args2[0]).isTrue()) {
                return object.callMethod(context, methodName, newArgs, block);
            }
            RubyKernel.methodMissing(context, self2, methodName, Visibility.PUBLIC, CallType.FUNCTIONAL, newArgs, block);
        } else if (method2.getVisibility().isPrivate()) {
            RubyKernel.methodMissing(context, self2, methodName, Visibility.PRIVATE, CallType.FUNCTIONAL, newArgs, block);
        }
        return method2.call(context, (IRubyObject)object, (RubyModule)object.getMetaClass(), methodName, newArgs, block);
    }
}

