/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectedJavaMethod
extends JavaMethod {
    private final Method method;
    private final boolean needsBlock;
    private final boolean isStatic;
    private final int required;
    private final int optional;
    private final boolean rest;
    private final int max;
    private final boolean argsAsIs;
    private final boolean needsThreadContext;

    public ReflectedJavaMethod(RubyModule implementationClass, Method method2, JRubyMethod annotation2) {
        super(implementationClass, annotation2.visibility());
        this.method = method2;
        Class[] params2 = method2.getParameterTypes();
        this.needsBlock = params2.length > 0 && params2[params2.length - 1] == Block.class;
        this.isStatic = Modifier.isStatic(method2.getModifiers());
        Arity arity2 = Arity.fromAnnotation(annotation2, params2, this.isStatic);
        this.setArity(arity2);
        this.required = arity2.getValue() >= 0 ? arity2.getValue() : Math.abs(arity2.getValue()) - 1;
        this.optional = annotation2.optional();
        this.rest = annotation2.rest();
        this.needsThreadContext = params2.length > 0 && params2[0] == ThreadContext.class;
        this.argsAsIs = !this.isStatic && this.optional == 0 && !this.rest && !this.needsBlock && !this.needsThreadContext;
        this.max = this.rest ? -1 : this.required + this.optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        Arity.checkArgumentCount(runtime, name2, args2, this.required, this.max);
        this.callConfig.pre(context, self2, this.getImplementationClass(), name2, block, null);
        if (!this.isStatic && !this.method.getDeclaringClass().isAssignableFrom(self2.getClass())) {
            throw new ClassCastException(self2.getClass().getName() + " cannot be converted to " + this.method.getDeclaringClass().getName());
        }
        if (this.argsAsIs) {
            boolean isTrace = runtime.hasEventHooks();
            try {
                if (isTrace) {
                    runtime.callEventHooks(context, RubyEvent.C_CALL, context.getFile(), context.getLine(), name2, this.getImplementationClass());
                }
                IRubyObject iRubyObject = (IRubyObject)this.method.invoke((Object)self2, (Object[])args2);
                return iRubyObject;
            }
            finally {
                if (isTrace) {
                    runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
                }
            }
        }
        int argsLength = this.calcArgsLength();
        Object[] params2 = new Object[argsLength];
        int offset2 = 0;
        if (this.needsThreadContext) {
            params2[offset2++] = context;
        }
        if (this.isStatic) {
            params2[offset2++] = self2;
        }
        if (this.required < 4 && this.optional == 0 && !this.rest) {
            for (int i2 = 0; i2 < args2.length; ++i2) {
                params2[offset2++] = this.method.getParameterTypes()[offset2] == RubyString.class ? args2[i2].convertToString() : args2[i2];
            }
        } else {
            params2[offset2++] = args2;
        }
        if (this.needsBlock) {
            params2[offset2++] = block;
        }
        boolean isTrace = runtime.hasEventHooks();
        try {
            IRubyObject iRubyObject;
            if (isTrace) {
                runtime.callEventHooks(context, RubyEvent.C_CALL, context.getFile(), context.getLine(), name2, this.getImplementationClass());
            }
            IRubyObject result2 = this.isStatic ? (IRubyObject)this.method.invoke(null, params2) : (IRubyObject)this.method.invoke((Object)self2, params2);
            IRubyObject iRubyObject2 = iRubyObject = result2 == null ? runtime.getNil() : result2;
            if (isTrace) {
                runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
            }
            return iRubyObject;
        }
        catch (Throwable throwable) {
            try {
                if (isTrace) {
                    runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
                }
                throw throwable;
            }
            catch (IllegalArgumentException e) {
                throw RaiseException.createNativeRaiseException(runtime, e, this.method);
            }
            catch (IllegalAccessException e) {
                throw RaiseException.createNativeRaiseException(runtime, e, this.method);
            }
            catch (InvocationTargetException e) {
                Throwable cause2 = e.getCause();
                if (cause2 instanceof RuntimeException) {
                    throw (RuntimeException)cause2;
                }
                if (cause2 instanceof Error) {
                    throw (Error)cause2;
                }
                throw RaiseException.createNativeRaiseException(runtime, cause2, this.method);
            }
        }
        finally {
            this.callConfig.post(context);
        }
    }

    private int calcArgsLength() {
        int argsLength = 0;
        if (this.needsThreadContext) {
            ++argsLength;
        }
        if (this.isStatic) {
            ++argsLength;
        }
        argsLength = this.required < 4 && this.optional == 0 && !this.rest ? (argsLength += this.required) : ++argsLength;
        if (this.needsBlock) {
            ++argsLength;
        }
        return argsLength;
    }
}

