/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyArray;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.MultipleAsgnBase;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RestArgMultipleAsgnInstr
extends MultipleAsgnBase {
    private final int preArgsCount;
    private final int postArgsCount;

    public RestArgMultipleAsgnInstr(Variable result2, Operand array, int preArgsCount, int postArgsCount, int index2) {
        super(Operation.MASGN_REST, result2, array, index2);
        this.preArgsCount = preArgsCount;
        this.postArgsCount = postArgsCount;
    }

    public RestArgMultipleAsgnInstr(Variable result2, Operand array, int index2) {
        this(result2, array, -1, -1, index2);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.array + ", " + this.index + ", " + this.preArgsCount + ", " + this.postArgsCount + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new RestArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), this.array.cloneForInlining(ii), this.preArgsCount, this.postArgsCount, this.index);
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        RubyArray rubyArray = (RubyArray)this.array.retrieve(context, self2, currDynScope, temp);
        int n = rubyArray.getLength();
        if (this.preArgsCount >= n || this.preArgsCount + this.postArgsCount >= n) {
            return RubyArray.newEmptyArray(context.runtime);
        }
        return RubyArray.newArrayNoCopy(context.runtime, rubyArray.toJavaArray(), this.preArgsCount, n - this.preArgsCount - this.postArgsCount);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.RestArgMultipleAsgnInstr(this);
    }
}

