/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Operand;
import org.jruby.runtime.ThreadContext;

public class Float
extends ImmutableLiteral {
    public final double value;

    public Float(double value2) {
        this.value = value2;
    }

    @Override
    public boolean hasKnownValue() {
        return true;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return context.runtime.newFloat(this.value);
    }

    public String toString() {
        return "Float:" + this.value;
    }

    public Operand computeValue(String methodName, Operand arg2) {
        double v2;
        double v1 = this.value;
        double d = v2 = arg2 instanceof Fixnum ? 1.0 * (double)((Fixnum)arg2).value : ((Float)arg2).value;
        if (methodName.equals("+")) {
            return new Float(v1 + v2);
        }
        if (methodName.equals("-")) {
            return new Float(v1 - v2);
        }
        if (methodName.equals("*")) {
            return new Float(v1 * v2);
        }
        if (methodName.equals("/")) {
            return v2 == 0.0 ? null : new Float(v1 / v2);
        }
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Float(this);
    }

    public double getValue() {
        return this.value;
    }
}

