/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.RubyEncoding;
import org.jruby.platform.Platform;
import org.jruby.util.ByteList;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;

public class Dir {
    public static final boolean DOSISH = Platform.IS_WINDOWS;
    public static final boolean CASEFOLD_FILESYSTEM = DOSISH;
    public static final int FNM_NOESCAPE = 1;
    public static final int FNM_PATHNAME = 2;
    public static final int FNM_DOTMATCH = 4;
    public static final int FNM_CASEFOLD = 8;
    public static final int FNM_SYSCASE = CASEFOLD_FILESYSTEM ? 8 : 0;
    public static final int FNM_NOMATCH = 1;
    public static final int FNM_ERROR = 2;
    public static final byte[] EMPTY = new byte[0];
    public static final byte[] SLASH = new byte[]{47};
    public static final byte[] STAR = new byte[]{42};
    public static final byte[] DOUBLE_STAR = new byte[]{42, 42};
    public static final GlobFunc push_pattern = new GlobFunc(){

        @Override
        public int call(byte[] ptr, int p2, int len, Object ary) {
            ((List)ary).add(new ByteList(ptr, p2, len));
            return 0;
        }
    };
    public static final GlobFunc glob_caller = new GlobFunc(){

        @Override
        public int call(byte[] ptr, int p2, int len, Object ary) {
            GlobArgs args2 = (GlobArgs)ary;
            args2.c = p2;
            return args2.func.call(ptr, args2.c, len, args2.v);
        }
    };

    private static boolean isdirsep(byte c) {
        return c == 47 || DOSISH && c == 92;
    }

    private static int rb_path_next(byte[] _s, int s2, int send2) {
        while (s2 < send2 && !Dir.isdirsep(_s[s2])) {
            ++s2;
        }
        return s2;
    }

    private static int fnmatch_helper(byte[] bytes2, int pstart, int pend, byte[] string2, int sstart, int send2, int flags) {
        boolean nocase;
        int s2 = sstart;
        int pat = pstart;
        boolean escape = (flags & 1) == 0;
        boolean pathname2 = (flags & 2) != 0;
        boolean period = (flags & 4) == 0;
        boolean bl = nocase = (flags & 8) != 0;
        block6: while (pat < pend) {
            char c = bytes2[pat++];
            switch (c) {
                case '?': {
                    if (s2 >= send2 || pathname2 && Dir.isdirsep(string2[s2]) || period && string2[s2] == 46 && (s2 == 0 || pathname2 && Dir.isdirsep(string2[s2 - 1]))) {
                        return 1;
                    }
                    ++s2;
                    continue block6;
                }
                case '*': {
                    while (pat < pend && (c = bytes2[pat++]) == '*') {
                    }
                    if (s2 < send2 && period && string2[s2] == 46 && (s2 == 0 || pathname2 && Dir.isdirsep(string2[s2 - 1]))) {
                        return 1;
                    }
                    if (pat > pend || pat == pend && c == '*') {
                        if (pathname2 && Dir.rb_path_next(string2, s2, send2) < send2) {
                            return 1;
                        }
                        return 0;
                    }
                    if (pathname2 && Dir.isdirsep((byte)c)) {
                        if ((s2 = Dir.rb_path_next(string2, s2, send2)) < send2) {
                            ++s2;
                            continue block6;
                        }
                        return 1;
                    }
                    char test2 = (char)((escape && c == '\\' && pat < pend ? bytes2[pat] : c) & 0xFF);
                    test2 = Character.toLowerCase(test2);
                    --pat;
                    while (s2 < send2) {
                        if ((c == '?' || c == '[' || Character.toLowerCase((char)string2[s2]) == test2) && Dir.fnmatch(bytes2, pat, pend, string2, s2, send2, flags | 4) == 0) {
                            return 0;
                        }
                        if (pathname2 && Dir.isdirsep(string2[s2])) break;
                        ++s2;
                    }
                    return 1;
                }
                case '[': {
                    if (s2 >= send2 || pathname2 && Dir.isdirsep(string2[s2]) || period && string2[s2] == 46 && (s2 == 0 || pathname2 && Dir.isdirsep(string2[s2 - 1]))) {
                        return 1;
                    }
                    if ((pat = Dir.range(bytes2, pat, pend, (char)(string2[s2] & 0xFF), flags)) == -1) {
                        return 1;
                    }
                    ++s2;
                    continue block6;
                }
                case '\\': {
                    if (!escape) break;
                    c = pat >= pend ? (char)'\\' : bytes2[pat++];
                }
            }
            if (s2 >= send2) {
                return 1;
            }
            if (!(DOSISH && pathname2 && Dir.isdirsep((byte)c) && Dir.isdirsep(string2[s2]) || !(nocase ? Character.toLowerCase(c) != Character.toLowerCase((char)string2[s2]) : c != (char)string2[s2]))) {
                return 1;
            }
            ++s2;
        }
        return s2 >= send2 ? 0 : 1;
    }

    public static int fnmatch(byte[] bytes2, int pstart, int pend, byte[] string2, int sstart, int send2, int flags) {
        boolean period = (flags & 4) == 0;
        boolean pathname2 = (flags & 2) != 0;
        int pat_pos = pstart;
        int str_pos = sstart;
        int ptmp = -1;
        int stmp = -1;
        if (pathname2) {
            while (true) {
                int strSlashIdx;
                int patSlashIdx;
                if (Dir.isDoubleStarAndSlash(bytes2, pat_pos)) {
                    while (Dir.isDoubleStarAndSlash(bytes2, pat_pos += 3)) {
                    }
                    ptmp = pat_pos;
                    stmp = str_pos;
                }
                if (Dir.fnmatch_helper(bytes2, pat_pos, patSlashIdx = Dir.nextSlashIndex(bytes2, pat_pos, pend), string2, str_pos, strSlashIdx = Dir.nextSlashIndex(string2, str_pos, send2), flags) == 0) {
                    if (patSlashIdx < pend && strSlashIdx < send2) {
                        pat_pos = ++patSlashIdx;
                        str_pos = ++strSlashIdx;
                        continue;
                    }
                    if (patSlashIdx == pend && strSlashIdx == send2) {
                        return 0;
                    }
                }
                if (ptmp == -1 || stmp == -1 || period && string2[stmp] == 46 || (stmp = Dir.nextSlashIndex(string2, stmp, send2)) >= send2) break;
                pat_pos = ptmp;
                str_pos = ++stmp;
            }
            return 1;
        }
        return Dir.fnmatch_helper(bytes2, pstart, pend, string2, sstart, send2, flags);
    }

    private static boolean isDoubleStarAndSlash(byte[] bytes2, int pos2) {
        if (bytes2.length - pos2 <= 2) {
            return false;
        }
        return bytes2[pos2] == 42 && bytes2[pos2 + 1] == 42 && bytes2[pos2 + 2] == 47;
    }

    private static int nextSlashIndex(byte[] bytes2, int start2, int end2) {
        int idx;
        for (idx = start2; idx < end2 && idx < bytes2.length && bytes2[idx] != 47; ++idx) {
        }
        return idx;
    }

    public static int range(byte[] _pat, int pat, int pend, char test2, int flags) {
        boolean not;
        boolean ok = false;
        boolean nocase = (flags & 8) != 0;
        boolean escape = (flags & 1) == 0;
        boolean bl = not = _pat[pat] == 33 || _pat[pat] == 94;
        if (not) {
            ++pat;
        }
        if (nocase) {
            test2 = Character.toLowerCase(test2);
        }
        while (_pat[pat] != 93) {
            char cend;
            if (escape && _pat[pat] == 92) {
                ++pat;
            }
            if (pat >= pend) {
                return -1;
            }
            char cstart = cend = (char)(_pat[pat++] & 0xFF);
            if (_pat[pat] == 45 && _pat[pat + 1] != 93) {
                if (escape && _pat[++pat] == 92) {
                    ++pat;
                }
                if (pat >= pend) {
                    return -1;
                }
                cend = (char)(_pat[pat++] & 0xFF);
            }
            if (nocase) {
                if (Character.toLowerCase(cstart) > test2 || test2 > Character.toLowerCase(cend)) continue;
                ok = true;
                continue;
            }
            if (cstart > test2 || test2 > cend) continue;
            ok = true;
        }
        return ok == not ? -1 : pat + 1;
    }

    public static List<ByteList> push_glob(String cwd, ByteList globByteList, int flags) {
        ArrayList<ByteList> result2 = new ArrayList<ByteList>();
        if (globByteList.length() > 0) {
            Dir.push_braces(cwd, result2, new GlobPattern(globByteList, flags));
        }
        return result2;
    }

    private static int push_braces(String cwd, List<ByteList> result2, GlobPattern pattern) {
        pattern.reset();
        int lbrace = pattern.indexOf((byte)123);
        int rbrace = pattern.findClosingIndexOf(lbrace);
        if (lbrace == -1 || rbrace == -1 || lbrace > 0 && pattern.bytes[lbrace - 1] == 92 || rbrace > 0 && pattern.bytes[rbrace - 1] == 92) {
            ByteList unescaped = new ByteList(pattern.bytes.length - 1);
            for (int i2 = pattern.begin; i2 < pattern.end; ++i2) {
                byte b = pattern.bytes[i2];
                if (b == 92 && i2 < pattern.bytes.length - 1) {
                    byte next_b = pattern.bytes[i2 + 1];
                    if (next_b == 123 || next_b == 125) continue;
                    unescaped.append(b);
                    continue;
                }
                unescaped.append(b);
            }
            return Dir.push_globs(cwd, result2, unescaped.getUnsafeBytes(), unescaped.begin(), unescaped.length(), pattern.flags);
        }
        ByteList buf = new ByteList(20);
        int i3 = lbrace;
        while (pattern.bytes[i3] != 125) {
            int middleRegionIndex;
            for (i3 = middleRegionIndex = i3 + 1; i3 < pattern.end && pattern.bytes[i3] != 125 && pattern.bytes[i3] != 44; ++i3) {
                if (pattern.bytes[i3] != 123) continue;
                i3 = pattern.findClosingIndexOf(i3);
            }
            buf.length(0);
            buf.append(pattern.bytes, pattern.begin, lbrace - pattern.begin);
            buf.append(pattern.bytes, middleRegionIndex, i3 - middleRegionIndex);
            buf.append(pattern.bytes, rbrace + 1, pattern.end - (rbrace + 1));
            int status2 = Dir.push_braces(cwd, result2, new GlobPattern(buf.getUnsafeBytes(), buf.getBegin(), buf.getRealSize(), pattern.flags));
            if (status2 == 0) continue;
            return status2;
        }
        return 0;
    }

    private static int push_globs(String cwd, List<ByteList> ary, byte[] pattern, int pbegin, int pend, int pflags) {
        return Dir.glob_helper(cwd, pattern, pbegin, pend, -1, pflags |= FNM_SYSCASE, glob_caller, new GlobArgs(push_pattern, ary));
    }

    private static boolean has_magic(byte[] bytes2, int begin2, int end2, int flags) {
        boolean escape = (flags & 1) == 0;
        boolean nocase = (flags & 8) != 0;
        int open2 = 0;
        block6: for (int i2 = begin2; i2 < end2; ++i2) {
            switch (bytes2[i2]) {
                case 42: 
                case 63: {
                    return true;
                }
                case 91: {
                    ++open2;
                    continue block6;
                }
                case 93: {
                    if (open2 <= 0) continue block6;
                    return true;
                }
                case 92: {
                    if (!escape || i2 != end2) continue block6;
                    return false;
                }
                default: {
                    if (FNM_SYSCASE != 0 || !nocase || !Character.isLetter((char)(bytes2[i2] & 0xFF))) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    private static int remove_backslashes(byte[] bytes2, int index2, int len) {
        int t = index2;
        while (index2 < len && (bytes2[index2] != 92 || ++index2 != len)) {
            bytes2[t] = bytes2[index2];
            ++index2;
            ++t;
        }
        return t;
    }

    private static int strchr(byte[] bytes2, int begin2, int end2, byte ch) {
        for (int i2 = begin2; i2 < end2; ++i2) {
            if (bytes2[i2] != ch) continue;
            return i2;
        }
        return -1;
    }

    private static byte[] extract_path(byte[] bytes2, int begin2, int end2) {
        int len = end2 - begin2;
        if (!(len <= 1 || bytes2[end2 - 1] != 47 || DOSISH && len >= 2 && bytes2[end2 - 2] == 58)) {
            --len;
        }
        byte[] alloc = new byte[len];
        System.arraycopy(bytes2, begin2, alloc, 0, len);
        return alloc;
    }

    private static byte[] extract_elem(byte[] bytes2, int begin2, int end2) {
        int elementEnd = Dir.strchr(bytes2, begin2, end2, (byte)47);
        if (elementEnd == -1) {
            elementEnd = end2;
        }
        return Dir.extract_path(bytes2, begin2, elementEnd);
    }

    private static boolean beginsWithDriveLetter(byte[] path2, int begin2, int end2) {
        return DOSISH && begin2 + 2 < end2 && path2[begin2 + 1] == 58 && Dir.isdirsep(path2[begin2 + 2]);
    }

    private static boolean isRoot(byte[] base) {
        int length2 = base.length;
        return length2 == 0 || length2 == 1 && Dir.isdirsep(base[0]) || length2 == 3 && Dir.beginsWithDriveLetter(base, 0, length2);
    }

    private static boolean isAbsolutePath(byte[] path2, int begin2, int length2) {
        return Dir.isdirsep(path2[begin2]) || Dir.beginsWithDriveLetter(path2, begin2, length2);
    }

    private static String[] files(FileResource directory) {
        String[] files = directory.list();
        if (files != null) {
            return files;
        }
        return new String[0];
    }

    private static boolean isSpecialFile(String name2) {
        int length2 = name2.length();
        if (length2 < 1 || length2 > 3 || name2.charAt(0) != '.') {
            return false;
        }
        if (length2 == 1) {
            return true;
        }
        char c = name2.charAt(1);
        if (length2 == 2 && (c == '.' || c == '/')) {
            return true;
        }
        return c == '.' && name2.charAt(2) == '/';
    }

    private static int addToResultIfExists(String cwd, byte[] bytes2, int begin2, int end2, int flags, GlobFunc func, GlobArgs arg2) {
        String fileName = Dir.newStringFromUTF8(bytes2, begin2, end2 - begin2);
        FileResource file2 = JRubyFile.createResource(cwd, fileName);
        if (file2.exists()) {
            boolean trailingSlash = bytes2[end2 - 1] == 47;
            return func.call(bytes2, begin2, end2 - begin2, arg2);
        }
        return 0;
    }

    private static int glob_helper(String cwd, byte[] bytes2, int begin2, int end2, int sub3, int flags, GlobFunc func, GlobArgs arg2) {
        int p2;
        int status2 = 0;
        byte[] newpath = null;
        int n = p2 = sub3 != -1 ? sub3 : begin2;
        if (!Dir.has_magic(bytes2, p2, end2, flags)) {
            if (DOSISH || (flags & 1) == 0) {
                newpath = new byte[end2];
                System.arraycopy(bytes2, 0, newpath, 0, end2);
                if (sub3 != -1) {
                    p2 = sub3 - begin2;
                    end2 = Dir.remove_backslashes(newpath, p2, end2);
                    sub3 = p2;
                } else {
                    end2 = Dir.remove_backslashes(newpath, 0, end2);
                    bytes2 = newpath;
                }
            }
            if (Dir.isAbsolutePath(bytes2, begin2, end2)) {
                status2 = Dir.addToResultIfExists(null, bytes2, begin2, end2, flags, func, arg2);
            } else if (end2 - begin2 > 0) {
                status2 = Dir.addToResultIfExists(cwd, bytes2, begin2, end2, flags, func, arg2);
            }
            return status2;
        }
        ByteList buf = new ByteList(20);
        ArrayList<DirGlobber> link2 = new ArrayList<DirGlobber>();
        while (p2 != -1 && status2 == 0) {
            int m;
            block20: {
                FileResource st;
                block22: {
                    boolean recursive;
                    byte[] magic;
                    byte[] base;
                    block21: {
                        byte[] byArray;
                        if (bytes2[p2] == 47) {
                            ++p2;
                        }
                        if (!Dir.has_magic(bytes2, p2, (m = Dir.strchr(bytes2, p2, end2, (byte)47)) == -1 ? end2 : m, flags)) break block20;
                        base = Dir.extract_path(bytes2, begin2, p2);
                        if (begin2 == p2) {
                            byte[] byArray2 = new byte[1];
                            byArray = byArray2;
                            byArray2[0] = 46;
                        } else {
                            byArray = base;
                        }
                        byte[] dir = byArray;
                        magic = Dir.extract_elem(bytes2, p2, end2);
                        recursive = false;
                        st = JRubyFile.createResource(cwd, Dir.newStringFromUTF8(dir));
                        if (!st.isDirectory()) break;
                        if (m == -1 || !Arrays.equals(magic, DOUBLE_STAR)) break block21;
                        int n2 = base.length;
                        recursive = true;
                        buf.length(0);
                        buf.append(base);
                        buf.append(bytes2, base.length > 0 ? m : m + 1, end2 - (base.length > 0 ? m : m + 1));
                        status2 = Dir.glob_helper(cwd, buf.getUnsafeBytes(), buf.getBegin(), buf.getRealSize(), n2, flags, func, arg2);
                        if (status2 != 0) break block22;
                    }
                    String[] dirp = Dir.files(st);
                    for (int i2 = 0; i2 < dirp.length; ++i2) {
                        byte[] bs;
                        if (recursive) {
                            bs = Dir.getBytesInUTF8(dirp[i2]);
                            if (Dir.fnmatch(STAR, 0, 1, bs, 0, bs.length, flags) != 0) continue;
                            buf.length(0);
                            buf.append(base);
                            buf.append(Dir.isRoot(base) ? EMPTY : SLASH);
                            buf.append(Dir.getBytesInUTF8(dirp[i2]));
                            st = JRubyFile.createResource(cwd, Dir.newStringFromUTF8(buf.getUnsafeBytes(), buf.getBegin(), buf.getRealSize()));
                            if (st.isSymLink() || !st.isDirectory() || ".".equals(dirp[i2]) || "..".equals(dirp[i2])) continue;
                            int t = buf.getRealSize();
                            buf.append(SLASH);
                            buf.append(DOUBLE_STAR);
                            buf.append(bytes2, m, end2 - m);
                            status2 = Dir.glob_helper(cwd, buf.getUnsafeBytes(), buf.getBegin(), buf.getRealSize(), t, flags, func, arg2);
                            if (status2 == 0) continue;
                            break;
                        }
                        bs = Dir.getBytesInUTF8(dirp[i2]);
                        if (Dir.fnmatch(magic, 0, magic.length, bs, 0, bs.length, flags) != 0) continue;
                        buf.length(0);
                        buf.append(base);
                        buf.append(Dir.isRoot(base) ? EMPTY : SLASH);
                        buf.append(Dir.getBytesInUTF8(dirp[i2]));
                        if (m == -1) {
                            status2 = func.call(buf.getUnsafeBytes(), 0, buf.getRealSize(), arg2);
                            if (status2 == 0) continue;
                            break;
                        }
                        link2.add(new DirGlobber(buf));
                        buf = new ByteList(20);
                    }
                }
                if (link2.size() > 0) {
                    for (DirGlobber globber : link2) {
                        ByteList b = globber.link;
                        if (status2 != 0 || !(st = JRubyFile.createResource(cwd, Dir.newStringFromUTF8(b.getUnsafeBytes(), 0, b.getRealSize()))).isDirectory()) continue;
                        int len = b.getRealSize();
                        buf.length(0);
                        buf.append(b);
                        buf.append(bytes2, m, end2 - m);
                        status2 = Dir.glob_helper(cwd, buf.getUnsafeBytes(), 0, buf.getRealSize(), len, flags, func, arg2);
                    }
                    break;
                }
            }
            p2 = m;
        }
        return status2;
    }

    private static ByteList fixBytesForJarInUTF8(byte[] buf, int offset2, int len) {
        String path2 = Dir.newStringFromUTF8(buf, offset2, len);
        path2 = path2.replace(".jar/", ".jar!");
        return new ByteList(path2.getBytes());
    }

    private static byte[] getBytesInUTF8(String s2) {
        return RubyEncoding.encodeUTF8(s2);
    }

    private static String newStringFromUTF8(byte[] buf, int offset2, int len) {
        return RubyEncoding.decodeUTF8(buf, offset2, len);
    }

    private static String newStringFromUTF8(byte[] buf) {
        return RubyEncoding.decodeUTF8(buf);
    }

    private static final class DirGlobber {
        public final ByteList link;

        public DirGlobber(ByteList link2) {
            this.link = link2;
        }
    }

    private static class GlobArgs {
        GlobFunc func;
        int c = -1;
        List<ByteList> v;

        public GlobArgs(GlobFunc func, List<ByteList> arg2) {
            this.func = func;
            this.v = arg2;
        }
    }

    public static interface GlobFunc {
        public int call(byte[] var1, int var2, int var3, Object var4);
    }

    private static class GlobPattern {
        final byte[] bytes;
        final int begin;
        final int end;
        int flags;
        int index;

        public GlobPattern(ByteList bytelist, int flags) {
            this(bytelist.getUnsafeBytes(), bytelist.getBegin(), bytelist.getBegin() + bytelist.getRealSize(), flags);
        }

        public GlobPattern(byte[] bytes2, int index2, int end2, int flags) {
            this.bytes = bytes2;
            this.index = index2;
            this.begin = index2;
            this.end = end2;
            this.flags = flags;
        }

        public int findClosingIndexOf(int leftTokenIndex) {
            byte rightToken;
            if (leftTokenIndex == -1 || leftTokenIndex > this.end) {
                return -1;
            }
            byte leftToken = this.bytes[leftTokenIndex];
            switch (leftToken) {
                case 123: {
                    rightToken = 125;
                    break;
                }
                case 91: {
                    rightToken = 93;
                    break;
                }
                default: {
                    return -1;
                }
            }
            int nest = 1;
            this.index = leftTokenIndex + 1;
            while (this.hasNext()) {
                byte c = this.next();
                if (c == leftToken) {
                    ++nest;
                    continue;
                }
                if (c != rightToken || --nest != 0) continue;
                return this.index();
            }
            return -1;
        }

        public boolean hasNext() {
            return this.index < this.end;
        }

        public void reset() {
            this.index = this.begin;
        }

        public void setIndex(int value2) {
            this.index = value2;
        }

        public int index() {
            return this.index - 1;
        }

        public int indexOf(byte c) {
            while (this.hasNext()) {
                if (this.next() != c) continue;
                return this.index();
            }
            return -1;
        }

        public byte next() {
            return this.bytes[this.index++];
        }
    }
}

