/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.jruby.util.ClassDefiningJRubyClassLoader;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JRubyClassLoader
extends ClassDefiningJRubyClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger("JRubyClassLoader");
    private Runnable unloader;

    public JRubyClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public void addURL(URL url) {
        if (url.toString().contains("!/")) {
            InputStream in = null;
            OutputStream out = null;
            try {
                File f = File.createTempFile("jruby", new File(url.getFile()).getName());
                f.deleteOnExit();
                out = new BufferedOutputStream(new FileOutputStream(f));
                in = new BufferedInputStream(url.openStream());
                int i2 = in.read();
                while (i2 != -1) {
                    out.write(i2);
                    i2 = in.read();
                }
                out.close();
                in.close();
                url = f.toURI().toURL();
            }
            catch (IOException e) {
                throw new RuntimeException("BUG: we can not copy embedded jar to temp directory", e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        super.addURL(url);
    }

    public void tearDown(boolean debug) {
        block2: {
            try {
                this.getJDBCDriverUnloader().run();
            }
            catch (Exception e) {
                if (!debug) break block2;
                LOG.debug(e);
            }
        }
    }

    public synchronized Runnable getJDBCDriverUnloader() {
        if (this.unloader == null) {
            try {
                int bytesRead;
                InputStream unloaderStream = this.getClass().getResourceAsStream("/org/jruby/util/JDBCDriverUnloader.class");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((bytesRead = unloaderStream.read(buf)) != -1) {
                    baos.write(buf, 0, bytesRead);
                }
                Class<?> unloaderClass = this.defineClass("org.jruby.util.JDBCDriverUnloader", baos.toByteArray());
                this.unloader = (Runnable)unloaderClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.unloader;
    }
}

