/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jruby.RubyFile;

class JarCache {
    private final Map<String, JarIndex> indexCache = new WeakHashMap<String, JarIndex>();

    JarCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarIndex getIndex(String jarPath) {
        String cacheKey = jarPath;
        Map<String, JarIndex> map = this.indexCache;
        synchronized (map) {
            JarIndex index2 = this.indexCache.get(cacheKey);
            if (index2 != null && !index2.isValid()) {
                index2.release();
                index2 = null;
            }
            if (index2 == null) {
                try {
                    index2 = new JarIndex(jarPath);
                    this.indexCache.put(cacheKey, index2);
                }
                catch (IOException ioe) {
                    return null;
                }
            }
            return index2;
        }
    }

    static class JarIndex {
        private static final String ROOT_KEY = "";
        private final Map<String, String[]> cachedDirEntries;
        private final JarFile jar;
        private final long snapshotCalculated;

        JarIndex(String jarPath) throws IOException {
            this.jar = new JarFile(jarPath);
            this.snapshotCalculated = new File(jarPath).lastModified();
            HashMap mutableCache = new HashMap();
            mutableCache.put(ROOT_KEY, new HashSet());
            Enumeration<JarEntry> entries2 = this.jar.entries();
            while (entries2.hasMoreElements()) {
                int lastPathSep;
                JarEntry entry = entries2.nextElement();
                String path2 = entry.getName();
                while ((lastPathSep = path2.lastIndexOf(47)) != -1) {
                    String entryPath;
                    String dirPath = path2.substring(0, lastPathSep);
                    if (!mutableCache.containsKey(dirPath)) {
                        mutableCache.put(dirPath, new HashSet());
                    }
                    if ((entryPath = path2.substring(lastPathSep + 1)).length() > 0) {
                        ((Set)mutableCache.get(dirPath)).add(entryPath);
                    }
                    path2 = dirPath;
                }
                ((Set)mutableCache.get(ROOT_KEY)).add(path2);
            }
            HashMap cachedDirEntries = new HashMap();
            for (Map.Entry entry : mutableCache.entrySet()) {
                cachedDirEntries.put(entry.getKey(), ((Set)entry.getValue()).toArray(new String[0]));
            }
            this.cachedDirEntries = Collections.unmodifiableMap(cachedDirEntries);
        }

        public JarEntry getJarEntry(String entryPath) {
            return this.jar.getJarEntry(JarIndex.canonicalJarPath(entryPath));
        }

        public String[] getDirEntries(String entryPath) {
            return this.cachedDirEntries.get(JarIndex.canonicalJarPath(entryPath));
        }

        public InputStream getInputStream(JarEntry entry) {
            try {
                return this.jar.getInputStream(entry);
            }
            catch (IOException ioError) {
                return null;
            }
        }

        public void release() {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean isValid() {
            return new File(this.jar.getName()).lastModified() <= this.snapshotCalculated;
        }

        private static String canonicalJarPath(String path2) {
            String canonical = RubyFile.canonicalize(path2);
            if (canonical.startsWith("/") && !path2.startsWith("/")) {
                canonical = canonical.substring(1);
            }
            return canonical;
        }
    }
}

