/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledIRBlockBody;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class YieldSite
extends MutableCallSite {
    private final boolean unwrap;
    public static final Handle BOOTSTRAP = new Handle(6, CodegenUtils.p(YieldSite.class), "bootstrap", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE));

    public YieldSite(MethodType type2, boolean unwrap) {
        super(type2);
        this.unwrap = unwrap;
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, int unwrap) throws Throwable {
        YieldSite site = new YieldSite(type2, unwrap == 1);
        MethodHandle handle = Binder.from((MethodType)type2).prepend(YieldSite.class, (Object)site).invokeVirtual(lookup, name2);
        site.setTarget(handle);
        return site;
    }

    public IRubyObject yield(ThreadContext context, Block block, IRubyObject arg2) throws Throwable {
        if (block.getBody() instanceof CompiledIRBlockBody) {
            CompiledIRBlockBody compiledBody = (CompiledIRBlockBody)block.getBody();
            MethodHandle target = this.unwrap ? compiledBody.getNormalYieldUnwrapHandle() : compiledBody.getNormalYieldHandle();
            MethodHandle fallback = this.getTarget();
            MethodHandle test2 = compiledBody.getTestBlockBody();
            MethodHandle guard = MethodHandles.guardWithTest(test2, target, fallback);
            this.setTarget(guard);
            return target.invokeExact(context, block, arg2);
        }
        context.setCurrentBlockType(Block.Type.NORMAL);
        return IRRuntimeHelpers.yield(context, block, arg2, this.unwrap);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Block block) throws Throwable {
        if (block.getBody() instanceof CompiledIRBlockBody) {
            CompiledIRBlockBody compiledBody = (CompiledIRBlockBody)block.getBody();
            MethodHandle target = compiledBody.getNormalYieldSpecificHandle();
            MethodHandle fallback = this.getTarget();
            MethodHandle test2 = compiledBody.getTestBlockBody();
            MethodHandle guard = MethodHandles.guardWithTest(test2, target, fallback);
            this.setTarget(guard);
            return target.invokeExact(context, block);
        }
        context.setCurrentBlockType(Block.Type.NORMAL);
        return IRRuntimeHelpers.yieldSpecific(context, block);
    }
}

