/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingError;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.util.IntHash;
import org.joni.Matcher;
import org.jruby.ObjectFlags;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerator;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHolder;
import org.jruby.util.CodeRangeSupport;
import org.jruby.util.CodeRangeable;
import org.jruby.util.Sprintf;
import org.jruby.util.collections.IntHashMap;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.unsafe.UnsafeHolder;
import sun.misc.Unsafe;

public final class StringSupport {
    public static final int CR_7BIT_F = ObjectFlags.CR_7BIT_F;
    public static final int CR_VALID_F = ObjectFlags.CR_VALID_F;
    public static final int CR_UNKNOWN = 0;
    public static final int CR_7BIT = 16;
    public static final int CR_VALID = 32;
    public static final int CR_BROKEN = 48;
    public static final int CR_MASK = 48;
    static final int ARRAY_BYTE_BASE_OFFSET;
    public static final int TRANS_SIZE = 256;
    public static final ByteList[] EMPTY_BYTELIST_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY;
    private static final long NONASCII_MASK = -9187201950435737472L;
    private static final int LONG_SIZE = 8;
    private static final int LOWBITS = 7;
    private static final Object DUMMY_VALUE;
    private static final int NULL_POINTER = -1;
    private static final int CASE_MAPPING_ADDITIONAL_LENGTH = 20;

    public static List<String> split(String str, char sep) {
        return StringSupport.split(str, sep, 0);
    }

    public static List<String> split(String str, char sep, int lim) {
        int e;
        int len = str.length();
        if (len == 0) {
            return Collections.singletonList(str);
        }
        ArrayList<String> result2 = new ArrayList<String>(lim <= 0 ? 8 : lim);
        int s2 = 0;
        int count2 = 0;
        while ((e = str.indexOf(sep, s2)) != -1) {
            if (lim == ++count2) {
                result2.add(str.substring(s2));
                return result2;
            }
            result2.add(str.substring(s2, e));
            s2 = e + 1;
        }
        if (s2 < len || s2 == len && lim > 0) {
            result2.add(str.substring(s2));
        }
        return result2;
    }

    public static boolean startsWith(CharSequence str, String prefix) {
        int p2 = prefix.length();
        if (p2 > str.length()) {
            return false;
        }
        int i2 = 0;
        while (--p2 >= 0) {
            if (str.charAt(i2) != prefix.charAt(i2)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean startsWith(CharSequence str, char c) {
        return str.length() >= 1 && str.charAt(0) == c;
    }

    public static boolean startsWith(CharSequence str, char c1, char c2) {
        return str.length() >= 2 && str.charAt(0) == c1 && str.charAt(1) == c2;
    }

    public static int lastIndexOf(CharSequence str, char c, int index2) {
        while (index2 >= 0) {
            if (str.charAt(index2) == c) {
                return index2;
            }
            --index2;
        }
        return -1;
    }

    public static boolean contentEquals(CharSequence str, int chr2) {
        return str.length() == 1 && str.charAt(0) == chr2;
    }

    public static boolean contentEquals(CharSequence str, int chr1, int chr2) {
        return str.length() == 2 && str.charAt(0) == chr1 && str.charAt(1) == chr2;
    }

    public static CharSequence concat(CharSequence str1, CharSequence str2) {
        return new StringBuilder(str1.length() + str2.length()).append(str1).append(str2);
    }

    public static String delete(String str, char c) {
        char[] ary = null;
        int end2 = 0;
        int s2 = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (str.charAt(i2) != c) continue;
            if (ary == null) {
                ary = new char[str.length() - 1];
            }
            end2 = StringSupport.copy(str, s2, i2 - s2, ary, end2);
            s2 = i2 + 1;
        }
        return ary == null ? str : new String(ary, 0, end2);
    }

    public static CharSequence replaceFirst(String str, String sub3, String repl) {
        return StringSupport.replaceImpl(str, sub3, repl, 1, false);
    }

    public static CharSequence replaceAll(String str, String sub3, String repl) {
        return StringSupport.replaceImpl(str, sub3, repl, -1, false);
    }

    private static CharSequence replaceImpl(String str, String sub3, String repl, int max2, boolean ignoreCase) {
        int start2;
        int end2;
        if (str.length() == 0 || sub3.length() == 0) {
            return str;
        }
        String search = str;
        if (ignoreCase) {
            search = str.toLowerCase();
            sub3 = sub3.toLowerCase();
        }
        if ((end2 = search.indexOf(sub3, start2 = 0)) == -1) {
            return str;
        }
        int replLength = sub3.length();
        int increase = repl.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(str.length() + (increase *= max2 < 0 ? 16 : (max2 > 64 ? 64 : max2)));
        while (end2 != -1) {
            buf.append(str, start2, end2).append(repl);
            start2 = end2 + replLength;
            if (--max2 == 0) break;
            end2 = search.indexOf(sub3, start2);
        }
        buf.append(str, start2, str.length());
        return buf;
    }

    private static int copy(String str, int soff, int slen, char[] dest, int doff) {
        switch (slen) {
            case 0: {
                break;
            }
            case 1: {
                dest[doff++] = str.charAt(soff);
                break;
            }
            case 2: {
                dest[doff++] = str.charAt(soff);
                dest[doff++] = str.charAt(soff + 1);
                break;
            }
            case 3: {
                dest[doff++] = str.charAt(soff);
                dest[doff++] = str.charAt(soff + 1);
                dest[doff++] = str.charAt(soff + 2);
                break;
            }
            default: {
                for (int s2 = soff; s2 < slen; ++s2) {
                    dest[doff++] = str.charAt(s2);
                }
            }
        }
        return doff;
    }

    public static String codeRangeAsString(int codeRange) {
        switch (codeRange) {
            case 0: {
                return "unknown";
            }
            case 16: {
                return "7bit";
            }
            case 32: {
                return "valid";
            }
            case 48: {
                return "broken";
            }
        }
        return "???";
    }

    public static int encFastMBCLen(byte[] bytes2, int p2, int e, Encoding enc) {
        return enc.length(bytes2, p2, e);
    }

    public static int length(Encoding enc, byte[] bytes2, int p2, int end2) {
        int n = enc.length(bytes2, p2, end2);
        if (StringSupport.MBCLEN_CHARFOUND_P(n) && StringSupport.MBCLEN_CHARFOUND_LEN(n) <= end2 - p2) {
            return StringSupport.MBCLEN_CHARFOUND_LEN(n);
        }
        int min2 = enc.minLength();
        return min2 <= end2 - p2 ? min2 : end2 - p2;
    }

    public static int preciseLength(Encoding enc, byte[] bytes2, int p2, int end2) {
        if (p2 >= end2) {
            return StringSupport.MBCLEN_NEEDMORE(1);
        }
        int n = enc.length(bytes2, p2, end2);
        if (n > end2 - p2) {
            return StringSupport.MBCLEN_NEEDMORE(n - (end2 - p2));
        }
        return n;
    }

    public static boolean MBCLEN_NEEDMORE_P(int r) {
        return r < -1;
    }

    public static int MBCLEN_NEEDMORE(int n) {
        return -1 - n;
    }

    public static int MBCLEN_NEEDMORE_LEN(int r) {
        return -1 - r;
    }

    public static boolean MBCLEN_INVALID_P(int r) {
        return r == -1;
    }

    public static int MBCLEN_CHARFOUND_LEN(int r) {
        return r;
    }

    public static boolean MBCLEN_CHARFOUND_P(int r) {
        return 0 < r;
    }

    public static int CONSTRUCT_MBCLEN_CHARFOUND(int n) {
        return n;
    }

    public static int searchNonAscii(byte[] bytes2, int p2, int end2) {
        while (p2 < end2) {
            if (!Encoding.isAscii((byte)bytes2[p2])) {
                return p2;
            }
            ++p2;
        }
        return -1;
    }

    public static int searchNonAscii(ByteList bytes2) {
        return StringSupport.searchNonAscii(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static int codeRangeScan(Encoding enc, byte[] bytes2, int p2, int len) {
        if (enc == ASCIIEncoding.INSTANCE) {
            return StringSupport.searchNonAscii(bytes2, p2, p2 + len) != -1 ? 32 : 16;
        }
        if (enc.isAsciiCompatible()) {
            return StringSupport.codeRangeScanAsciiCompatible(enc, bytes2, p2, len);
        }
        return StringSupport.codeRangeScanNonAsciiCompatible(enc, bytes2, p2, len);
    }

    private static int codeRangeScanAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int len) {
        int end2 = p2 + len;
        if ((p2 = StringSupport.searchNonAscii(bytes2, p2, end2)) == -1) {
            return 16;
        }
        while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (cl <= 0) {
                return 48;
            }
            if ((p2 += cl) >= end2 || (p2 = StringSupport.searchNonAscii(bytes2, p2, end2)) != -1) continue;
            return 32;
        }
        return p2 > end2 ? 48 : 32;
    }

    private static int codeRangeScanNonAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int len) {
        int end2 = p2 + len;
        while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (cl <= 0) {
                return 48;
            }
            p2 += cl;
        }
        return p2 > end2 ? 48 : 32;
    }

    public static int codeRangeScan(Encoding enc, ByteList bytes2) {
        return StringSupport.codeRangeScan(enc, bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize());
    }

    public static long codeRangeScanRestartable(Encoding enc, byte[] bytes2, int s2, int end2, int cr) {
        int p2;
        if (cr == 48) {
            return StringSupport.pack(end2 - s2, cr);
        }
        if (enc == ASCIIEncoding.INSTANCE) {
            return StringSupport.pack(end2 - s2, StringSupport.searchNonAscii(bytes2, p2, end2) == -1 && cr != 32 ? 16 : 32);
        }
        if (enc.isAsciiCompatible()) {
            if ((p2 = StringSupport.searchNonAscii(bytes2, p2, end2)) == -1) {
                return StringSupport.pack(end2 - s2, cr != 32 ? 16 : cr);
            }
            while (p2 < end2) {
                int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                if (cl <= 0) {
                    return StringSupport.pack(p2 - s2, cl == -1 ? 48 : 0);
                }
                if ((p2 += cl) >= end2 || (p2 = StringSupport.searchNonAscii(bytes2, p2, end2)) != -1) continue;
                return StringSupport.pack(end2 - s2, 32);
            }
        } else {
            int cl;
            for (p2 = s2; p2 < end2; p2 += cl) {
                cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                if (cl > 0) continue;
                return StringSupport.pack(p2 - s2, cl == -1 ? 48 : 0);
            }
        }
        return StringSupport.pack(p2 - s2, p2 > end2 ? 48 : 32);
    }

    private static int countUtf8LeadBytes(long d) {
        d |= d >>> 1 ^ 0xFFFFFFFFFFFFFFFFL;
        d >>>= 6;
        d &= 0x101010101010101L;
        d += d >>> 8;
        d += d >>> 16;
        d += d >>> 32;
        return (int)(d & 0xFL);
    }

    public static int utf8Length(byte[] bytes2, int p2, int end2) {
        int len = 0;
        if (ARRAY_BYTE_BASE_OFFSET > 0 && end2 - p2 > 16) {
            int ep = 0xFFFFFFF8 & p2 + 7;
            while (p2 < ep) {
                if ((bytes2[p2++] & 0xC0) == 128) continue;
                ++len;
            }
            Unsafe unsafe = UnsafeHolder.U;
            int eend = 0xFFFFFFF8 & end2;
            while (p2 < eend) {
                len += StringSupport.countUtf8LeadBytes(unsafe.getLong(bytes2, ARRAY_BYTE_BASE_OFFSET + p2));
                p2 += 8;
            }
        }
        while (p2 < end2) {
            if ((bytes2[p2++] & 0xC0) == 128) continue;
            ++len;
        }
        return len;
    }

    public static int utf8Length(ByteList bytes2) {
        return StringSupport.utf8Length(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static int strLength(Encoding enc, byte[] bytes2, int p2, int end2) {
        return StringSupport.strLength(enc, bytes2, p2, end2, 0);
    }

    public static int strLength(Encoding enc, byte[] bytes2, int p2, int e, int cr) {
        if (enc.isFixedWidth()) {
            return (e - p2 + enc.minLength() - 1) / enc.minLength();
        }
        if (enc.isAsciiCompatible()) {
            int c = 0;
            if (cr == 16 || cr == 32) {
                while (p2 < e) {
                    if (Encoding.isAscii((byte)bytes2[p2])) {
                        int q = StringSupport.searchNonAscii(bytes2, p2, e);
                        if (q == -1) {
                            return c + (e - p2);
                        }
                        c += q - p2;
                        p2 = q;
                    }
                    p2 += StringSupport.encFastMBCLen(bytes2, p2, e, enc);
                    ++c;
                }
            } else {
                while (p2 < e) {
                    if (Encoding.isAscii((byte)bytes2[p2])) {
                        int q = StringSupport.searchNonAscii(bytes2, p2, e);
                        if (q == -1) {
                            return c + (e - p2);
                        }
                        c += q - p2;
                        p2 = q;
                    }
                    p2 += StringSupport.length(enc, bytes2, p2, e);
                    ++c;
                }
            }
            return c;
        }
        int c = 0;
        while (p2 < e) {
            p2 += StringSupport.length(enc, bytes2, p2, e);
            ++c;
        }
        return c;
    }

    public static int strLength(ByteList bytes2) {
        return StringSupport.strLength(bytes2.getEncoding(), bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static long strLengthWithCodeRange(Encoding enc, byte[] bytes2, int p2, int end2) {
        if (enc.isFixedWidth()) {
            return (end2 - p2 + enc.minLength() - 1) / enc.minLength();
        }
        if (enc.isAsciiCompatible()) {
            return StringSupport.strLengthWithCodeRangeAsciiCompatible(enc, bytes2, p2, end2);
        }
        return StringSupport.strLengthWithCodeRangeNonAsciiCompatible(enc, bytes2, p2, end2);
    }

    public static long strLengthWithCodeRangeAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int end2) {
        int cr = 0;
        int c = 0;
        while (p2 < end2) {
            int cl;
            if (Encoding.isAscii((byte)bytes2[p2])) {
                int q = StringSupport.searchNonAscii(bytes2, p2, end2);
                if (q == -1) {
                    return StringSupport.pack(c + (end2 - p2), cr == 0 ? 16 : cr);
                }
                c += q - p2;
                p2 = q;
            }
            if ((cl = StringSupport.preciseLength(enc, bytes2, p2, end2)) > 0) {
                cr |= 0x20;
                p2 += cl;
            } else {
                cr = 48;
                ++p2;
            }
            ++c;
        }
        return StringSupport.pack(c, cr == 0 ? 16 : cr);
    }

    public static long strLengthWithCodeRangeNonAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int end2) {
        int cr = 0;
        int c = 0;
        while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (cl > 0) {
                cr |= 0x20;
                p2 += cl;
            } else {
                cr = 48;
                ++p2;
            }
            ++c;
        }
        return StringSupport.pack(c, cr == 0 ? 16 : cr);
    }

    public static long strLengthWithCodeRange(ByteList bytes2) {
        return StringSupport.strLengthWithCodeRange(bytes2.getEncoding(), bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static long strLengthWithCodeRange(ByteList bytes2, Encoding enc) {
        return StringSupport.strLengthWithCodeRange(enc, bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static long pack(int result2, int arg2) {
        return (long)arg2 << 31 | (long)result2;
    }

    public static int unpackResult(long len) {
        return (int)len & Integer.MAX_VALUE;
    }

    public static int unpackArg(long cr) {
        return (int)(cr >>> 31);
    }

    public static int codePoint(Encoding enc, byte[] bytes2, int p2, int end2) {
        if (p2 >= end2) {
            throw new IllegalArgumentException("empty string");
        }
        int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
        if (cl <= 0) {
            throw new IllegalArgumentException("invalid byte sequence in " + enc);
        }
        return enc.mbcToCode(bytes2, p2, end2);
    }

    public static int codePoint(Ruby runtime2, Encoding enc, byte[] bytes2, int p2, int end2) {
        try {
            return StringSupport.codePoint(enc, bytes2, p2, end2);
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError(e.getMessage());
        }
    }

    public static int codePoint(Ruby runtime2, ByteList value2) {
        return StringSupport.codePoint(runtime2, EncodingUtils.getEncoding(value2), value2.getUnsafeBytes(), value2.getBegin(), value2.getBegin() + value2.getRealSize());
    }

    public static int codeLength(Encoding enc, int c) {
        int i2 = enc.codeToMbcLength(c);
        return StringSupport.checkCodepointError(i2);
    }

    public static int checkCodepointError(int i2) {
        if (i2 < 0) {
            throw new EncodingException(EncodingError.fromCode((int)i2));
        }
        return i2;
    }

    public static long getAscii(Encoding enc, byte[] bytes2, int p2, int end2) {
        return StringSupport.getAscii(enc, bytes2, p2, end2, 0);
    }

    public static long getAscii(Encoding enc, byte[] bytes2, int p2, int end2, int len) {
        if (p2 >= end2) {
            return StringSupport.pack(-1, len);
        }
        if (enc.isAsciiCompatible()) {
            int c = bytes2[p2] & 0xFF;
            if (!Encoding.isAscii((int)c)) {
                return StringSupport.pack(-1, len);
            }
            return StringSupport.pack(c, len == 0 ? 0 : 1);
        }
        int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
        if (cl <= 0) {
            return StringSupport.pack(-1, len);
        }
        int c = enc.mbcToCode(bytes2, p2, end2);
        if (!Encoding.isAscii((int)c)) {
            return StringSupport.pack(-1, len);
        }
        return StringSupport.pack(c, len == 0 ? 0 : cl);
    }

    public static int preciseCodePoint(Encoding enc, byte[] bytes2, int p2, int end2) {
        int l = StringSupport.preciseLength(enc, bytes2, p2, end2);
        if (l > 0) {
            return enc.mbcToCode(bytes2, p2, end2);
        }
        return -1;
    }

    public static int utf8Nth(byte[] bytes2, int p2, int e, int nth) {
        while (p2 < e) {
            if ((bytes2[p2] & 0xC0) != 128) {
                if (nth == 0) break;
                --nth;
            }
            ++p2;
        }
        return p2;
    }

    public static int nth(Encoding enc, byte[] bytes2, int p2, int end2, int n) {
        return StringSupport.nth(enc, bytes2, p2, end2, n, enc.isSingleByte());
    }

    public static int nth(Encoding enc, byte[] bytes2, int p2, int end2, int n, boolean singlebyte) {
        p2 = singlebyte ? (p2 += n) : (enc.isFixedWidth() ? (p2 += n * enc.maxLength()) : (enc.isAsciiCompatible() ? StringSupport.nthAsciiCompatible(enc, bytes2, p2, end2, n) : StringSupport.nthNonAsciiCompatible(enc, bytes2, p2, end2, n)));
        if (p2 < 0) {
            return -1;
        }
        return p2 > end2 ? end2 : p2;
    }

    private static int nthAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int end2, int n) {
        while (p2 < end2 && n > 0) {
            int end22 = p2 + n;
            if (end2 < end22) {
                return end2;
            }
            if (Encoding.isAscii((byte)bytes2[p2])) {
                int p22 = StringSupport.searchNonAscii(bytes2, p2, end22);
                if (p22 == -1) {
                    return end22;
                }
                n -= p22 - p2;
                p2 = p22;
            }
            int cl = StringSupport.length(enc, bytes2, p2, end2);
            p2 += cl;
            --n;
        }
        return n != 0 ? end2 : p2;
    }

    private static int nthNonAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int end2, int n) {
        while (p2 < end2 && n-- != 0) {
            p2 += StringSupport.length(enc, bytes2, p2, end2);
        }
        return p2;
    }

    public static int utf8Offset(byte[] bytes2, int p2, int end2, int n) {
        int pp = StringSupport.utf8Nth(bytes2, p2, end2, n);
        return pp == -1 ? end2 - p2 : pp - p2;
    }

    public static int offset(Encoding enc, byte[] bytes2, int p2, int end2, int n) {
        int pp = StringSupport.nth(enc, bytes2, p2, end2, n);
        return pp == -1 ? end2 - p2 : pp - p2;
    }

    public static int offset(Encoding enc, byte[] bytes2, int p2, int end2, int n, boolean singlebyte) {
        int pp = StringSupport.nth(enc, bytes2, p2, end2, n, singlebyte);
        return pp == -1 ? end2 - p2 : pp - p2;
    }

    public static int offset(RubyString str, int pos2) {
        ByteList value2 = str.getByteList();
        return StringSupport.offset(str.getEncoding(), value2.getUnsafeBytes(), value2.getBegin(), value2.getBegin() + value2.getRealSize(), pos2);
    }

    @Deprecated
    public static int toLower(Encoding enc, int c) {
        return Encoding.isAscii((int)c) ? AsciiTables.ToLowerCaseTable[c] : c;
    }

    @Deprecated
    public static int toUpper(Encoding enc, int c) {
        return Encoding.isAscii((int)c) ? AsciiTables.ToUpperCaseTable[c] : c;
    }

    public static int caseCmp(byte[] bytes1, int p1, byte[] bytes2, int p2, int len) {
        int i2 = -1;
        while (++i2 < len && bytes1[p1 + i2] == bytes2[p2 + i2]) {
        }
        if (i2 < len) {
            return (bytes1[p1 + i2] & 0xFF) > (bytes2[p2 + i2] & 0xFF) ? 1 : -1;
        }
        return 0;
    }

    public static int scanHex(byte[] bytes2, int p2, int len) {
        return StringSupport.scanHex(bytes2, p2, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int scanHex(byte[] bytes2, int p2, int len, Encoding enc) {
        int c;
        int v = 0;
        while (len-- > 0 && enc.isXDigit(c = bytes2[p2++] & 0xFF)) {
            v = (v << 4) + enc.xdigitVal(c);
        }
        return v;
    }

    public static int hexLength(byte[] bytes2, int p2, int len) {
        return StringSupport.hexLength(bytes2, p2, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int hexLength(byte[] bytes2, int p2, int len, Encoding enc) {
        int hlen = 0;
        while (len-- > 0 && enc.isXDigit(bytes2[p2++] & 0xFF)) {
            ++hlen;
        }
        return hlen;
    }

    public static int scanOct(byte[] bytes2, int p2, int len) {
        return StringSupport.scanOct(bytes2, p2, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int scanOct(byte[] bytes2, int p2, int len, Encoding enc) {
        int c;
        int v = 0;
        while (len-- > 0 && enc.isDigit(c = bytes2[p2++] & 0xFF) && c < 56) {
            v = (v << 3) + Encoding.digitVal((int)c);
        }
        return v;
    }

    public static int octLength(byte[] bytes2, int p2, int len) {
        return StringSupport.octLength(bytes2, p2, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int octLength(byte[] bytes2, int p2, int len, Encoding enc) {
        int c;
        int olen = 0;
        while (len-- > 0 && enc.isDigit(c = bytes2[p2++] & 0xFF) && c < 56) {
            ++olen;
        }
        return olen;
    }

    public static final void checkStringSafety(Ruby runtime2, IRubyObject value2) {
        RubyString s2 = value2.asString();
        ByteList bl = s2.getByteList();
        byte[] array2 = bl.getUnsafeBytes();
        int end2 = bl.length();
        for (int i2 = bl.begin(); i2 < end2; ++i2) {
            if (array2[i2] != 0) continue;
            throw runtime2.newSecurityError("string contains null byte");
        }
    }

    public static String escapedCharFormat(int c, boolean isUnicode) {
        String format = isUnicode ? (((long)c & 0xFFFFFFFFL) < 127L && Encoding.isAscii((int)c) && ASCIIEncoding.INSTANCE.isPrint(c) ? "%c" : (c < 65536 ? "\\u%04X" : "\\u{%X}")) : (((long)c & 0xFFFFFFFFL) < 256L ? "\\x%02X" : "\\x{%X}");
        return format;
    }

    public static boolean isIncompleteChar(int b2) {
        return b2 < -1;
    }

    public static int bytesToFixBrokenTrailingCharacter(ByteList val, int usingLength) {
        return StringSupport.bytesToFixBrokenTrailingCharacter(val.getUnsafeBytes(), val.getBegin(), val.getRealSize(), val.getEncoding(), usingLength);
    }

    public static int bytesToFixBrokenTrailingCharacter(byte[] bytes2, int begin2, int byteSize, Encoding encoding2, int usingLength) {
        if (byteSize > 0) {
            int charHead = encoding2.leftAdjustCharHead(bytes2, begin2, begin2 + usingLength - 1, begin2 + usingLength);
            byte byteHead = (byte)(bytes2[begin2 + (charHead -= begin2)] & 0xFF);
            int extra = encoding2.length(byteHead);
            return extra -= usingLength - charHead;
        }
        return 0;
    }

    public static int memchr(byte[] ptr, int start2, int find2, int len) {
        for (int i2 = start2; i2 < start2 + len; ++i2) {
            if (ptr[i2] != find2) continue;
            return i2;
        }
        return -1;
    }

    public static RubyString checkEmbeddedNulls(Ruby runtime2, IRubyObject ptr) {
        RubyString s2 = ptr.convertToString();
        ByteList sByteList = s2.getByteList();
        byte[] sBytes = sByteList.unsafeBytes();
        int beg = sByteList.begin();
        int len = sByteList.length();
        Encoding enc = s2.getEncoding();
        int minlen = enc.minLength();
        if (minlen > 1) {
            if (StringSupport.strNullChar(sBytes, beg, len, minlen, enc) != -1) {
                throw runtime2.newArgumentError("string contains null char");
            }
            return StringSupport.strFillTerm(s2, sBytes, beg, len, minlen);
        }
        if (StringSupport.memchr(sBytes, beg, 0, len) != -1) {
            throw runtime2.newArgumentError("string contains null byte");
        }
        return s2;
    }

    private static int strNullChar(byte[] sBytes, int s2, int len, int minlen, Encoding enc) {
        int e = s2 + len;
        while (s2 + minlen <= e) {
            if (StringSupport.zeroFilled(sBytes, s2, minlen)) {
                return s2;
            }
            s2 += enc.length(sBytes, s2, e);
        }
        return -1;
    }

    private static boolean zeroFilled(byte[] sBytes, int s2, int n) {
        while (n > 0) {
            if (sBytes[s2++] != 0) {
                return false;
            }
            --n;
        }
        return true;
    }

    private static RubyString strFillTerm(RubyString str, byte[] sBytes, int beg, int len, int termlen) {
        int capa = sBytes.length - beg;
        if (capa < len + termlen) {
            str = str.makeIndependent(len + termlen);
            sBytes = str.getByteList().unsafeBytes();
            beg = str.getByteList().begin();
        } else if (!str.independent() && !StringSupport.zeroFilled(sBytes, beg + len, termlen)) {
            str = str.makeIndependent(len + termlen);
            sBytes = str.getByteList().unsafeBytes();
            beg = str.getByteList().begin();
        }
        StringSupport.TERM_FILL(sBytes, beg, len, termlen);
        return str;
    }

    private static void TERM_FILL(byte[] ptr, int beg, int len, int termlen) {
        int p2 = beg + len;
        Arrays.fill(ptr, p2, p2 + termlen, (byte)0);
    }

    public static int positionEndForScan(ByteList value2, Matcher matcher, Encoding enc, int begin2, int range) {
        int end2 = matcher.getEnd();
        if (matcher.getBegin() == end2) {
            if (value2.getRealSize() > end2) {
                return end2 + enc.length(value2.getUnsafeBytes(), begin2 + end2, range);
            }
            return end2 + 1;
        }
        return end2;
    }

    public static ByteList dumpCommon(Ruby runtime2, ByteList bytelist) {
        return StringSupport.dumpCommon(runtime2, bytelist, false);
    }

    public static ByteList dumpCommon(Ruby runtime2, ByteList byteList, boolean quoteOnlyIfNeeded) {
        Encoding enc = byteList.getEncoding();
        boolean includingsNonprintable = false;
        int p2 = byteList.getBegin();
        int end2 = p2 + byteList.getRealSize();
        byte[] bytes2 = byteList.getUnsafeBytes();
        int len = 2;
        block16: while (p2 < end2) {
            int n;
            int c = bytes2[p2++] & 0xFF;
            switch (c) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 27: 
                case 34: 
                case 92: {
                    len += 2;
                    continue block16;
                }
                case 35: {
                    len += StringSupport.isEVStr(bytes2, p2, end2) ? 2 : 1;
                    continue block16;
                }
            }
            if (ASCIIEncoding.INSTANCE.isPrint(c)) {
                ++len;
                continue;
            }
            includingsNonprintable = true;
            if (enc.isUTF8() && c > 127 && StringSupport.MBCLEN_CHARFOUND_LEN(n = StringSupport.preciseLength(enc, bytes2, p2 - 1, end2) - 1) > 0) {
                int cc = StringSupport.codePoint(runtime2, enc, bytes2, p2 - 1, end2);
                len = cc <= 65535 ? (len += 6) : (cc <= 1048575 ? (len += 9) : (len += 10));
                p2 += StringSupport.MBCLEN_CHARFOUND_LEN(n) - 1;
                continue;
            }
            len += 4;
        }
        if (!enc.isAsciiCompatible()) {
            len += ".force_encoding(\"".length() + enc.getName().length + "\")".length();
        }
        ByteList outBytes = new ByteList(len);
        byte[] out = outBytes.getUnsafeBytes();
        int q = 0;
        p2 = byteList.getBegin();
        end2 = p2 + byteList.getRealSize();
        if (quoteOnlyIfNeeded && includingsNonprintable || !quoteOnlyIfNeeded) {
            out[q++] = 34;
        }
        block17: while (p2 < end2) {
            int n;
            int c = bytes2[p2++] & 0xFF;
            switch (c) {
                case 34: 
                case 92: {
                    out[q++] = 92;
                    out[q++] = (byte)c;
                    continue block17;
                }
                case 35: {
                    if (StringSupport.isEVStr(bytes2, p2, end2)) {
                        out[q++] = 92;
                    }
                    out[q++] = 35;
                    continue block17;
                }
                case 10: {
                    out[q++] = 92;
                    out[q++] = 110;
                    continue block17;
                }
                case 13: {
                    out[q++] = 92;
                    out[q++] = 114;
                    continue block17;
                }
                case 9: {
                    out[q++] = 92;
                    out[q++] = 116;
                    continue block17;
                }
                case 12: {
                    out[q++] = 92;
                    out[q++] = 102;
                    continue block17;
                }
                case 11: {
                    out[q++] = 92;
                    out[q++] = 118;
                    continue block17;
                }
                case 8: {
                    out[q++] = 92;
                    out[q++] = 98;
                    continue block17;
                }
                case 7: {
                    out[q++] = 92;
                    out[q++] = 97;
                    continue block17;
                }
                case 27: {
                    out[q++] = 92;
                    out[q++] = 101;
                    continue block17;
                }
            }
            if (ASCIIEncoding.INSTANCE.isPrint(c)) {
                out[q++] = (byte)c;
                continue;
            }
            out[q++] = 92;
            outBytes.setRealSize(q);
            if (enc.isUTF8() && StringSupport.MBCLEN_CHARFOUND_LEN(n = StringSupport.preciseLength(enc, bytes2, p2 - 1, end2) - 1) > 0) {
                int cc = StringSupport.codePoint(runtime2, enc, bytes2, p2 - 1, end2);
                outBytes.setRealSize(q);
                p2 += n;
                if (cc <= 65535) {
                    Sprintf.sprintf(runtime2, outBytes, (CharSequence)"u%04X", cc);
                } else {
                    Sprintf.sprintf(runtime2, outBytes, (CharSequence)"u{%X}", cc);
                }
                q = outBytes.getRealSize();
                continue;
            }
            Sprintf.sprintf(runtime2, outBytes, (CharSequence)"x%02X", c);
            q = outBytes.getRealSize();
        }
        if (quoteOnlyIfNeeded && includingsNonprintable || !quoteOnlyIfNeeded) {
            out[q++] = 34;
        }
        outBytes.setRealSize(q);
        assert (out == outBytes.getUnsafeBytes());
        return outBytes;
    }

    public static boolean isEVStr(byte[] bytes2, int p2, int end2) {
        return p2 < end2 ? StringSupport.isEVStr(bytes2[p2] & 0xFF) : false;
    }

    public static boolean isEVStr(int c) {
        return c == 36 || c == 64 || c == 123;
    }

    public static int strCount(ByteList str, boolean[] table, TrTables tables, Encoding enc) {
        byte[] bytes2 = str.getUnsafeBytes();
        int p2 = str.getBegin();
        int end2 = p2 + str.getRealSize();
        boolean asciiCompat = enc.isAsciiCompatible();
        int count2 = 0;
        while (p2 < end2) {
            int c;
            if (asciiCompat && (c = bytes2[p2] & 0xFF) < 128) {
                if (table[c]) {
                    ++count2;
                }
                ++p2;
                continue;
            }
            c = StringSupport.codePoint(enc, bytes2, p2, end2);
            int cl = StringSupport.codeLength(enc, c);
            if (StringSupport.trFind(c, table, tables)) {
                ++count2;
            }
            p2 += cl;
        }
        return count2;
    }

    public static int strCount(ByteList str, Ruby runtime2, boolean[] table, TrTables tables, Encoding enc) {
        try {
            return StringSupport.strCount(str, table, tables, enc);
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError(e.getMessage());
        }
    }

    public static int countCommon19(ByteList str, Ruby runtime2, boolean[] table, TrTables tables, Encoding enc) {
        return StringSupport.strCount(str, runtime2, table, tables, enc);
    }

    public static int rindex(ByteList source2, int sourceChars, int subChars, int pos2, CodeRangeable subStringCodeRangeable, Encoding enc) {
        if (subStringCodeRangeable.scanForCodeRange() == 48) {
            return -1;
        }
        ByteList subString = subStringCodeRangeable.getByteList();
        int srcLen = source2.getRealSize();
        int subLen = subString.getRealSize();
        if (sourceChars < subChars || srcLen < subLen) {
            return -1;
        }
        if (sourceChars - pos2 < subChars) {
            pos2 = sourceChars - subChars;
        }
        if (sourceChars == 0) {
            return pos2;
        }
        byte[] srcBytes = source2.getUnsafeBytes();
        int srcBeg = source2.getBegin();
        if (pos2 == 0) {
            if (ByteList.memcmp(srcBytes, srcBeg, subString.getUnsafeBytes(), subString.getBegin(), subLen) == 0) {
                return 0;
            }
            return -1;
        }
        int s2 = StringSupport.nth(enc, srcBytes, srcBeg, srcBeg + srcLen, pos2);
        return StringSupport.strRindex(srcBytes, srcBeg, srcLen, subString.getUnsafeBytes(), subString.getBegin(), subLen, s2, pos2, enc);
    }

    private static int strRindex(byte[] strBytes, int strBeg, int strLen, byte[] subBytes, int subBeg, int subLen, int s2, int pos2, Encoding enc) {
        int e = strBeg + strLen;
        while (s2 >= strBeg) {
            if (s2 + subLen <= e && ByteList.memcmp(strBytes, s2, subBytes, subBeg, subLen) == 0) {
                return pos2;
            }
            if (pos2 == 0) break;
            --pos2;
            s2 = enc.prevCharHead(strBytes, strBeg, s2, e);
        }
        return -1;
    }

    public static int strLengthFromRubyString(CodeRangeable string2, Encoding enc) {
        ByteList bytes2 = string2.getByteList();
        if (StringSupport.isSingleByteOptimizable(string2, enc)) {
            return bytes2.getRealSize();
        }
        return StringSupport.strLengthFromRubyStringFull(string2, bytes2, enc);
    }

    public static int strLengthFromRubyString(CodeRangeable string2) {
        ByteList bytes2 = string2.getByteList();
        if (StringSupport.isSingleByteOptimizable(string2, bytes2.getEncoding())) {
            return bytes2.getRealSize();
        }
        return StringSupport.strLengthFromRubyStringFull(string2, bytes2, bytes2.getEncoding());
    }

    public static int strLengthFromRubyString(CodeRangeable string2, ByteList bytes2, Encoding enc) {
        if (StringSupport.isSingleByteOptimizable(string2, enc)) {
            return bytes2.getRealSize();
        }
        if (string2.isCodeRangeValid() && enc.isUTF8()) {
            return StringSupport.utf8Length(bytes2);
        }
        long lencr = StringSupport.strLengthWithCodeRange(bytes2, enc);
        return StringSupport.unpackResult(lencr);
    }

    private static int strLengthFromRubyStringFull(CodeRangeable string2, ByteList bytes2, Encoding enc) {
        if (string2.isCodeRangeValid() && enc.isUTF8()) {
            return StringSupport.utf8Length(bytes2);
        }
        long lencr = StringSupport.strLengthWithCodeRange(bytes2, enc);
        int cr = StringSupport.unpackArg(lencr);
        if (cr != 0) {
            string2.setCodeRange(cr);
        }
        return StringSupport.unpackResult(lencr);
    }

    public static TrTables trSetupTable(ByteList str, boolean[] stable, TrTables tables, boolean first2, Encoding enc) {
        int c;
        int i2;
        boolean cflag;
        int[] l = new int[]{0};
        TR tr = new TR(str);
        if (str.realSize() > 1 && EncodingUtils.encAscget(tr.buf, tr.p, tr.pend, l, enc) == 94) {
            cflag = true;
            tr.p += l[0];
        } else {
            cflag = false;
        }
        if (first2) {
            for (i2 = 0; i2 < 256; ++i2) {
                stable[i2] = true;
            }
            stable[256] = cflag;
        } else if (stable[256] && !cflag) {
            stable[256] = false;
        }
        if (tables == null) {
            tables = new TrTables();
        }
        byte[] buf = null;
        IntHashMap<Object> table = null;
        IntHashMap<Object> ptable = null;
        while ((c = StringSupport.trNext(tr, enc)) != -1) {
            if (c < 256) {
                if (buf == null) {
                    buf = new byte[256];
                    for (i2 = 0; i2 < 256; ++i2) {
                        buf[i2] = (byte)(cflag ? 1 : 0);
                    }
                }
                buf[c & 0xFF] = (byte)(!cflag ? 1 : 0);
                continue;
            }
            if (table == null && (first2 || tables.del != null || stable[256])) {
                if (cflag) {
                    ptable = tables.noDel;
                    table = ptable != null ? ptable : new IntHashMap<Object>(8);
                    tables.noDel = table;
                } else {
                    table = new IntHashMap<Object>(8);
                    ptable = tables.del;
                    tables.del = table;
                }
            }
            if (table == null) continue;
            int key2 = c;
            if (ptable == null) {
                table.put(key2, DUMMY_VALUE);
                continue;
            }
            if (cflag) {
                table.put(key2, DUMMY_VALUE);
                continue;
            }
            boolean val = ptable.get(key2) != null;
            table.put(key2, val ? DUMMY_VALUE : null);
        }
        if (buf != null) {
            for (i2 = 0; i2 < 256; ++i2) {
                stable[i2] = stable[i2] && buf[i2] != 0;
            }
        } else {
            for (i2 = 0; i2 < 256; ++i2) {
                stable[i2] = stable[i2] && cflag;
            }
        }
        if (table == null && !cflag) {
            tables.del = null;
        }
        return tables;
    }

    public static TrTables trSetupTable(ByteList str, Ruby runtime2, boolean[] stable, TrTables tables, boolean first2, Encoding enc) {
        try {
            return StringSupport.trSetupTable(str, stable, tables, first2, enc);
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError(e.getMessage());
        }
    }

    public static boolean trFind(int c, boolean[] table, TrTables tables) {
        if (c < 256) {
            return table[c];
        }
        IntHashMap<Object> del = tables.del;
        IntHashMap<Object> noDel = tables.noDel;
        if (del != null) {
            if (del.get(c) != null && (noDel == null || noDel.get(c) == null)) {
                return true;
            }
        } else if (noDel != null && noDel.get(c) != null) {
            return false;
        }
        return table[256];
    }

    public static int trNext(TR tr, Encoding enc) {
        if (!tr.gen) {
            return StringSupport.trNext_nextpart(tr, enc);
        }
        while (enc.codeToMbcLength(++tr.now) <= 0) {
            if (tr.now != tr.max) continue;
            tr.gen = false;
            return StringSupport.trNext_nextpart(tr, enc);
        }
        if (tr.now < tr.max) {
            return tr.now;
        }
        tr.gen = false;
        return tr.max;
    }

    public static int trNext(TR tr, Ruby runtime2, Encoding enc) {
        try {
            return StringSupport.trNext(tr, enc);
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError(e.getMessage());
        }
    }

    private static int trNext_nextpart(TR tr, Encoding enc) {
        int[] n = new int[]{0};
        if (tr.p == tr.pend) {
            return -1;
        }
        if (EncodingUtils.encAscget(tr.buf, tr.p, tr.pend, n, enc) == 92 && tr.p + n[0] < tr.pend) {
            tr.p += n[0];
        }
        tr.now = EncodingUtils.encCodepointLength(tr.buf, tr.p, tr.pend, n, enc);
        tr.p += n[0];
        if (EncodingUtils.encAscget(tr.buf, tr.p, tr.pend, n, enc) == 45 && tr.p + n[0] < tr.pend) {
            tr.p += n[0];
            if (tr.p < tr.pend) {
                int c = EncodingUtils.encCodepointLength(tr.buf, tr.p, tr.pend, n, enc);
                tr.p += n[0];
                if (tr.now > c) {
                    if (tr.now < 128 && c < 128) {
                        throw new IllegalArgumentException("invalid range \"" + (char)tr.now + '-' + (char)c + "\" in string transliteration");
                    }
                    throw new IllegalArgumentException("invalid range in string transliteration");
                }
                tr.gen = true;
                tr.max = c;
            }
        }
        return tr.now;
    }

    public static ByteList succCommon(ByteList original) {
        int end2;
        byte[] carry = new byte[7];
        int carryP = 0;
        carry[0] = 1;
        int carryLen = 1;
        ByteList valueCopy = new ByteList(original);
        valueCopy.setEncoding(original.getEncoding());
        Encoding enc = original.getEncoding();
        int p2 = valueCopy.getBegin();
        int s2 = end2 = p2 + valueCopy.getRealSize();
        byte[] bytes2 = valueCopy.getUnsafeBytes();
        NeighborChar neighbor = NeighborChar.FOUND;
        int lastAlnum = -1;
        boolean alnumSeen = false;
        block5: while ((s2 = enc.prevCharHead(bytes2, p2, s2, end2)) != -1) {
            ASCIIEncoding ascii;
            if (neighbor == NeighborChar.NOT_CHAR && lastAlnum != -1 && ((ascii = ASCIIEncoding.INSTANCE).isAlpha(bytes2[lastAlnum] & 0xFF) ? ascii.isDigit(bytes2[s2] & 0xFF) : ascii.isDigit(bytes2[lastAlnum] & 0xFF) && ascii.isAlpha(bytes2[s2] & 0xFF))) {
                s2 = lastAlnum;
                break;
            }
            int cl = StringSupport.preciseLength(enc, bytes2, s2, end2);
            if (cl <= 0) continue;
            neighbor = StringSupport.succAlnumChar(enc, bytes2, s2, cl, carry, 0);
            switch (neighbor) {
                case NOT_CHAR: {
                    continue block5;
                }
                case FOUND: {
                    return valueCopy;
                }
                case WRAPPED: {
                    lastAlnum = s2;
                }
            }
            alnumSeen = true;
            carryP = s2 - p2;
            carryLen = cl;
        }
        if (!alnumSeen) {
            s2 = end2;
            while ((s2 = enc.prevCharHead(bytes2, p2, s2, end2)) != -1) {
                int cl = StringSupport.preciseLength(enc, bytes2, s2, end2);
                if (cl <= 0) continue;
                neighbor = StringSupport.succChar(enc, bytes2, s2, cl);
                if (neighbor == NeighborChar.FOUND) {
                    return valueCopy;
                }
                if (StringSupport.preciseLength(enc, bytes2, s2, s2 + 1) != cl) {
                    StringSupport.succChar(enc, bytes2, s2, cl);
                }
                if (!enc.isAsciiCompatible()) {
                    System.arraycopy(bytes2, s2, carry, 0, cl);
                    carryLen = cl;
                }
                carryP = s2 - p2;
            }
        }
        valueCopy.ensure(valueCopy.getBegin() + valueCopy.getRealSize() + carryLen);
        s2 = valueCopy.getBegin() + carryP;
        System.arraycopy(valueCopy.getUnsafeBytes(), s2, valueCopy.getUnsafeBytes(), s2 + carryLen, valueCopy.getRealSize() - carryP);
        System.arraycopy(carry, 0, valueCopy.getUnsafeBytes(), s2, carryLen);
        valueCopy.setRealSize(valueCopy.getRealSize() + carryLen);
        return valueCopy;
    }

    public static ByteList succCommon(Ruby runtime2, ByteList original) {
        try {
            return StringSupport.succCommon(original);
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError(e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public static NeighborChar succChar(Encoding enc, byte[] bytes, int p, int len) {
        if (enc.minLength() > 1) {
            r = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                return NeighborChar.NOT_CHAR;
            }
            c = StringSupport.codePoint(enc, bytes, p, p + len) + 1;
            l = StringSupport.codeLength(enc, c);
            if (l == 0) {
                return NeighborChar.NOT_CHAR;
            }
            if (l != len) {
                return NeighborChar.WRAPPED;
            }
            EncodingUtils.encMbcput(c, bytes, p, enc);
            r = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                return NeighborChar.NOT_CHAR;
            }
            return NeighborChar.FOUND;
        }
        while (true) {
            for (i = len - 1; i >= 0 && bytes[p + i] == -1; --i) {
                bytes[p + i] = 0;
            }
            if (i < 0) {
                return NeighborChar.WRAPPED;
            }
            bytes[p + i] = (byte)((bytes[p + i] & 255) + 1);
            l = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (StringSupport.MBCLEN_CHARFOUND_P(l)) {
                if ((l = StringSupport.MBCLEN_CHARFOUND_LEN(l)) == len) {
                    return NeighborChar.FOUND;
                }
                start = p + l;
                end = start + (len - l);
                Arrays.fill(bytes, start, end, (byte)-1);
            }
            if (!StringSupport.MBCLEN_INVALID_P(l) || i >= len - 1) ** continue;
            for (len2 = len - 1; 0 < len2 && StringSupport.MBCLEN_INVALID_P(l2 = StringSupport.preciseLength(enc, bytes, p, p + len2)); --len2) {
            }
            start = p + len2 + 1;
            end = start + len - (len2 + 1);
            Arrays.fill(bytes, start, end, (byte)-1);
        }
    }

    public static NeighborChar succChar(Ruby runtime2, Encoding enc, byte[] bytes2, int p2, int len) {
        try {
            return StringSupport.succChar(enc, bytes2, p2, len);
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError(e.getMessage());
        }
    }

    private static NeighborChar succAlnumChar(Encoding enc, byte[] bytes2, int p2, int len, byte[] carry, int carryP) {
        int cType;
        byte[] save = new byte[7];
        int c = enc.mbcToCode(bytes2, p2, p2 + len);
        if (enc.isDigit(c)) {
            cType = 4;
        } else if (enc.isAlpha(c)) {
            cType = 1;
        } else {
            return NeighborChar.NOT_CHAR;
        }
        System.arraycopy(bytes2, p2, save, 0, len);
        NeighborChar ret = StringSupport.succChar(enc, bytes2, p2, len);
        if (ret == NeighborChar.FOUND && enc.isCodeCType(c = enc.mbcToCode(bytes2, p2, p2 + len), cType)) {
            return NeighborChar.FOUND;
        }
        System.arraycopy(save, 0, bytes2, p2, len);
        int range = 1;
        while (true) {
            System.arraycopy(bytes2, p2, save, 0, len);
            ret = StringSupport.predChar(enc, bytes2, p2, len);
            if (ret == NeighborChar.FOUND) {
                c = enc.mbcToCode(bytes2, p2, p2 + len);
                if (!enc.isCodeCType(c, cType)) {
                    System.arraycopy(save, 0, bytes2, p2, len);
                    break;
                }
            } else {
                System.arraycopy(save, 0, bytes2, p2, len);
                break;
            }
            ++range;
        }
        if (range == 1) {
            return NeighborChar.NOT_CHAR;
        }
        if (cType != 4) {
            System.arraycopy(bytes2, p2, carry, carryP, len);
            return NeighborChar.WRAPPED;
        }
        System.arraycopy(bytes2, p2, carry, carryP, len);
        StringSupport.succChar(enc, carry, carryP, len);
        return NeighborChar.WRAPPED;
    }

    /*
     * Unable to fully structure code
     */
    private static NeighborChar predChar(Encoding enc, byte[] bytes, int p, int len) {
        if (enc.minLength() > 1) {
            r = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                return NeighborChar.NOT_CHAR;
            }
            c = StringSupport.codePoint(enc, bytes, p, p + len);
            if (c == 0) {
                return NeighborChar.NOT_CHAR;
            }
            if ((l = StringSupport.codeLength(enc, --c)) == 0) {
                return NeighborChar.NOT_CHAR;
            }
            if (l != len) {
                return NeighborChar.WRAPPED;
            }
            EncodingUtils.encMbcput(c, bytes, p, enc);
            r = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                return NeighborChar.NOT_CHAR;
            }
            return NeighborChar.FOUND;
        }
        while (true) {
            for (i = len - 1; i >= 0 && bytes[p + i] == 0; --i) {
                bytes[p + i] = -1;
            }
            if (i < 0) {
                return NeighborChar.WRAPPED;
            }
            bytes[p + i] = (byte)((bytes[p + i] & 255) - 1);
            l = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (StringSupport.MBCLEN_CHARFOUND_P(l)) {
                if ((l = StringSupport.MBCLEN_CHARFOUND_LEN(l)) == len) {
                    return NeighborChar.FOUND;
                }
                start = p + l;
                end = start + (len - l);
                Arrays.fill(bytes, start, end, (byte)0);
            }
            if (StringSupport.MBCLEN_CHARFOUND_P(l) || i >= len - 1) ** continue;
            for (len2 = len - 1; 0 < len2 && StringSupport.MBCLEN_INVALID_P(l2 = StringSupport.preciseLength(enc, bytes, p, p + len2)); --len2) {
            }
            start = p + len2 + 1;
            end = start + (len - (len2 + 1));
            Arrays.fill(bytes, start, end, (byte)0);
        }
    }

    public static boolean isSingleByteOptimizable(CodeRangeable string2, Encoding encoding2) {
        return string2.getCodeRange() == 16 || encoding2.maxLength() == 1;
    }

    public static int index(CodeRangeable sourceString, CodeRangeable otherString, int offset2, Encoding enc) {
        if (otherString.scanForCodeRange() == 48) {
            return -1;
        }
        int sourceLen = StringSupport.strLengthFromRubyString(sourceString);
        int otherLen = StringSupport.strLengthFromRubyString(otherString);
        if (offset2 < 0 && (offset2 += sourceLen) < 0) {
            return -1;
        }
        ByteList source2 = sourceString.getByteList();
        ByteList other = otherString.getByteList();
        if (sourceLen - offset2 < otherLen) {
            return -1;
        }
        byte[] bytes2 = source2.getUnsafeBytes();
        int p2 = source2.getBegin();
        int end2 = p2 + source2.getRealSize();
        if (offset2 != 0) {
            offset2 = StringSupport.isSingleByteOptimizable(sourceString, enc) ? offset2 : StringSupport.offset(enc, bytes2, p2, end2, offset2);
            p2 += offset2;
        }
        if (otherLen == 0) {
            return offset2;
        }
        int pos2;
        while ((pos2 = source2.indexOf(other, p2 - source2.getBegin())) >= 0) {
            int t = enc.rightAdjustCharHead(bytes2, p2, p2 + (pos2 -= p2 - source2.getBegin()), end2);
            if (t == p2 + pos2) {
                return pos2 + offset2;
            }
            if ((sourceLen -= t - p2) <= 0) {
                return -1;
            }
            offset2 += t - p2;
            p2 = t;
        }
        return pos2;
    }

    public static void associateEncoding(CodeRangeable string2, Encoding enc) {
        ByteList value2 = string2.getByteList();
        if (value2.getEncoding() != enc) {
            if (!CodeRangeSupport.isCodeRangeAsciiOnly(string2) || !enc.isAsciiCompatible()) {
                string2.clearCodeRange();
            }
            value2.setEncoding(enc);
        }
    }

    public static ByteList replaceInternal(int beg, int len, ByteListHolder source2, CodeRangeable repl) {
        int oldLength = source2.getByteList().getRealSize();
        if (beg + len >= oldLength) {
            len = oldLength - beg;
        }
        ByteList replBytes = repl.getByteList();
        int replLength = replBytes.getRealSize();
        int newLength = oldLength + replLength - len;
        byte[] oldBytes = source2.getByteList().getUnsafeBytes();
        int oldBegin = source2.getByteList().getBegin();
        source2.modify(newLength);
        if (replLength != len) {
            System.arraycopy(oldBytes, oldBegin + beg + len, source2.getByteList().getUnsafeBytes(), beg + replLength, oldLength - (beg + len));
        }
        if (replLength > 0) {
            System.arraycopy(replBytes.getUnsafeBytes(), replBytes.getBegin(), source2.getByteList().getUnsafeBytes(), beg, replLength);
        }
        source2.getByteList().setRealSize(newLength);
        return source2.getByteList();
    }

    public static void replaceInternal19(int beg, int len, CodeRangeable source2, CodeRangeable repl) {
        int e;
        Encoding enc = source2.checkEncoding(repl);
        source2.modify();
        source2.keepCodeRange();
        ByteList sourceBL = source2.getByteList();
        byte[] sourceBytes = sourceBL.unsafeBytes();
        int sourceBeg = sourceBL.begin();
        int sourceEnd = sourceBeg + sourceBL.realSize();
        boolean singlebyte = StringSupport.isSingleByteOptimizable(source2, source2.getByteList().getEncoding());
        int p2 = StringSupport.nth(enc, sourceBytes, sourceBeg, sourceEnd, beg, singlebyte);
        if (p2 == -1) {
            p2 = sourceEnd;
        }
        if ((e = StringSupport.nth(enc, sourceBytes, p2, sourceEnd, len, singlebyte)) == -1) {
            e = sourceEnd;
        }
        beg = p2 - sourceBeg;
        len = e - p2;
        StringSupport.replaceInternal(beg, len, source2, repl);
        StringSupport.associateEncoding(source2, enc);
        int cr = CodeRangeSupport.codeRangeAnd(source2.getCodeRange(), repl.getCodeRange());
        if (cr != 48) {
            source2.setCodeRange(cr);
        }
    }

    public static void replaceInternal19(Ruby runtime2, int beg, int len, RubyString source2, RubyString repl) {
        if (len < 0) {
            throw runtime2.newIndexError("negative length " + len);
        }
        int slen = StringSupport.strLengthFromRubyString(source2, source2.checkEncoding(repl));
        if (slen < beg) {
            throw runtime2.newIndexError("index " + beg + " out of string");
        }
        if (beg < 0) {
            if (-beg > slen) {
                throw runtime2.newIndexError("index " + beg + " out of string");
            }
            beg += slen;
        }
        if (slen < len || slen < beg + len) {
            len = slen - beg;
        }
        StringSupport.replaceInternal19(beg, len, source2, repl);
        if (repl.isTaint()) {
            source2.setTaint(true);
        }
    }

    public static boolean isAsciiOnly(CodeRangeable string2) {
        return StringSupport.isAsciiOnly(string2.getByteList().getEncoding(), string2.scanForCodeRange());
    }

    private static boolean isAsciiOnly(Encoding encoding2, int codeRange) {
        return encoding2.isAsciiCompatible() && codeRange == 16;
    }

    static CodeRangeable strDeleteBang(CodeRangeable rubyString, boolean[] squeeze2, TrTables tables, Encoding enc) {
        int cr;
        int s2;
        rubyString.modify();
        rubyString.keepCodeRange();
        ByteList value2 = rubyString.getByteList();
        int t = s2 = value2.getBegin();
        int send2 = s2 + value2.getRealSize();
        byte[] bytes2 = value2.getUnsafeBytes();
        boolean modify = false;
        boolean asciiCompatible = enc.isAsciiCompatible();
        int n = cr = asciiCompatible ? 16 : 32;
        while (s2 < send2) {
            int c;
            if (asciiCompatible && Encoding.isAscii((int)(c = bytes2[s2] & 0xFF))) {
                if (squeeze2[c]) {
                    modify = true;
                } else {
                    if (t != s2) {
                        bytes2[t] = (byte)c;
                    }
                    ++t;
                }
                ++s2;
                continue;
            }
            c = StringSupport.codePoint(enc, bytes2, s2, send2);
            int cl = StringSupport.codeLength(enc, c);
            if (StringSupport.trFind(c, squeeze2, tables)) {
                modify = true;
            } else {
                if (t != s2) {
                    enc.codeToMbc(c, bytes2, t);
                }
                t += cl;
                if (cr == 16) {
                    cr = 32;
                }
            }
            s2 += cl;
        }
        value2.setRealSize(t - value2.getBegin());
        rubyString.setCodeRange(cr);
        return modify ? rubyString : null;
    }

    public static CodeRangeable strDeleteBang(CodeRangeable rubyString, Ruby runtime2, boolean[] squeeze2, TrTables tables, Encoding enc) {
        try {
            return StringSupport.strDeleteBang(rubyString, squeeze2, tables, enc);
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError(e.getMessage());
        }
    }

    public static int choppedLength(CodeRangeable str) {
        int p2;
        int end2;
        ByteList bl = str.getByteList();
        Encoding enc = bl.getEncoding();
        int beg = bl.begin();
        if (beg > (end2 = beg + bl.realSize())) {
            return 0;
        }
        int p3 = enc.prevCharHead(bl.unsafeBytes(), beg, end2, end2);
        if (p3 == 0) {
            return 0;
        }
        if (p3 > beg && EncodingUtils.encAscget(bl.unsafeBytes(), p3, end2, null, enc) == 10 && (p2 = enc.prevCharHead(bl.unsafeBytes(), beg, p3, end2)) != -1 && EncodingUtils.encAscget(bl.unsafeBytes(), p2, end2, null, enc) == 13) {
            p3 = p2;
        }
        return p3 - beg;
    }

    @Deprecated
    public static int choppedLength19(CodeRangeable str, Ruby runtime2) {
        return StringSupport.choppedLength(str);
    }

    public static Encoding areCompatible(CodeRangeable str1, CodeRangeable str2) {
        Encoding enc2;
        Encoding enc1 = str1.getByteList().getEncoding();
        if (enc1 == (enc2 = str2.getByteList().getEncoding())) {
            return enc1;
        }
        if (str2.getByteList().getRealSize() == 0) {
            return enc1;
        }
        if (str1.getByteList().getRealSize() == 0) {
            return enc1.isAsciiCompatible() && StringSupport.isAsciiOnly(str2) ? enc1 : enc2;
        }
        if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
            return null;
        }
        return RubyEncoding.areCompatible(enc1, str1.scanForCodeRange(), enc2, str2.scanForCodeRange());
    }

    public static Encoding areCompatible(ByteList str1, ByteList str2) {
        Encoding enc2;
        Encoding enc1 = str1.getEncoding();
        if (enc1 == (enc2 = str2.getEncoding())) {
            return enc1;
        }
        if (str2.getRealSize() == 0) {
            return enc1;
        }
        if (str1.getRealSize() == 0) {
            return enc1.isAsciiCompatible() && StringSupport.isAsciiOnly(enc2, RubyString.scanForCodeRange(str2)) ? enc1 : enc2;
        }
        if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
            return null;
        }
        return RubyEncoding.areCompatible(enc1, RubyString.scanForCodeRange(str1), enc2, RubyString.scanForCodeRange(str2));
    }

    public static ByteList addByteLists(ByteList value1, ByteList value2) {
        ByteList result2 = new ByteList(value1.getRealSize() + value2.getRealSize());
        result2.setRealSize(value1.getRealSize() + value2.getRealSize());
        System.arraycopy(value1.getUnsafeBytes(), value1.getBegin(), result2.getUnsafeBytes(), 0, value1.getRealSize());
        System.arraycopy(value2.getUnsafeBytes(), value2.getBegin(), result2.getUnsafeBytes(), value1.getRealSize(), value2.getRealSize());
        return result2;
    }

    public static boolean areComparable(CodeRangeable string2, CodeRangeable other) {
        ByteList otherValue = other.getByteList();
        if (string2.getByteList().getEncoding() == otherValue.getEncoding() || string2.getByteList().getRealSize() == 0 || otherValue.getRealSize() == 0) {
            return true;
        }
        return StringSupport.areComparableViaCodeRange(string2, other);
    }

    public static boolean areComparableViaCodeRange(CodeRangeable string2, CodeRangeable other) {
        int cr1 = string2.scanForCodeRange();
        int cr2 = other.scanForCodeRange();
        if (cr1 == 16 && (cr2 == 16 || other.getByteList().getEncoding().isAsciiCompatible())) {
            return true;
        }
        return cr2 == 16 && string2.getByteList().getEncoding().isAsciiCompatible();
    }

    public static IRubyObject rbStrEnumerateLines(RubyString str, ThreadContext context, String name2, IRubyObject arg2, Block block, boolean wantarray) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, arg2);
        if (opts == context.nil) {
            return StringSupport.rbStrEnumerateLines(str, context, name2, arg2, context.nil, block, wantarray);
        }
        return StringSupport.rbStrEnumerateLines(str, context, name2, context.runtime.getGlobalVariables().get("$/"), opts, block, wantarray);
    }

    public static IRubyObject rbStrEnumerateLines(RubyString str, ThreadContext context, String name2, IRubyObject arg2, IRubyObject opts, Block block, boolean wantarray) {
        IRubyObject line;
        int pos2;
        Encoding enc;
        int subptr;
        Ruby runtime2 = context.runtime;
        RubyString orig = str;
        boolean rsnewline = false;
        boolean chomp2 = false;
        if (opts != context.nil) {
            IRubyObject _chomp = ArgsUtil.extractKeywordArg(context, "chomp", opts);
            boolean bl = chomp2 = _chomp != null || _chomp.isTrue();
        }
        if (block.isGiven()) {
            if (wantarray) {
                runtime2.getWarnings().warning("passing a block to String#lines is deprecated");
                wantarray = false;
            }
        } else if (!wantarray) {
            return RubyEnumerator.enumeratorize(runtime2, (IRubyObject)str, name2, Helpers.arrayOf(arg2, opts));
        }
        if (arg2 == context.nil) {
            if (wantarray) {
                return RubyArray.newArray(runtime2, str);
            }
            block.yieldSpecific(context, str);
            return orig;
        }
        RubyArray ary = wantarray ? RubyArray.newArray(runtime2) : null;
        IRubyObject defaultSep = runtime2.getGlobalVariables().get("$/");
        RubyString rs = arg2.convertToString();
        str = str.newFrozen();
        byte[] strBytes = str.getByteList().unsafeBytes();
        int ptr = subptr = str.getByteList().begin();
        int len = str.size();
        int pend = ptr + len;
        int rslen = rs.size();
        Encoding encoding2 = enc = rs == defaultSep ? str.getEncoding() : str.checkEncoding(rs);
        if (rslen == 0) {
            StringSupport.rbStrEnumerateLinesEmptySep(str, context, chomp2, block, ary, strBytes, ptr, len, pend, enc, subptr);
            return wantarray ? ary : orig;
        }
        ByteList rsByteList = rs.getByteList();
        byte[] rsbytes = rsByteList.unsafeBytes();
        int rsptr = rsByteList.begin();
        if (rsByteList.length() == enc.minLength() && enc.isNewLine(rsbytes, rsptr, rsByteList.length())) {
            rsnewline = true;
        }
        if (rs == defaultSep && !enc.isAsciiCompatible()) {
            rs = RubyString.newString(runtime2, rsbytes, rsptr, rslen);
            rs = (RubyString)EncodingUtils.rbStrEncode(context, rs, runtime2.getEncodingService().convertEncodingToRubyEncoding(enc), 0, context.nil);
            rsByteList = rs.getByteList();
            rsbytes = rsByteList.unsafeBytes();
            rsptr = rsByteList.begin();
            rslen = rsByteList.realSize();
        }
        while (subptr < pend && (pos2 = StringSupport.memsearch(rsbytes, rsptr, rslen, strBytes, subptr, pend - subptr, enc)) >= 0) {
            int hit = subptr + pos2;
            int adjusted = enc.rightAdjustCharHead(strBytes, subptr, hit, pend);
            if (hit != adjusted) {
                subptr = adjusted;
                continue;
            }
            int subend = hit += rslen;
            if (chomp2) {
                subend = rsnewline ? StringSupport.chomp_newline(strBytes, subptr, subend, enc) : (subend -= rslen);
            }
            line = str.substr(runtime2, subptr - ptr, subend - subptr);
            if (wantarray) {
                ary.append(line);
            } else {
                block.yieldSpecific(context, line);
                str.modifyCheck(strBytes, len);
            }
            subptr = hit;
        }
        if (subptr != pend) {
            if (chomp2) {
                if (rsnewline) {
                    pend = StringSupport.chomp_newline(strBytes, subptr, pend, enc);
                } else if (pend - subptr >= rslen && ByteList.memcmp(strBytes, pend - rslen, rsbytes, rsptr, rslen) == 0) {
                    pend -= rslen;
                }
            }
            line = str.substr(runtime2, subptr - ptr, pend - subptr);
            if (wantarray) {
                ary.append(line);
            } else {
                block.yieldSpecific(context, line);
            }
        }
        return wantarray ? ary : orig;
    }

    private static void rbStrEnumerateLinesEmptySep(RubyString str, ThreadContext context, boolean chomp2, Block block, RubyArray ary, byte[] strBytes, int ptr, int len, int pend, Encoding enc, int subptr) {
        int[] n = new int[]{0};
        int eol = -1;
        int subend = subptr;
        while (subend < pend) {
            int rslen;
            do {
                if (EncodingUtils.encAscget(strBytes, subend, pend, n, enc) != 13) {
                    n[0] = 0;
                }
                rslen = n[0] + StringSupport.length(enc, strBytes, subend + n[0], pend);
                if (enc.isNewLine(strBytes, subend + n[0], pend)) {
                    if (eol == subend) break;
                    subend += rslen;
                    if (subptr != -1) {
                        eol = subend;
                    }
                } else {
                    if (subptr == -1) {
                        subptr = subend;
                    }
                    subend += rslen;
                }
                rslen = 0;
            } while (subend < pend);
            if (subptr == -1) break;
            RubyString line = str.makeSharedString(context.runtime, subptr - ptr, subend - subptr + (chomp2 ? 0 : rslen));
            if (ary != null) {
                ary.append(line);
            } else {
                block.yield(context, line);
                str.modifyCheck(strBytes, len);
            }
            eol = -1;
            subptr = -1;
        }
    }

    private static int chomp_newline(byte[] bytes2, int p2, int e, Encoding enc) {
        int prev = enc.prevCharHead(bytes2, p2, e, e);
        if (enc.isNewLine(bytes2, prev, e) && (prev = enc.prevCharHead(bytes2, p2, e = prev, e)) != -1 && EncodingUtils.encAscget(bytes2, prev, e, null, enc) == 13) {
            e = prev;
        }
        return e;
    }

    public static int memsearch(byte[] xBytes, int x0, int m, byte[] yBytes, int y0, int n, Encoding enc) {
        int x = x0;
        int y = y0;
        if (m > n) {
            return -1;
        }
        if (m == n) {
            return ByteList.memcmp(xBytes, x0, yBytes, y0, m) == 0 ? 0 : -1;
        }
        if (m < 1) {
            return 0;
        }
        if (m == 1) {
            int ys = StringSupport.memchr(yBytes, y, xBytes[x], n);
            if (ys != -1) {
                return ys - y;
            }
            return -1;
        }
        if (m <= 8) {
            return StringSupport.rb_memsearch_ss(xBytes, x0, m, yBytes, y0, n);
        }
        if (enc == UTF8Encoding.INSTANCE) {
            return StringSupport.rb_memsearch_qs_utf8(xBytes, x0, m, yBytes, y0, n);
        }
        return StringSupport.rb_memsearch_qs(xBytes, x0, m, yBytes, y0, n);
    }

    public static CodeRangeable trTransHelper(CodeRangeable self2, CodeRangeable srcStr, CodeRangeable replStr, boolean sflag) {
        int s2;
        int c;
        int i2;
        Encoding e2;
        ByteList srcList = srcStr.getByteList();
        ByteList replList = replStr.getByteList();
        int cr = self2.getCodeRange();
        Encoding e1 = self2.checkEncoding(srcStr);
        Encoding enc = e1 == (e2 = self2.checkEncoding(replStr)) ? e1 : srcStr.checkEncoding(replStr);
        TR trSrc = new TR(srcList);
        boolean cflag = false;
        int[] l = new int[]{0};
        if (srcStr.getByteList().getRealSize() > 1 && EncodingUtils.encAscget(trSrc.buf, trSrc.p, trSrc.pend, l, enc) == 94 && trSrc.p + 1 < trSrc.pend) {
            cflag = true;
            ++trSrc.p;
        }
        int last2 = 0;
        int[] trans = new int[256];
        TR trRepl = new TR(replList);
        boolean modify = false;
        IntHash hash2 = null;
        boolean singlebyte = StringSupport.isSingleByteOptimizable(self2, EncodingUtils.STR_ENC_GET(self2));
        if (cflag) {
            for (i2 = 0; i2 < 256; ++i2) {
                trans[i2] = 1;
            }
            while ((c = StringSupport.trNext(trSrc, enc)) != -1) {
                if (c < 256) {
                    trans[c] = -1;
                    continue;
                }
                if (hash2 == null) {
                    hash2 = new IntHash();
                }
                hash2.put(c, (Object)1);
            }
            while ((c = StringSupport.trNext(trRepl, enc)) != -1) {
            }
            last2 = trRepl.now;
            for (i2 = 0; i2 < 256; ++i2) {
                if (trans[i2] == -1) continue;
                trans[i2] = last2;
            }
        } else {
            for (i2 = 0; i2 < 256; ++i2) {
                trans[i2] = -1;
            }
            while ((c = StringSupport.trNext(trSrc, enc)) != -1) {
                int r = StringSupport.trNext(trRepl, enc);
                if (r == -1) {
                    r = trRepl.now;
                }
                if (c < 256) {
                    trans[c] = r;
                    if (StringSupport.codeLength(enc, r) == 1) continue;
                    singlebyte = false;
                    continue;
                }
                if (hash2 == null) {
                    hash2 = new IntHash();
                }
                hash2.put(c, (Object)r);
            }
        }
        if (cr == 32 && enc.isAsciiCompatible()) {
            cr = 16;
        }
        self2.modifyAndKeepCodeRange();
        int send2 = s2 + self2.getByteList().getRealSize();
        byte[] sbytes = self2.getByteList().getUnsafeBytes();
        if (sflag) {
            int max2 = self2.getByteList().getRealSize();
            int save = -1;
            byte[] buf = new byte[max2];
            int t = 0;
            while (s2 < send2) {
                Integer tmp;
                boolean mayModify = false;
                int c0 = c = StringSupport.codePoint(e1, sbytes, s2, send2);
                int clen = StringSupport.codeLength(e1, c);
                int tlen = enc == e1 ? clen : StringSupport.codeLength(enc, c);
                s2 += clen;
                c = c < 256 ? StringSupport.trCode(c, trans, (IntHash<Integer>)hash2, cflag, last2, false) : (hash2 != null ? ((tmp = (Integer)hash2.get(c)) == null ? (cflag ? last2 : -1) : (cflag ? -1 : tmp)) : -1);
                if (c != -1) {
                    if (save == c) {
                        if (cr != 16 || Encoding.isAscii((int)c)) continue;
                        cr = 32;
                        continue;
                    }
                    save = c;
                    tlen = StringSupport.codeLength(enc, c);
                    modify = true;
                } else {
                    save = -1;
                    c = c0;
                    if (enc != e1) {
                        mayModify = true;
                    }
                }
                while (t + tlen >= max2) {
                    buf = Arrays.copyOf(buf, max2 *= 2);
                }
                enc.codeToMbc(c, buf, t);
                if (mayModify && (s2 >= send2 || ByteList.memcmp(sbytes, s2, buf, t, tlen) != 0)) {
                    modify = true;
                }
                if (cr == 16 && !Encoding.isAscii((int)c)) {
                    cr = 32;
                }
                t += tlen;
            }
            self2.getByteList().setUnsafeBytes(buf);
            self2.getByteList().setRealSize(t);
        } else if (enc.isSingleByte() || singlebyte && hash2 == null) {
            for (s2 = self2.getByteList().getBegin(); s2 < send2; ++s2) {
                c = sbytes[s2] & 0xFF;
                if (trans[c] != -1) {
                    if (!cflag) {
                        c = trans[c];
                        sbytes[s2] = (byte)c;
                    } else {
                        sbytes[s2] = (byte)last2;
                    }
                    modify = true;
                }
                if (cr != 16 || Encoding.isAscii((int)c)) continue;
                cr = 32;
            }
        } else {
            int max3 = (int)((double)self2.getByteList().realSize() * 1.2);
            byte[] buf = new byte[max3];
            int t = 0;
            while (s2 < send2) {
                int tlen;
                boolean mayModify = false;
                int c0 = c = StringSupport.codePoint(e1, sbytes, s2, send2);
                int clen = StringSupport.codeLength(e1, c);
                int n = tlen = enc == e1 ? clen : StringSupport.codeLength(enc, c);
                if (c < 256) {
                    c = trans[c];
                } else if (hash2 != null) {
                    Integer tmp = (Integer)hash2.get(c);
                    c = tmp == null ? (cflag ? last2 : -1) : (cflag ? -1 : tmp);
                } else {
                    int n2 = c = cflag ? last2 : -1;
                }
                if (c != -1) {
                    tlen = StringSupport.codeLength(enc, c);
                    modify = true;
                } else {
                    c = c0;
                    if (enc != e1) {
                        mayModify = true;
                    }
                }
                while (t + tlen >= max3) {
                    buf = Arrays.copyOf(buf, max3 <<= 1);
                }
                enc.codeToMbc(c, buf, t);
                if (mayModify && ByteList.memcmp(sbytes, s2, buf, t, tlen) != 0) {
                    modify = true;
                }
                if (cr == 16 && !Encoding.isAscii((int)c)) {
                    cr = 32;
                }
                s2 += clen;
                t += tlen;
            }
            self2.getByteList().setUnsafeBytes(buf);
            self2.getByteList().setRealSize(t);
        }
        if (modify) {
            if (cr != 48) {
                self2.setCodeRange(cr);
            }
            StringSupport.associateEncoding(self2, enc);
            return self2;
        }
        return null;
    }

    public static CodeRangeable trTransHelper(Ruby runtime2, CodeRangeable self2, CodeRangeable srcStr, CodeRangeable replStr, boolean sflag) {
        try {
            return StringSupport.trTransHelper(self2, srcStr, replStr, sflag);
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError(e.getMessage());
        }
    }

    private static int trCode(int c, int[] trans, IntHash<Integer> hash2, boolean cflag, int last2, boolean set2) {
        if (c < 256) {
            return trans[c];
        }
        if (hash2 != null) {
            Integer tmp = (Integer)hash2.get(c);
            if (tmp == null) {
                return cflag ? last2 : -1;
            }
            return cflag ? -1 : tmp;
        }
        return cflag && set2 ? last2 : -1;
    }

    public static int multiByteCasecmp(Encoding enc, ByteList value2, ByteList otherValue) {
        int ocl;
        int cl;
        int op;
        byte[] bytes2 = value2.getUnsafeBytes();
        int p2 = value2.getBegin();
        int end2 = p2 + value2.getRealSize();
        byte[] obytes = otherValue.getUnsafeBytes();
        int oend = op + otherValue.getRealSize();
        for (op = otherValue.getBegin(); p2 < end2 && op < oend; p2 += cl, op += ocl) {
            int oc;
            int c;
            if (enc.isAsciiCompatible()) {
                c = bytes2[p2] & 0xFF;
                oc = obytes[op] & 0xFF;
            } else {
                c = StringSupport.preciseCodePoint(enc, bytes2, p2, end2);
                oc = StringSupport.preciseCodePoint(enc, obytes, op, oend);
            }
            if (Encoding.isAscii((int)c) && Encoding.isAscii((int)oc)) {
                byte dc = AsciiTables.ToUpperCaseTable[c];
                byte odc = AsciiTables.ToUpperCaseTable[oc];
                if (dc != odc) {
                    return dc < odc ? -1 : 1;
                }
                if (enc.isAsciiCompatible()) {
                    ocl = 1;
                    cl = 1;
                    continue;
                }
                cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                ocl = StringSupport.preciseLength(enc, obytes, op, oend);
                continue;
            }
            cl = StringSupport.length(enc, bytes2, p2, end2);
            int ret = StringSupport.caseCmp(bytes2, p2, obytes, op, cl < (ocl = StringSupport.length(enc, obytes, op, oend)) ? cl : ocl);
            if (ret != 0) {
                return ret < 0 ? -1 : 1;
            }
            if (cl == ocl) continue;
            return cl < ocl ? -1 : 1;
        }
        if (end2 - p2 == oend - op) {
            return 0;
        }
        return end2 - p2 > oend - op ? 1 : -1;
    }

    public static boolean singleByteSqueeze(ByteList value2, boolean[] squeeze2) {
        int s2;
        int t = s2 = value2.getBegin();
        int send2 = s2 + value2.getRealSize();
        byte[] bytes2 = value2.getUnsafeBytes();
        int save = -1;
        while (s2 < send2) {
            int c;
            if ((c = bytes2[s2++] & 0xFF) == save && squeeze2[c]) continue;
            int n = t++;
            save = c;
            bytes2[n] = (byte)save;
        }
        if (t - value2.getBegin() != value2.getRealSize()) {
            value2.setRealSize(t - value2.getBegin());
            return true;
        }
        return false;
    }

    public static boolean multiByteSqueeze(ByteList value2, boolean[] squeeze2, TrTables tables, Encoding enc, boolean isArg) {
        int s2;
        int t = s2 = value2.getBegin();
        int send2 = s2 + value2.getRealSize();
        byte[] bytes2 = value2.getUnsafeBytes();
        int save = -1;
        while (s2 < send2) {
            int c;
            if (enc.isAsciiCompatible() && (c = bytes2[s2] & 0xFF) < 128) {
                if (c != save || isArg && !squeeze2[c]) {
                    int n = t++;
                    save = c;
                    bytes2[n] = (byte)save;
                }
                ++s2;
                continue;
            }
            c = StringSupport.codePoint(enc, bytes2, s2, send2);
            int cl = StringSupport.codeLength(enc, c);
            if (c != save || isArg && !StringSupport.trFind(c, squeeze2, tables)) {
                if (t != s2) {
                    enc.codeToMbc(c, bytes2, t);
                }
                save = c;
                t += cl;
            }
            s2 += cl;
        }
        if (t - value2.getBegin() != value2.getRealSize()) {
            value2.setRealSize(t - value2.getBegin());
            return true;
        }
        return false;
    }

    public static boolean multiByteSqueeze(Ruby runtime2, ByteList value2, boolean[] squeeze2, TrTables tables, Encoding enc, boolean isArg) {
        try {
            return StringSupport.multiByteSqueeze(value2, squeeze2, tables, enc, isArg);
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError(e.getMessage());
        }
    }

    private static int rb_memsearch_ss(byte[] xsBytes, int xs, int m, byte[] ysBytes, int ys, int n) {
        int y = StringSupport.memmem(ysBytes, ys, n, xsBytes, xs, m);
        if (y != -1) {
            return y - ys;
        }
        return -1;
    }

    public static int memmem(byte[] aBytes, int aStart, int aLen, byte[] p2, int pStart, int pLen) {
        int[] f = StringSupport.failure(p2, pStart, pLen);
        int j = 0;
        for (int i2 = 0; i2 < aLen; ++i2) {
            while (j > 0 && p2[pStart + j] != aBytes[aStart + i2]) {
                j = f[j - 1];
            }
            if (p2[pStart + j] == aBytes[aStart + i2]) {
                ++j;
            }
            if (j != pLen) continue;
            return aStart + i2 - pLen + 1;
        }
        return -1;
    }

    private static int[] failure(byte[] p2, int pStart, int pLen) {
        int[] f = new int[pLen];
        int j = 0;
        for (int i2 = 1; i2 < pLen; ++i2) {
            while (j > 0 && p2[pStart + j] != p2[pStart + i2]) {
                j = f[j - 1];
            }
            if (p2[pStart + j] == p2[pStart + i2]) {
                // empty if block
            }
            f[i2] = ++j;
        }
        return f;
    }

    private static int rb_memsearch_qs(byte[] xsBytes, int xs, int m, byte[] ysBytes, int ys, int n) {
        int xe = xs + m;
        int y = ys;
        int[] qstable = new int[256];
        Arrays.fill(qstable, m + 1);
        for (int x = xs; x < xe; ++x) {
            qstable[xsBytes[x] & 0xFF] = xe - x;
        }
        while (y + m <= ys + n) {
            if (xsBytes[xs] == ysBytes[y] && ByteList.memcmp(xsBytes, xs, ysBytes, y, m) == 0) {
                return y - ys;
            }
            y += qstable[ysBytes[y + m] & 0xFF];
        }
        return -1;
    }

    private static int rb_memsearch_qs_utf8_hash(byte[] xBytes, int x) {
        int mix2 = 8353;
        int h = x != xBytes.length ? xBytes[x] & 0xFF : 0;
        if (h < 192) {
            return h + 256;
        }
        if (h < 224) {
            h *= 8353;
            h += xBytes[x + 1] & 0xFF;
        } else if (h < 240) {
            h *= 8353;
            h += xBytes[x + 1] & 0xFF;
            h *= 8353;
            h += xBytes[x + 2] & 0xFF;
        } else if (h < 245) {
            h *= 8353;
            h += xBytes[x + 1] & 0xFF;
            h *= 8353;
            h += xBytes[x + 2] & 0xFF;
            h *= 8353;
            h += xBytes[x + 3] & 0xFF;
        } else {
            return h + 256;
        }
        return (byte)h & 0xFF;
    }

    private static int rb_memsearch_qs_utf8(byte[] xsBytes, int xs, int m, byte[] ysBytes, int ys, int n) {
        int xe = xs + m;
        int y = ys;
        int[] qstable = new int[512];
        Arrays.fill(qstable, m + 1);
        for (int x = xs; x < xe; ++x) {
            qstable[StringSupport.rb_memsearch_qs_utf8_hash((byte[])xsBytes, (int)x)] = xe - x;
        }
        while (y + m <= ys + n) {
            if (xsBytes[xs] == ysBytes[y] && ByteList.memcmp(xsBytes, xs, ysBytes, y, m) == 0) {
                return y - ys;
            }
            y += qstable[StringSupport.rb_memsearch_qs_utf8_hash(ysBytes, y + m)];
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int checkCaseMapOptions(Ruby runtime2, IRubyObject arg0, IRubyObject arg1, int flags2) {
        RubySymbol turkic = runtime2.newSymbol("turkic");
        RubySymbol lithuanian = runtime2.newSymbol("lithuanian");
        if (arg0.equals(turkic)) {
            flags2 |= 0x100000;
            if (!arg1.equals(lithuanian)) throw runtime2.newArgumentError("invalid second option");
            flags2 |= 0x200000;
            return flags2;
        } else {
            if (!arg0.equals(lithuanian)) throw runtime2.newArgumentError("invalid option");
            flags2 |= 0x200000;
            if (!arg1.equals(turkic)) throw runtime2.newArgumentError("invalid second option");
            flags2 |= 0x100000;
        }
        return flags2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int checkCaseMapOptions(Ruby runtime2, IRubyObject arg0, int flags2) {
        if (arg0.equals(runtime2.newSymbol("ascii"))) {
            flags2 |= 0x400000;
            return flags2;
        } else if (arg0.equals(runtime2.newSymbol("fold"))) {
            if ((flags2 & 0x6000) != 16384) throw runtime2.newArgumentError("option :fold only allowed for downcasing");
            flags2 ^= 0x84000;
            return flags2;
        } else if (arg0.equals(runtime2.newSymbol("turkic"))) {
            flags2 |= 0x100000;
            return flags2;
        } else {
            if (!arg0.equals(runtime2.newSymbol("lithuanian"))) throw runtime2.newArgumentError("invalid option");
            flags2 |= 0x200000;
        }
        return flags2;
    }

    public static ByteList caseMap(Ruby runtime2, ByteList src, IntHolder flags2, Encoding enc) {
        ByteList tgt;
        MappingBuffer root;
        IntHolder pp = new IntHolder();
        pp.value = src.getBegin();
        int end2 = src.getRealSize() + pp.value;
        byte[] bytes2 = src.getUnsafeBytes();
        int tgtLen = 0;
        int buffers = 0;
        MappingBuffer buffer = root = new MappingBuffer();
        while (pp.value < end2) {
            buffer = buffer.next = new MappingBuffer((end2 - pp.value) * ++buffers + 20);
            int len = enc.caseMap(flags2, bytes2, pp, end2, buffer.bytes, 0, buffer.bytes.length);
            if (len < 0) {
                throw runtime2.newArgumentError("input string invalid");
            }
            buffer.used = len;
            tgtLen += len;
        }
        if (buffers == 1) {
            tgt = new ByteList(buffer.bytes, 0, buffer.used, enc, false);
        } else {
            tgt = new ByteList(tgtLen);
            tgt.setEncoding(enc);
            buffer = root.next;
            int tgtPos = 0;
            while (buffer != null) {
                System.arraycopy(buffer.bytes, 0, tgt.getUnsafeBytes(), tgtPos, buffer.used);
                tgtPos += buffer.used;
                buffer = buffer.next;
            }
        }
        return tgt;
    }

    public static void asciiOnlyCaseMap(Ruby runtime2, ByteList value2, IntHolder flags2, Encoding enc) {
        if (value2.getRealSize() == 0) {
            return;
        }
        int s2 = value2.getBegin();
        int end2 = s2 + value2.getRealSize();
        byte[] bytes2 = value2.getUnsafeBytes();
        IntHolder pp = new IntHolder();
        pp.value = s2;
        int len = ASCIIEncoding.INSTANCE.caseMap(flags2, bytes2, pp, end2, bytes2, s2, end2);
        if (len < 0) {
            throw runtime2.newArgumentError("input string invalid");
        }
    }

    public static int encCoderangeClean(int cr) {
        return (cr ^ cr >> 1) & 0x10;
    }

    public static String byteListAsString(ByteList bytes2) {
        try {
            Charset charset = bytes2.getEncoding().getCharset();
            if (charset != null) {
                return new String(bytes2.unsafeBytes(), bytes2.begin(), bytes2.realSize(), charset);
            }
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        return new String(bytes2.unsafeBytes(), bytes2.begin(), bytes2.realSize());
    }

    @Deprecated
    public static boolean isUnicode(Encoding enc) {
        return enc.isUnicode();
    }

    static {
        assert (16 == CR_7BIT_F) : "CR_7BIT = 16 but should be " + CR_7BIT_F;
        assert (32 == CR_VALID_F) : "CR_VALID = 32 but should be " + CR_VALID_F;
        Unsafe unsafe = UnsafeHolder.U;
        ARRAY_BYTE_BASE_OFFSET = unsafe != null ? unsafe.arrayBaseOffset(byte[].class) : 0;
        EMPTY_BYTELIST_ARRAY = new ByteList[0];
        EMPTY_STRING_ARRAY = new String[0];
        DUMMY_VALUE = "";
    }

    private static final class MappingBuffer {
        MappingBuffer next;
        final byte[] bytes;
        int used;

        MappingBuffer() {
            this.bytes = null;
        }

        MappingBuffer(int size2) {
            this.bytes = new byte[size2];
        }
    }

    public static enum NeighborChar {
        NOT_CHAR,
        FOUND,
        WRAPPED;

    }

    public static final class TrTables {
        IntHashMap<Object> del;
        IntHashMap<Object> noDel;
    }

    public static final class TR {
        final byte[] buf;
        int p;
        int pend;
        int now;
        int max;
        boolean gen;

        public TR(ByteList bytes2) {
            this.p = bytes2.getBegin();
            this.pend = bytes2.getRealSize() + this.p;
            this.buf = bytes2.getUnsafeBytes();
            this.max = 0;
            this.now = 0;
            this.gen = false;
        }
    }
}

