/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.InputStream;
import java.io.OutputStream;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Signal;
import org.jruby.Ruby;
import org.jruby.util.io.PosixShim;

public class POSIXProcess
extends Process {
    private final Ruby runtime;
    private final long finalPid;
    volatile Integer exitValue;
    volatile Integer status;

    public POSIXProcess(Ruby runtime2, long finalPid) {
        this.runtime = runtime2;
        this.finalPid = finalPid;
        this.exitValue = null;
    }

    @Override
    public OutputStream getOutputStream() {
        return null;
    }

    @Override
    public InputStream getInputStream() {
        return null;
    }

    @Override
    public InputStream getErrorStream() {
        return null;
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        if (this.exitValue == null) {
            int[] stat_loc;
            block11: {
                stat_loc = new int[]{0};
                block4: while (true) {
                    stat_loc[0] = 0;
                    int result2 = this.runtime.getPosix().waitpid((int)this.finalPid, stat_loc, 0);
                    if (result2 != -1) break block11;
                    Errno errno2 = Errno.valueOf((long)this.runtime.getPosix().errno());
                    switch (errno2) {
                        case EINTR: {
                            this.runtime.getCurrentContext().pollThreadEvents();
                            continue block4;
                        }
                        case ECHILD: {
                            return -1;
                        }
                    }
                    break;
                }
                throw new RuntimeException("unexpected waitpid errno: " + Errno.valueOf((long)this.runtime.getPosix().errno()));
            }
            this.status = stat_loc[0];
            if (PosixShim.WAIT_MACROS.WIFEXITED(this.status.intValue())) {
                this.exitValue = PosixShim.WAIT_MACROS.WEXITSTATUS(this.status.intValue());
            } else if (PosixShim.WAIT_MACROS.WIFSIGNALED(this.status.intValue())) {
                this.exitValue = PosixShim.WAIT_MACROS.WTERMSIG(this.status.intValue());
            } else if (PosixShim.WAIT_MACROS.WIFSTOPPED(this.status.intValue())) {
                this.exitValue = PosixShim.WAIT_MACROS.WSTOPSIG(this.status.intValue());
            }
        }
        return this.exitValue;
    }

    @Override
    public int exitValue() {
        try {
            return this.waitFor();
        }
        catch (InterruptedException ie) {
            throw new IllegalThreadStateException();
        }
    }

    @Override
    public void destroy() {
        this.runtime.getPosix().kill((int)this.finalPid, Signal.SIGTERM.intValue());
    }

    public int status() {
        try {
            this.waitFor();
        }
        catch (InterruptedException ie) {
            throw new IllegalThreadStateException();
        }
        return this.status == null ? -1 : this.status;
    }
}

