/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.auditing;

import java.util.Collections;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextIsNewStrategyFactory;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.support.IsNewStrategyFactory;
import org.springframework.util.Assert;

public class IsNewAwareAuditingHandler
extends AuditingHandler {
    private final IsNewStrategyFactory isNewStrategyFactory;

    @Deprecated
    public IsNewAwareAuditingHandler(MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
        this(new PersistentEntities(Collections.singletonList(mappingContext)));
    }

    public IsNewAwareAuditingHandler(PersistentEntities entities) {
        super(entities);
        this.isNewStrategyFactory = new MappingContextIsNewStrategyFactory(entities);
    }

    public void markAudited(Object object) {
        Assert.notNull((Object)object, (String)"Source object must not be null!");
        if (!this.isAuditable(object)) {
            return;
        }
        IsNewStrategy strategy = this.isNewStrategyFactory.getIsNewStrategy(object.getClass());
        if (strategy.isNew(object)) {
            this.markCreated(object);
        } else {
            this.markModified(object);
        }
    }
}

