/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import javax.xml.transform.Source;
import org.xmlunit.diff.ComparisonFormatter;
import org.xmlunit.diff.DefaultComparisonFormatter;
import org.xmlunit.diff.Difference;

public class Diff {
    private static final ComparisonFormatter DEFAULT_FORMATTER = new DefaultComparisonFormatter();
    private final Iterable<Difference> differences;
    private final Source controlSource;
    private final Source testSource;
    private final ComparisonFormatter formatter;

    public Diff(Source controlSource, Source testSource, Iterable<Difference> differences) {
        this(controlSource, testSource, DEFAULT_FORMATTER, differences);
    }

    public Diff(Source controlSource, Source testSource, ComparisonFormatter formatter, Iterable<Difference> differences) {
        this.controlSource = controlSource;
        this.testSource = testSource;
        this.formatter = formatter;
        this.differences = differences;
        for (Difference d : differences) {
            d.setComparisonFormatter(formatter);
        }
    }

    public boolean hasDifferences() {
        return this.differences.iterator().hasNext();
    }

    public Iterable<Difference> getDifferences() {
        return this.differences;
    }

    public Source getControlSource() {
        return this.controlSource;
    }

    public Source getTestSource() {
        return this.testSource;
    }

    public String toString() {
        return this.toString(this.formatter);
    }

    public String toString(ComparisonFormatter formatter) {
        if (!this.hasDifferences()) {
            return "[identical]";
        }
        return this.getDifferences().iterator().next().getComparison().toString(formatter);
    }
}

