/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.metadata.unmarshalling;

import org.jboss.xb.binding.metadata.unmarshalling.DocumentBinding;

public interface BindingCursor {
    public void startElement(String var1, String var2);

    public void endElement(String var1, String var2);

    public Object getElementBinding();

    public Object getParentElementBinding();

    public static class Factory {
        private Factory() {
        }

        public static BindingCursor newCursor(DocumentBinding doc) {
            if (doc != null) {
                throw new IllegalArgumentException("DocumentBinding API is not supported anymore");
            }
            return NoopBindingCursor.INSTANCE;
        }

        private static class NoopBindingCursor
        implements BindingCursor {
            static final BindingCursor INSTANCE = new NoopBindingCursor();

            private NoopBindingCursor() {
            }

            public void startElement(String namespaceURI, String localName) {
            }

            public void endElement(String namespaceURI, String localName) {
            }

            public Object getElementBinding() {
                return null;
            }

            public Object getParentElementBinding() {
                return null;
            }
        }
    }
}

