/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.env;

import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceType;

public class NameEnvironmentAnswer {
    IBinaryType binaryType;
    ICompilationUnit compilationUnit;
    ISourceType[] sourceTypes;
    AccessRestriction accessRestriction;
    String externalAnnotationPath;

    public NameEnvironmentAnswer(IBinaryType binaryType, AccessRestriction accessRestriction) {
        this.binaryType = binaryType;
        this.accessRestriction = accessRestriction;
    }

    public NameEnvironmentAnswer(ICompilationUnit compilationUnit, AccessRestriction accessRestriction) {
        this.compilationUnit = compilationUnit;
        this.accessRestriction = accessRestriction;
    }

    public NameEnvironmentAnswer(ISourceType[] sourceTypes, AccessRestriction accessRestriction, String externalAnnotationPath) {
        this.sourceTypes = sourceTypes;
        this.accessRestriction = accessRestriction;
        this.externalAnnotationPath = externalAnnotationPath;
    }

    public String toString() {
        String baseString = "";
        if (this.binaryType != null) {
            char[] fileNameChars = this.binaryType.getFileName();
            String fileName = fileNameChars == null ? "" : new String(fileNameChars);
            baseString = "IBinaryType " + fileName;
        }
        if (this.compilationUnit != null) {
            baseString = "ICompilationUnit " + this.compilationUnit.toString();
        }
        if (this.sourceTypes != null) {
            baseString = this.sourceTypes.toString();
        }
        if (this.accessRestriction != null) {
            baseString = String.valueOf(baseString) + " " + this.accessRestriction.toString();
        }
        if (this.externalAnnotationPath != null) {
            baseString = String.valueOf(baseString) + " extPath=" + this.externalAnnotationPath.toString();
        }
        return baseString;
    }

    public AccessRestriction getAccessRestriction() {
        return this.accessRestriction;
    }

    public void setBinaryType(IBinaryType newType) {
        this.binaryType = newType;
    }

    public IBinaryType getBinaryType() {
        return this.binaryType;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public String getExternalAnnotationPath() {
        return this.externalAnnotationPath;
    }

    public ISourceType[] getSourceTypes() {
        return this.sourceTypes;
    }

    public boolean isBinaryType() {
        return this.binaryType != null;
    }

    public boolean isCompilationUnit() {
        return this.compilationUnit != null;
    }

    public boolean isSourceType() {
        return this.sourceTypes != null;
    }

    public boolean ignoreIfBetter() {
        return this.accessRestriction != null && this.accessRestriction.ignoreIfBetter();
    }

    public boolean isBetter(NameEnvironmentAnswer otherAnswer) {
        if (otherAnswer == null) {
            return true;
        }
        if (this.accessRestriction == null) {
            return true;
        }
        return otherAnswer.accessRestriction != null && this.accessRestriction.getProblemId() < otherAnswer.accessRestriction.getProblemId();
    }
}

