/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.java;

import java.io.File;
import java.util.List;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNodeTypeRegistry;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.ChunkCache;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Database;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldSearchIndex;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdAnnotation;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdAnnotationInConstant;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdAnnotationInMethod;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdAnnotationInMethodParameter;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdAnnotationInType;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdAnnotationInVariable;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdAnnotationValuePair;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdBinding;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdComplexTypeSignature;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstant;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantAnnotation;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantArray;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantBoolean;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantByte;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantChar;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantClass;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantDouble;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantEnum;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantFloat;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantInt;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantLong;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantShort;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstantString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdMethod;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdMethodException;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdMethodId;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdMethodParameter;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdResourceFile;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTreeNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdType;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeAnnotation;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeAnnotationInMethod;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeAnnotationInType;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeAnnotationInVariable;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeArgument;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeBound;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeId;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeInterface;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeParameter;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeSignature;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdVariable;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdWorkspaceLocation;
import org.aspectj.org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;

public class JavaIndex {
    static final int CURRENT_VERSION = Nd.version(1, 38);
    static final int MAX_SUPPORTED_VERSION = Nd.version(1, 38);
    static final int MIN_SUPPORTED_VERSION = Nd.version(1, 38);
    public static final FieldSearchIndex<NdResourceFile> FILES;
    public static final FieldSearchIndex<NdTypeId> SIMPLE_INDEX;
    public static final FieldSearchIndex<NdTypeId> TYPES;
    public static final FieldSearchIndex<NdMethodId> METHODS;
    public static final StructDef<JavaIndex> type;
    private static final BestResourceFile bestResourceFile;
    private final long address;
    private Nd nd;
    private FieldSearchIndex.IResultRank anyResult = new FieldSearchIndex.IResultRank(){

        @Override
        public long getRank(Nd dom, long address1) {
            return 1L;
        }
    };
    private static Nd globalNd;
    private static final String INDEX_FILENAME = "index.db";
    private static final Object ndMutex;

    static {
        type = StructDef.create(JavaIndex.class);
        FILES = FieldSearchIndex.create(type, NdResourceFile.FILENAME);
        SIMPLE_INDEX = FieldSearchIndex.create(type, NdTypeId.SIMPLE_NAME);
        TYPES = FieldSearchIndex.create(type, NdTypeId.FIELD_DESCRIPTOR);
        METHODS = FieldSearchIndex.create(type, NdMethodId.METHOD_NAME);
        type.done();
        assert (type.getFactory().getRecordSize() <= 4096);
        bestResourceFile = new BestResourceFile();
        ndMutex = new Object();
    }

    public JavaIndex(Nd dom, long address) {
        this.address = address;
        this.nd = dom;
    }

    public NdResourceFile getResourceFile(char[] location) {
        return FILES.findBest(this.nd, this.address, FieldSearchIndex.SearchCriteria.create(location), bestResourceFile);
    }

    public boolean isUpToDate(NdResourceFile file) throws CoreException {
        if (file != null && file.isDoneIndexing()) {
            Path locationPath = new Path(file.getLocation().getString());
            if (file.getFingerprint().test(locationPath, null).matches()) {
                return true;
            }
        }
        return false;
    }

    public List<NdResourceFile> findResourcesWithPath(String thePath) {
        return FILES.findAll(this.nd, this.address, FieldSearchIndex.SearchCriteria.create(thePath.toCharArray()));
    }

    public List<NdResourceFile> getAllResourceFiles() {
        return FILES.asList(this.nd, this.address);
    }

    public NdTypeId findType(char[] fieldDescriptor) {
        FieldSearchIndex.SearchCriteria searchCriteria = FieldSearchIndex.SearchCriteria.create(fieldDescriptor);
        return TYPES.findBest(this.nd, this.address, searchCriteria, this.anyResult);
    }

    public boolean visitFieldDescriptorsStartingWith(char[] fieldDescriptorPrefix, FieldSearchIndex.Visitor<NdTypeId> visitor) {
        FieldSearchIndex.SearchCriteria searchCriteria = FieldSearchIndex.SearchCriteria.create(fieldDescriptorPrefix).prefix(true);
        return TYPES.visitAll(this.nd, this.address, searchCriteria, visitor);
    }

    public NdTypeId createTypeId(char[] fieldDescriptor) {
        NdTypeId existingType = this.findType(fieldDescriptor);
        if (existingType != null) {
            return existingType;
        }
        if (fieldDescriptor.length > 1 && fieldDescriptor[0] == 'L' && fieldDescriptor[fieldDescriptor.length - 1] != ';') {
            throw new IllegalStateException(String.valueOf(new String(fieldDescriptor)) + " is not a valid field descriptor");
        }
        NdTypeId result = new NdTypeId(this.nd, fieldDescriptor);
        if (!CharArrayUtils.equals(result.getFieldDescriptor().getChars(), fieldDescriptor)) {
            throw new IllegalStateException("Field descriptor didn't match");
        }
        return result;
    }

    public Nd getNd() {
        return this.nd;
    }

    public NdMethodId findMethodId(char[] methodId) {
        FieldSearchIndex.SearchCriteria searchCriteria = FieldSearchIndex.SearchCriteria.create(methodId);
        return METHODS.findBest(this.nd, this.address, searchCriteria, this.anyResult);
    }

    public NdMethodId createMethodId(char[] methodId) {
        NdMethodId existingMethod = this.findMethodId(methodId);
        if (existingMethod != null) {
            return existingMethod;
        }
        return new NdMethodId(this.nd, methodId);
    }

    public static IPath getLocationForElement(IJavaElement next) {
        IResource resource = next.getResource();
        if (resource != null) {
            return resource.getLocation() == null ? new Path("") : resource.getLocation();
        }
        return next.getPath();
    }

    public static boolean isEnabled() {
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService == null) {
            return true;
        }
        return !preferenceService.getBoolean("org.aspectj.org.eclipse.jdt.core", "disableNewJavaIndex", false, null);
    }

    public static Nd createNd(File databaseFile, ChunkCache chunkCache) {
        return new Nd(databaseFile, chunkCache, JavaIndex.createTypeRegistry(), MIN_SUPPORTED_VERSION, MAX_SUPPORTED_VERSION, CURRENT_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Nd getGlobalNd() {
        Nd localNd;
        Object object = ndMutex;
        synchronized (object) {
            localNd = globalNd;
        }
        if (localNd != null) {
            return localNd;
        }
        localNd = JavaIndex.createNd(JavaIndex.getDBFile(), ChunkCache.getSharedInstance());
        object = ndMutex;
        synchronized (object) {
            if (globalNd == null) {
                globalNd = localNd;
            }
            return globalNd;
        }
    }

    public static JavaIndex getIndex(Nd nd) {
        return new JavaIndex(nd, Database.DATA_AREA_OFFSET);
    }

    public static JavaIndex getIndex() {
        return JavaIndex.getIndex(JavaIndex.getGlobalNd());
    }

    public static int getCurrentVersion() {
        return CURRENT_VERSION;
    }

    static File getDBFile() {
        IPath stateLocation = JavaCore.getPlugin().getStateLocation();
        return stateLocation.append(INDEX_FILENAME).toFile();
    }

    static NdNodeTypeRegistry<NdNode> createTypeRegistry() {
        NdNodeTypeRegistry<NdNode> registry = new NdNodeTypeRegistry<NdNode>();
        registry.register(1, NdAnnotation.type.getFactory());
        registry.register(4, NdAnnotationInConstant.type.getFactory());
        registry.register(8, NdAnnotationInMethod.type.getFactory());
        registry.register(12, NdAnnotationInMethodParameter.type.getFactory());
        registry.register(16, NdAnnotationInType.type.getFactory());
        registry.register(20, NdAnnotationInVariable.type.getFactory());
        registry.register(32, NdAnnotationValuePair.type.getFactory());
        registry.register(40, NdBinding.type.getFactory());
        registry.register(48, NdComplexTypeSignature.type.getFactory());
        registry.register(56, NdConstant.type.getFactory());
        registry.register(64, NdConstantAnnotation.type.getFactory());
        registry.register(80, NdConstantArray.type.getFactory());
        registry.register(96, NdConstantBoolean.type.getFactory());
        registry.register(112, NdConstantByte.type.getFactory());
        registry.register(128, NdConstantChar.type.getFactory());
        registry.register(144, NdConstantClass.type.getFactory());
        registry.register(160, NdConstantDouble.type.getFactory());
        registry.register(176, NdConstantEnum.type.getFactory());
        registry.register(192, NdConstantFloat.type.getFactory());
        registry.register(208, NdConstantInt.type.getFactory());
        registry.register(224, NdConstantLong.type.getFactory());
        registry.register(240, NdConstantShort.type.getFactory());
        registry.register(256, NdConstantString.type.getFactory());
        registry.register(272, NdMethod.type.getFactory());
        registry.register(288, NdMethodException.type.getFactory());
        registry.register(304, NdMethodId.type.getFactory());
        registry.register(320, NdMethodParameter.type.getFactory());
        registry.register(336, NdResourceFile.type.getFactory());
        registry.register(352, NdTreeNode.type.getFactory());
        registry.register(368, NdType.type.getFactory());
        registry.register(384, NdTypeAnnotation.type.getFactory());
        registry.register(388, NdTypeAnnotationInMethod.type.getFactory());
        registry.register(392, NdTypeAnnotationInType.type.getFactory());
        registry.register(396, NdTypeAnnotationInVariable.type.getFactory());
        registry.register(400, NdTypeArgument.type.getFactory());
        registry.register(404, NdTypeBound.type.getFactory());
        registry.register(416, NdTypeInterface.type.getFactory());
        registry.register(432, NdTypeParameter.type.getFactory());
        registry.register(448, NdTypeSignature.type.getFactory());
        registry.register(464, NdTypeId.type.getFactory());
        registry.register(480, NdTypeInterface.type.getFactory());
        registry.register(496, NdVariable.type.getFactory());
        registry.register(512, NdWorkspaceLocation.type.getFactory());
        return registry;
    }

    private static final class BestResourceFile
    implements FieldSearchIndex.IResultRank {
        @Override
        public long getRank(Nd resourceFileNd, long resourceFileAddress) {
            return NdResourceFile.TIME_LAST_SCANNED.get(resourceFileNd, resourceFileAddress);
        }
    }
}

