/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.matcher;

import java.util.HashSet;
import java.util.Set;
import org.assertj.core.internal.bytebuddy.description.type.TypeDefinition;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;

public class HasSuperTypeMatcher<T extends TypeDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ElementMatcher<? super TypeDescription.Generic> matcher;

    public HasSuperTypeMatcher(ElementMatcher<? super TypeDescription.Generic> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(T target) {
        HashSet<TypeDescription> checkedInterfaces = new HashSet<TypeDescription>();
        for (TypeDefinition typeDefinition : target) {
            if (!this.matcher.matches(typeDefinition.asGenericType()) && !this.hasInterface(typeDefinition, checkedInterfaces)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInterface(TypeDefinition typeDefinition, Set<TypeDescription> checkedInterfaces) {
        for (TypeDefinition interfaceType : typeDefinition.getInterfaces()) {
            if (!checkedInterfaces.add(interfaceType.asErasure()) || !this.matcher.matches(interfaceType.asGenericType()) && !this.hasInterface(interfaceType, checkedInterfaces)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "hasSuperType(" + this.matcher + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasSuperTypeMatcher)) {
            return false;
        }
        HasSuperTypeMatcher other = (HasSuperTypeMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ElementMatcher<? super TypeDescription.Generic> this$matcher = this.matcher;
        ElementMatcher<? super TypeDescription.Generic> other$matcher = other.matcher;
        return !(this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HasSuperTypeMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ElementMatcher<? super TypeDescription.Generic> $matcher = this.matcher;
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        return result;
    }
}

