/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.matcher;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.internal.bytebuddy.description.field.FieldDescription;
import org.assertj.core.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;

public interface LatentMatcher<T> {
    public ElementMatcher<? super T> resolve(TypeDescription var1);

    public static class Disjunction<S>
    implements LatentMatcher<S> {
        private final List<? extends LatentMatcher<? super S>> matchers;

        public Disjunction(LatentMatcher<? super S> ... matcher) {
            this(Arrays.asList(matcher));
        }

        public Disjunction(List<? extends LatentMatcher<? super S>> matchers) {
            this.matchers = matchers;
        }

        @Override
        public ElementMatcher<? super S> resolve(TypeDescription typeDescription) {
            ElementMatcher.Junction<Object> matcher = ElementMatchers.none();
            for (LatentMatcher<S> latentMatcher : this.matchers) {
                matcher = matcher.or(latentMatcher.resolve(typeDescription));
            }
            return matcher;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Disjunction)) {
                return false;
            }
            Disjunction other = (Disjunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<LatentMatcher<S>> this$matchers = this.matchers;
            List<? extends LatentMatcher<? super S>> other$matchers = other.matchers;
            return !(this$matchers == null ? other$matchers != null : !((Object)this$matchers).equals(other$matchers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Disjunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<LatentMatcher<S>> $matchers = this.matchers;
            result = result * 59 + ($matchers == null ? 43 : ((Object)$matchers).hashCode());
            return result;
        }
    }

    public static class Conjunction<S>
    implements LatentMatcher<S> {
        private final List<? extends LatentMatcher<? super S>> matchers;

        public Conjunction(LatentMatcher<? super S> ... matcher) {
            this(Arrays.asList(matcher));
        }

        public Conjunction(List<? extends LatentMatcher<? super S>> matchers) {
            this.matchers = matchers;
        }

        @Override
        public ElementMatcher<? super S> resolve(TypeDescription typeDescription) {
            ElementMatcher.Junction<Object> matcher = ElementMatchers.any();
            for (LatentMatcher<S> latentMatcher : this.matchers) {
                matcher = matcher.and(latentMatcher.resolve(typeDescription));
            }
            return matcher;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conjunction)) {
                return false;
            }
            Conjunction other = (Conjunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<LatentMatcher<S>> this$matchers = this.matchers;
            List<? extends LatentMatcher<? super S>> other$matchers = other.matchers;
            return !(this$matchers == null ? other$matchers != null : !((Object)this$matchers).equals(other$matchers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Conjunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<LatentMatcher<S>> $matchers = this.matchers;
            result = result * 59 + ($matchers == null ? 43 : ((Object)$matchers).hashCode());
            return result;
        }
    }

    public static class ForMethodToken
    implements LatentMatcher<MethodDescription> {
        private final MethodDescription.Token token;

        public ForMethodToken(MethodDescription.Token token) {
            this.token = token;
        }

        @Override
        public ElementMatcher<? super MethodDescription> resolve(TypeDescription typeDescription) {
            return new ResolvedMatcher(this.token.asSignatureToken(typeDescription));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForMethodToken)) {
                return false;
            }
            ForMethodToken other = (ForMethodToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MethodDescription.Token this$token = this.token;
            MethodDescription.Token other$token = other.token;
            return !(this$token == null ? other$token != null : !((Object)this$token).equals(other$token));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForMethodToken;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MethodDescription.Token $token = this.token;
            result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
            return result;
        }

        protected static class ResolvedMatcher
        implements ElementMatcher<MethodDescription> {
            private final MethodDescription.SignatureToken signatureToken;

            protected ResolvedMatcher(MethodDescription.SignatureToken signatureToken) {
                this.signatureToken = signatureToken;
            }

            @Override
            public boolean matches(MethodDescription target) {
                return target.asSignatureToken().equals(this.signatureToken);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ResolvedMatcher)) {
                    return false;
                }
                ResolvedMatcher other = (ResolvedMatcher)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MethodDescription.SignatureToken this$signatureToken = this.signatureToken;
                MethodDescription.SignatureToken other$signatureToken = other.signatureToken;
                return !(this$signatureToken == null ? other$signatureToken != null : !((Object)this$signatureToken).equals(other$signatureToken));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ResolvedMatcher;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodDescription.SignatureToken $signatureToken = this.signatureToken;
                result = result * 59 + ($signatureToken == null ? 43 : ((Object)$signatureToken).hashCode());
                return result;
            }
        }
    }

    public static class ForFieldToken
    implements LatentMatcher<FieldDescription> {
        private final FieldDescription.Token token;

        public ForFieldToken(FieldDescription.Token token) {
            this.token = token;
        }

        @Override
        public ElementMatcher<? super FieldDescription> resolve(TypeDescription typeDescription) {
            return new ResolvedMatcher(this.token.asSignatureToken(typeDescription));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForFieldToken)) {
                return false;
            }
            ForFieldToken other = (ForFieldToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FieldDescription.Token this$token = this.token;
            FieldDescription.Token other$token = other.token;
            return !(this$token == null ? other$token != null : !((Object)this$token).equals(other$token));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForFieldToken;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FieldDescription.Token $token = this.token;
            result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
            return result;
        }

        protected static class ResolvedMatcher
        implements ElementMatcher<FieldDescription> {
            private final FieldDescription.SignatureToken signatureToken;

            protected ResolvedMatcher(FieldDescription.SignatureToken signatureToken) {
                this.signatureToken = signatureToken;
            }

            @Override
            public boolean matches(FieldDescription target) {
                return target.asSignatureToken().equals(this.signatureToken);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ResolvedMatcher)) {
                    return false;
                }
                ResolvedMatcher other = (ResolvedMatcher)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                FieldDescription.SignatureToken this$signatureToken = this.signatureToken;
                FieldDescription.SignatureToken other$signatureToken = other.signatureToken;
                return !(this$signatureToken == null ? other$signatureToken != null : !((Object)this$signatureToken).equals(other$signatureToken));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ResolvedMatcher;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                FieldDescription.SignatureToken $signatureToken = this.signatureToken;
                result = result * 59 + ($signatureToken == null ? 43 : ((Object)$signatureToken).hashCode());
                return result;
            }
        }
    }

    public static class Resolved<S>
    implements LatentMatcher<S> {
        private final ElementMatcher<? super S> matcher;

        public Resolved(ElementMatcher<? super S> matcher) {
            this.matcher = matcher;
        }

        @Override
        public ElementMatcher<? super S> resolve(TypeDescription typeDescription) {
            return this.matcher;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resolved)) {
                return false;
            }
            Resolved other = (Resolved)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ElementMatcher<S> this$matcher = this.matcher;
            ElementMatcher<? super S> other$matcher = other.matcher;
            return !(this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Resolved;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ElementMatcher<S> $matcher = this.matcher;
            result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
            return result;
        }
    }

    public static enum ForSelfDeclaredMethod implements LatentMatcher<MethodDescription>
    {
        DECLARED(false),
        NOT_DECLARED(true);

        private final boolean inverted;

        private ForSelfDeclaredMethod(boolean inverted) {
            this.inverted = inverted;
        }

        @Override
        public ElementMatcher<? super MethodDescription> resolve(TypeDescription typeDescription) {
            return this.inverted ? ElementMatchers.not(ElementMatchers.isDeclaredBy(typeDescription)) : ElementMatchers.isDeclaredBy(typeDescription);
        }
    }
}

