/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.regions;

import java.util.Properties;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.nonstop.NonStopCacheException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.EhCacheMessageLogger;
import org.hibernate.cache.ehcache.internal.nonstop.HibernateNonstopCacheExceptionHandler;
import org.hibernate.cache.ehcache.internal.regions.EhcacheDataRegion;
import org.hibernate.cache.ehcache.internal.strategy.EhcacheAccessStrategyFactory;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.jboss.logging.Logger;

abstract class EhcacheGeneralDataRegion
extends EhcacheDataRegion
implements GeneralDataRegion {
    private static final EhCacheMessageLogger LOG = (EhCacheMessageLogger)Logger.getMessageLogger(EhCacheMessageLogger.class, (String)EhcacheGeneralDataRegion.class.getName());

    public EhcacheGeneralDataRegion(EhcacheAccessStrategyFactory accessStrategyFactory, Ehcache cache, Properties properties) {
        super(accessStrategyFactory, cache, properties);
    }

    public Object get(Object key) throws CacheException {
        try {
            LOG.debugf("key: %s", key);
            if (key == null) {
                return null;
            }
            Element element = this.cache.get(key);
            if (element == null) {
                LOG.debugf("Element for key %s is null", key);
                return null;
            }
            return element.getObjectValue();
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
                return null;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void put(Object key, Object value) throws CacheException {
        LOG.debugf("key: %s value: %s", key, value);
        try {
            Element element = new Element(key, value);
            this.cache.put(element);
        }
        catch (IllegalArgumentException e) {
            throw new CacheException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new CacheException((Throwable)e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void evict(Object key) throws CacheException {
        try {
            this.cache.remove(key);
        }
        catch (ClassCastException e) {
            throw new CacheException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new CacheException((Throwable)e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void evictAll() throws CacheException {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException e) {
            throw new CacheException((Throwable)e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException((Throwable)e);
        }
    }
}

