/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.MappingException;

public final class JDBCToHibernateTypeHelper {
    private static final Map PREFERRED_HIBERNATETYPE_FOR_SQLTYPE = new HashMap();
    static Map jdbcTypes;
    static Map jdbcTypeValues;

    private JDBCToHibernateTypeHelper() {
    }

    public static String getPreferredHibernateType(int sqlType, int size, int precision, int scale, boolean nullable, boolean generatedIdentifier) {
        boolean returnNullable;
        boolean bl = returnNullable = nullable || generatedIdentifier;
        if ((sqlType == 3 || sqlType == 2) && scale <= 0) {
            if (precision == 1) {
                return returnNullable ? Boolean.class.getName() : "boolean";
            }
            if (precision < 3) {
                return returnNullable ? Byte.class.getName() : "byte";
            }
            if (precision < 5) {
                return returnNullable ? Short.class.getName() : "short";
            }
            if (precision < 10) {
                return returnNullable ? Integer.class.getName() : "int";
            }
            if (precision < 19) {
                return returnNullable ? Long.class.getName() : "long";
            }
            return "big_decimal";
        }
        if (sqlType == 1 && size > 1) {
            return "string";
        }
        String[] result = (String[])PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.get(new Integer(sqlType));
        if (result == null) {
            return null;
        }
        if (returnNullable) {
            return result[1];
        }
        return result[0];
    }

    public static String[] getJDBCTypes() {
        JDBCToHibernateTypeHelper.checkTypes();
        return jdbcTypes.keySet().toArray(new String[jdbcTypes.size()]);
    }

    public static int getJDBCType(String value) {
        JDBCToHibernateTypeHelper.checkTypes();
        Integer number = (Integer)jdbcTypes.get(value);
        if (number == null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new MappingException("jdbc-type: " + value + " is not a known JDBC Type nor a valid number");
            }
        }
        return number;
    }

    private static void checkTypes() {
        if (jdbcTypes == null) {
            jdbcTypes = new HashMap();
            Field[] fields = Types.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!Modifier.isStatic(field.getModifiers())) continue;
                try {
                    jdbcTypes.put(field.getName(), field.get(class$java$sql$Types == null ? JDBCToHibernateTypeHelper.class$("java.sql.Types") : class$java$sql$Types));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public static String getJDBCTypeName(int value) {
        String name;
        if (jdbcTypeValues == null) {
            jdbcTypeValues = new HashMap();
            Field[] fields = Types.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!Modifier.isStatic(field.getModifiers())) continue;
                try {
                    jdbcTypeValues.put(field.get(class$java$sql$Types == null ? JDBCToHibernateTypeHelper.class$("java.sql.Types") : class$java$sql$Types), field.getName());
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        if ((name = (String)jdbcTypeValues.get(new Integer(value))) != null) {
            return name;
        }
        return "" + value;
    }

    public static boolean typeHasScaleAndPrecision(int sqlType) {
        return sqlType == 3 || sqlType == 2 || sqlType == 7 || sqlType == 6 || sqlType == 8;
    }

    public static boolean typeHasLength(int sqlType) {
        return sqlType == 1 || sqlType == 91 || sqlType == -1 || sqlType == 92 || sqlType == 93 || sqlType == 12;
    }

    static {
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-6), new String[]{"byte", Byte.class.getName()});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(5), new String[]{"short", Short.class.getName()});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(4), new String[]{"int", Integer.class.getName()});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-5), new String[]{"long", Long.class.getName()});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(7), new String[]{"float", Float.class.getName()});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(6), new String[]{"double", Double.class.getName()});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(8), new String[]{"double", Double.class.getName()});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(3), new String[]{"big_decimal", "big_decimal"});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(2), new String[]{"big_decimal", "big_decimal"});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-7), new String[]{"boolean", Boolean.class.getName()});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(16), new String[]{"boolean", Boolean.class.getName()});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(1), new String[]{"char", Character.class.getName()});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(12), new String[]{"string", "string"});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-1), new String[]{"string", "string"});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-2), new String[]{"binary", "binary"});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-3), new String[]{"binary", "binary"});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-4), new String[]{"binary", "binary"});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(91), new String[]{"date", "date"});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(92), new String[]{"time", "time"});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(93), new String[]{"timestamp", "timestamp"});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(2005), new String[]{"clob", "clob"});
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(2004), new String[]{"blob", "blob"});
    }
}

