/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.stat;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class BeanTableModel
extends AbstractTableModel {
    protected List list;
    private BeanInfo beanInfo = null;
    private PropertyDescriptor[] descriptors = null;

    public BeanTableModel(List list, Class beanClass) {
        this.list = list;
        this.introspect(beanClass);
    }

    private void introspect(Class beanClass) {
        try {
            this.beanInfo = Introspector.getBeanInfo(beanClass, 1);
            this.descriptors = this.beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        ArrayList<PropertyDescriptor> v = new ArrayList<PropertyDescriptor>(this.descriptors.length);
        for (int i = 0; i < this.descriptors.length; ++i) {
            if (this.descriptors[i].getName().equals("class")) continue;
            v.add(this.descriptors[i]);
        }
        this.descriptors = v.toArray(new PropertyDescriptor[v.size()]);
    }

    boolean isSingle() {
        return this.list.size() <= 1;
    }

    @Override
    public int getRowCount() {
        return this.isSingle() ? this.descriptors.length : this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.isSingle() ? this.list.size() + 1 : (this.descriptors != null ? this.descriptors.length : 0);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.isSingle()) {
            if (col == 0) {
                return this.descriptors[row].getDisplayName();
            }
            return this.getValue(0, row);
        }
        return this.getValue(row, col);
    }

    private Object getValue(int row, int col) {
        Object bean = this.list.get(row);
        Object result = null;
        try {
            result = this.descriptors[col].getReadMethod().invoke(bean, null);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        return result;
    }

    @Override
    public String getColumnName(int col) {
        if (this.isSingle()) {
            if (col == 0) {
                return "Name";
            }
            return "Value";
        }
        return this.descriptors[col].getDisplayName();
    }

    public Class getColumnClass(int c) {
        if (this.isSingle()) {
            return String.class;
        }
        Class<?> propertyType = this.descriptors[c].getPropertyType();
        if (propertyType.isPrimitive()) {
            return String.class;
        }
        return propertyType;
    }
}

