/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.Mappings;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Value;

public class JDBCCollectionSecondPass
extends CollectionSecondPass {
    JDBCCollectionSecondPass(Mappings mappings, Collection coll) {
        super(mappings, coll);
    }

    public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
        this.bindCollectionSecondPass(this.collection, persistentClasses, this.mappings, inheritedMetas);
    }

    public void doSecondPass(Map persistentClasses) throws MappingException {
        Value element = this.collection.getElement();
        DependantValue elementDependantValue = null;
        String oldElementForeignKeyName = null;
        if (element instanceof DependantValue) {
            elementDependantValue = (DependantValue)element;
            oldElementForeignKeyName = elementDependantValue.getForeignKeyName();
            elementDependantValue.setForeignKeyName("none");
        }
        KeyValue key = this.collection.getKey();
        DependantValue keyDependantValue = null;
        String oldKeyForeignKeyName = null;
        if (key instanceof DependantValue) {
            keyDependantValue = (DependantValue)key;
            oldKeyForeignKeyName = keyDependantValue.getForeignKeyName();
            keyDependantValue.setForeignKeyName("none");
        }
        super.doSecondPass(persistentClasses);
        if (elementDependantValue != null) {
            elementDependantValue.setForeignKeyName(oldElementForeignKeyName);
        }
        if (keyDependantValue != null) {
            keyDependantValue.setForeignKeyName(oldKeyForeignKeyName);
        }
    }

    private void bindCollectionSecondPass(Collection collection, Map<?, ?> persistentClasses, Mappings mappings, Map<?, ?> inheritedMetas) throws MappingException {
        if (collection.isOneToMany()) {
            OneToMany oneToMany = (OneToMany)collection.getElement();
            PersistentClass persistentClass = mappings.getClass(oneToMany.getReferencedEntityName());
            if (persistentClass == null) {
                throw new MappingException("Association " + collection.getRole() + " references unmapped class: " + oneToMany.getReferencedEntityName());
            }
            oneToMany.setAssociatedClass(persistentClass);
        }
    }
}

