/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.tool.ant.ConfigurationTask;

public class JPAConfigurationTask
extends ConfigurationTask {
    private String persistenceUnit = null;

    public JPAConfigurationTask() {
        this.setDescription("JPA Configuration");
    }

    @Override
    protected Configuration createConfiguration() {
        try {
            HashMap<Object, Object> overrides = new HashMap<Object, Object>();
            Properties p = this.getProperties();
            if (p != null) {
                overrides.putAll(p);
            }
            Class hibernatePersistanceProviderClass = ReflectHelper.classForName((String)"org.hibernate.jpa.HibernatePersistenceProvider", JPAConfigurationTask.class);
            Object hibernatePersistanceProvider = hibernatePersistanceProviderClass.newInstance();
            Method getEntityManagerFactoryBuilderOrNull = hibernatePersistanceProviderClass.getDeclaredMethod("getEntityManagerFactoryBuilderOrNull", String.class, Map.class);
            getEntityManagerFactoryBuilderOrNull.setAccessible(true);
            Object entityManagerFactoryBuilder = getEntityManagerFactoryBuilderOrNull.invoke(hibernatePersistanceProvider, this.persistenceUnit, overrides);
            if (entityManagerFactoryBuilder == null) {
                throw new BuildException("Persistence unit not found: '" + this.persistenceUnit + "'.");
            }
            Method build = entityManagerFactoryBuilder.getClass().getMethod("build", new Class[0]);
            build.invoke(entityManagerFactoryBuilder, (Object[])null);
            Method getHibernateConfiguration = entityManagerFactoryBuilder.getClass().getMethod("getHibernateConfiguration", new Class[0]);
            return (Configuration)getHibernateConfiguration.invoke(entityManagerFactoryBuilder, (Object[])null);
        }
        catch (HibernateException he) {
            throw new BuildException((Throwable)he);
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception t) {
            Throwable cause = t.getCause();
            if (cause != null) {
                throw new BuildException(cause);
            }
            t.printStackTrace();
            throw new BuildException("Problems in creating a configuration for JPA. Have you remembered to add hibernate EntityManager jars to the classpath ?", (Throwable)t);
        }
    }

    @Override
    protected void doConfiguration(Configuration configuration) {
    }

    @Override
    protected void validateParameters() throws BuildException {
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    @Override
    public void setConfigurationFile(File configurationFile) {
        this.complain("configurationfile");
    }

    private void complain(String param) {
        throw new BuildException("<" + this.getTaskName() + "> currently only support autodiscovery from META-INF/persistence.xml. Thus setting the " + param + " attribute is not allowed");
    }
}

