/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.servlet;

import java.io.IOException;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.spi.DeploymentAspectManagerLocator;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.management.EndpointResolver;

public abstract class AbstractEndpointServlet
extends HttpServlet {
    private static final String PROPERTY_NAME = "org.jboss.ws.webapp.ServletAspectManagerName";
    private final SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
    protected Endpoint endpoint;
    private EndpointRegistry epRegistry;
    private DeploymentAspectManager aspectsManager;
    private boolean backwardCompatibilityMode;

    protected AbstractEndpointServlet() {
    }

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initRegistry();
        this.initServiceEndpoint(servletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        try {
            this.stopAspectManager();
            this.stopEndpoint();
        }
        finally {
            super.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            EndpointAssociation.setEndpoint((Endpoint)this.endpoint);
            RequestHandler requestHandler = this.endpoint.getRequestHandler();
            requestHandler.handleHttpRequest(this.endpoint, req, res, this.getServletContext());
        }
        finally {
            EndpointAssociation.removeEndpoint();
        }
    }

    protected void postInit(ServletConfig cfg) {
    }

    private void initAspectManager() {
        String managerName = (String)this.endpoint.getService().getDeployment().getProperty(PROPERTY_NAME);
        if (managerName == null) {
            this.backwardCompatibilityMode = true;
        }
        if (!this.backwardCompatibilityMode) {
            DeploymentAspectManagerLocator locator = (DeploymentAspectManagerLocator)this.spiProvider.getSPI(DeploymentAspectManagerLocator.class);
            this.aspectsManager = locator.locateDeploymentAspectManager(managerName);
        }
    }

    private void startAspectManager() {
        if (!this.backwardCompatibilityMode) {
            this.assertCorrectState();
            Deployment dep = this.endpoint.getService().getDeployment();
            if (this.endpoint.getState() != Endpoint.EndpointState.STARTED) {
                this.aspectsManager.create(dep, null);
                this.aspectsManager.start(dep, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAspectManager() {
        if (!this.backwardCompatibilityMode) {
            this.assertCorrectState();
            Deployment dep = this.endpoint.getService().getDeployment();
            if (this.endpoint.getState() == Endpoint.EndpointState.STARTED) {
                try {
                    this.aspectsManager.stop(dep, null);
                    this.aspectsManager.destroy(dep, null);
                }
                finally {
                    this.aspectsManager = null;
                }
            }
        }
    }

    private void startEndpoint() {
        if (!this.backwardCompatibilityMode) {
            Deployment dep = this.endpoint.getService().getDeployment();
            for (Endpoint ep : dep.getService().getEndpoints()) {
                ep.getLifecycleHandler().start(ep);
            }
        }
    }

    private void stopEndpoint() {
        if (!this.backwardCompatibilityMode && this.endpoint.getState() == Endpoint.EndpointState.STARTED) {
            Deployment dep = this.endpoint.getService().getDeployment();
            for (Endpoint ep : dep.getService().getEndpoints()) {
                ep.getLifecycleHandler().stop(ep);
            }
        }
    }

    protected abstract EndpointResolver newEndpointResolver(String var1, String var2);

    private void initServiceEndpoint(ServletConfig servletConfig) {
        this.initEndpoint(servletConfig.getServletContext().getContextPath(), this.getServletName());
        this.initAspectManager();
        this.setRuntimeLoader();
        this.startAspectManager();
        this.postInit(servletConfig);
        this.startEndpoint();
    }

    private void initRegistry() {
        this.epRegistry = ((EndpointRegistryFactory)this.spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
    }

    private void initEndpoint(String contextPath, String servletName) {
        EndpointResolver resolver = this.newEndpointResolver(contextPath, servletName);
        this.endpoint = this.epRegistry.resolve(resolver);
        if (this.endpoint == null) {
            ObjectName oname = ObjectNameFactory.create("jboss.ws:context=" + contextPath + "," + "endpoint" + "=" + servletName);
            throw new WebServiceException("Cannot obtain endpoint for: " + oname);
        }
    }

    private void setRuntimeLoader() {
        boolean isJaxwsJse;
        Deployment dep = this.endpoint.getService().getDeployment();
        boolean isJaxrpcJse = dep.getType() == Deployment.DeploymentType.JAXRPC_JSE;
        boolean bl = isJaxwsJse = dep.getType() == Deployment.DeploymentType.JAXWS_JSE;
        if (isJaxrpcJse || isJaxwsJse) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            dep.setRuntimeClassLoader(classLoader);
        }
    }

    private void assertCorrectState() {
        if (this.endpoint == null || this.aspectsManager == null) {
            throw new IllegalStateException();
        }
    }
}

