/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import org.jruby.compiler.ir.IRClass;
import org.jruby.compiler.ir.operands.Constant;
import org.jruby.compiler.ir.operands.Fixnum;
import org.jruby.compiler.ir.operands.Nil;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.interpreter.InterpreterContext;

public class Float
extends Constant {
    public final Double value;

    public Float(Double val) {
        this.value = val;
    }

    public String toString() {
        return this.value + ":float";
    }

    public Operand fetchCompileTimeArrayElement(int argIndex, boolean getSubArray) {
        return argIndex == 0 ? this : Nil.NIL;
    }

    public IRClass getTargetClass() {
        return IRClass.getCoreClass("Float");
    }

    public Constant computeValue(String methodName, Constant arg2) {
        Double v1 = this.value;
        Double v2 = arg2 instanceof Fixnum ? 1.0 * (double)((Fixnum)arg2).value.longValue() : ((Float)arg2).value;
        if (methodName.equals("+")) {
            return new Float(v1 + v2);
        }
        if (methodName.equals("-")) {
            return new Float(v1 - v2);
        }
        if (methodName.equals("*")) {
            return new Float(v1 * v2);
        }
        if (methodName.equals("/")) {
            return v2 == 0.0 ? null : new Float(v1 / v2);
        }
        return null;
    }

    public Object retrieve(InterpreterContext interp) {
        if (this.cachedValue == null) {
            this.cachedValue = interp.getRuntime().newFloat(this.value);
        }
        return this.cachedValue;
    }
}

