/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed;

import java.net.URL;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;

public class IsolatedScriptingContainer
extends ScriptingContainer {
    private static final String JRUBYDIR = "/.jrubydir";
    private static final String JRUBY_HOME = "/META-INF/jruby.home";
    private static final String JRUBY_HOME_DIR = "/META-INF/jruby.home/.jrubydir";

    public IsolatedScriptingContainer() {
        this(LocalContextScope.SINGLETON);
    }

    public IsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior) {
        this(scope, behavior, true);
    }

    public IsolatedScriptingContainer(LocalContextScope scope) {
        this(scope, LocalVariableBehavior.TRANSIENT);
    }

    public IsolatedScriptingContainer(LocalVariableBehavior behavior) {
        this(LocalContextScope.SINGLETON, behavior);
    }

    public IsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior, boolean lazy) {
        super(scope, behavior, lazy);
        boolean isContextClassLoader = true;
        URL home2 = Thread.currentThread().getContextClassLoader().getResource(JRUBY_HOME_DIR.substring(1));
        if (home2 == null) {
            isContextClassLoader = false;
            home2 = this.getClass().getClassLoader().getResource(JRUBY_HOME_DIR);
            if (home2 == null) {
                throw new RuntimeException("BUG can not find /META-INF/jruby.home/.jrubydir");
            }
            this.setClassLoader(this.getClass().getClassLoader());
            this.setHomeDirectory("uri:" + home2.toString().replaceFirst("/.jrubydir$", ""));
        } else {
            this.setHomeDirectory("uri:classloader:/META-INF/jruby.home");
        }
        this.runScriptlet("$LOAD_PATH.delete_if{|p| p =~ /jar$/ };$LOAD_PATH.each{|p| p.sub!( /:\\/([^\\/])/,'://\\1' )}");
        if (isContextClassLoader) {
            this.runScriptlet("Gem::Specification.reset;Gem::Specification.add_dir 'uri:classloader:/META-INF/jruby.home/lib/ruby/gems/shared';Gem::Specification.add_dir 'uri:classloader:/';$LOAD_PATH << 'uri:classloader:/'; $LOAD_PATH.inspect");
        } else {
            this.runScriptlet("Gem::Specification.reset;Gem::Specification.add_dir '" + this.getHomeDirectory() + "/lib/ruby/gems/shared'");
            this.addLoadPath(this.getClassLoader(), JRUBY_HOME_DIR);
            this.addGemPath(this.getClassLoader(), JRUBY_HOME_DIR);
        }
    }

    public void addLoadPath(ClassLoader cl) {
        this.addLoadPath(cl, JRUBYDIR);
    }

    public void addLoadPath(ClassLoader cl, String ref) {
        URL url = cl.getResource(ref);
        if (url == null && ref.startsWith("/")) {
            url = cl.getResource(ref.substring(1));
        }
        if (url == null) {
            throw new RuntimeException("reference " + ref + " not found on classloader " + cl);
        }
        String uri = "uri:" + url.toString().replaceFirst(ref + "$", "");
        this.runScriptlet("$LOAD_PATH << '" + uri + "' unless $LOAD_PATH.member?( '" + uri + "' )");
    }

    public void addGemPath(ClassLoader cl) {
        this.addGemPath(cl, "/specifications/.jrubydir");
    }

    public void addGemPath(ClassLoader cl, String ref) {
        URL url = cl.getResource(ref);
        if (url == null && ref.startsWith("/")) {
            url = cl.getResource(ref.substring(1));
        }
        if (url == null) {
            throw new RuntimeException("reference " + ref + " not found on classloader " + cl);
        }
        String uri = "uri:" + url.toString().replaceFirst(ref + "$", "");
        this.runScriptlet("Gem::Specification.add_dir '" + uri + "' unless Gem::Specification.dirs.member?( '" + uri + "' )");
    }
}

