/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.Arrays;
import java.util.List;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class ListNode
extends Node {
    private static final Node[] EMPTY = new Node[0];
    private static final int INITIAL_SIZE = 4;
    private Node[] list;
    private int size = 0;

    public ListNode(ISourcePosition position, Node firstNode) {
        super(position, firstNode != null && firstNode.containsVariableAssignment);
        this.list = new Node[4];
        this.addInternal(firstNode);
    }

    public ListNode(ISourcePosition position) {
        super(position, false);
        this.list = EMPTY;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LISTNODE;
    }

    protected void growList(int mustBeDelta) {
        int newSize = this.list.length * 2;
        if (this.size + mustBeDelta >= newSize) {
            newSize = (int)((double)(this.size + mustBeDelta) * 1.5);
        }
        Node[] newList = new Node[newSize];
        System.arraycopy(this.list, 0, newList, 0, this.size);
        this.list = newList;
    }

    protected void addInternal(Node node) {
        if (this.size >= this.list.length) {
            this.growList(1);
        }
        this.list[this.size++] = node;
    }

    protected void addAllInternal(ListNode other) {
        if (this.size + other.size() >= this.list.length) {
            this.growList(other.size);
        }
        System.arraycopy(other.list, 0, this.list, this.size, other.size);
        this.size += other.size;
    }

    public ListNode add(Node node) {
        if (node == null || node == NilImplicitNode.NIL) {
            this.addInternal(NilImplicitNode.NIL);
            return this;
        }
        if (node.containsVariableAssignment()) {
            this.containsVariableAssignment = true;
        }
        this.addInternal(node);
        if (this.getPosition() == null) {
            this.setPosition(node.getPosition());
        }
        return this;
    }

    public int size() {
        return this.size;
    }

    public ListNode addAll(ListNode other) {
        if (other != null && other.size() > 0) {
            if (other.containsVariableAssignment()) {
                this.containsVariableAssignment = true;
            }
            this.addAllInternal(other);
            if (this.getPosition() == null) {
                this.setPosition(other.getPosition());
            }
        }
        return this;
    }

    public ListNode addAll(Node other) {
        return this.add(other);
    }

    public Node getLast() {
        return this.size == 0 ? null : this.list[this.size - 1];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Node[] children() {
        Node[] properList = new Node[this.size];
        System.arraycopy(this.list, 0, properList, 0, this.size);
        return properList;
    }

    @Override
    @Deprecated
    public List<Node> childNodes() {
        return Arrays.asList(this.children());
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitListNode(this);
    }

    public Node get(int idx) {
        return this.list[idx];
    }
}

