/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.util.ByteList;

public class SymbolNode
extends Node
implements ILiteralNode,
INameNode {
    private String name;
    private Encoding encoding;

    public SymbolNode(ISourcePosition position, ByteList value2) {
        super(position, false);
        this.name = value2.toString().intern();
        this.encoding = value2.lengthEnc() == value2.length() ? USASCIIEncoding.INSTANCE : value2.getEncoding();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SYMBOLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitSymbolNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }
}

