/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.common;

import java.util.EnumSet;
import java.util.Set;
import org.joni.WarnCallback;
import org.jruby.Ruby;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyWarnings
implements IRubyWarnings,
WarnCallback {
    private final Ruby runtime;
    private final Set<IRubyWarnings.ID> oncelers = EnumSet.allOf(IRubyWarnings.ID.class);

    public RubyWarnings(Ruby runtime) {
        this.runtime = runtime;
    }

    public void warn(String message2) {
        this.warn(IRubyWarnings.ID.MISCELLANEOUS, message2);
    }

    @Override
    public Ruby getRuntime() {
        return this.runtime;
    }

    @Override
    public boolean isVerbose() {
        return this.runtime.isVerbose();
    }

    @Override
    public void warn(IRubyWarnings.ID id2, ISourcePosition position, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        this.warn(id2, position.getFile(), position.getLine() + 1, message2);
    }

    @Override
    public void warn(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        buffer.append(fileName).append(':').append(lineNumber).append(": ");
        buffer.append("warning: ").append(message2).append('\n');
        IRubyObject errorStream = this.runtime.getGlobalVariables().get("$stderr");
        errorStream.callMethod(this.runtime.getCurrentContext(), "write", this.runtime.newString(buffer.toString()));
    }

    @Override
    public void warn(IRubyWarnings.ID id2, String fileName, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        buffer.append(fileName).append(' ');
        buffer.append("warning: ").append(message2).append('\n');
        IRubyObject errorStream = this.runtime.getGlobalVariables().get("$stderr");
        errorStream.callMethod(this.runtime.getCurrentContext(), "write", this.runtime.newString(buffer.toString()));
    }

    @Override
    public void warn(IRubyWarnings.ID id2, String message2) {
        int line;
        String file2;
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        RubyStackTraceElement[] stack = RubyWarnings.getRubyStackTrace(this.runtime);
        if (stack.length == 0) {
            file2 = "(unknown)";
            line = -1;
        } else {
            file2 = stack[0].getFileName();
            line = stack[0].getLineNumber();
        }
        this.warn(id2, file2, line, message2);
    }

    public void warnOnce(IRubyWarnings.ID id2, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        if (this.oncelers.contains((Object)id2)) {
            return;
        }
        this.oncelers.add(id2);
        this.warn(id2, message2);
    }

    public void warning(String message2) {
        if (!this.isVerbose()) {
            return;
        }
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        this.warning(IRubyWarnings.ID.MISCELLANEOUS, message2);
    }

    @Override
    public void warning(IRubyWarnings.ID id2, String message2) {
        int line;
        String file2;
        if (!this.runtime.warningsEnabled() || !this.runtime.isVerbose()) {
            return;
        }
        RubyStackTraceElement[] stack = RubyWarnings.getRubyStackTrace(this.runtime);
        if (stack.length == 0) {
            file2 = "(unknown)";
            line = -1;
        } else {
            file2 = stack[0].getFileName();
            line = stack[0].getLineNumber();
        }
        this.warning(id2, file2, line, message2);
    }

    @Override
    public void warning(IRubyWarnings.ID id2, ISourcePosition position, String message2) {
        this.warning(id2, position.getFile(), position.getLine() + 1, message2);
    }

    @Override
    public void warning(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2) {
        if (!this.runtime.warningsEnabled() || !this.runtime.isVerbose()) {
            return;
        }
        this.warn(id2, fileName, lineNumber, message2);
    }

    private static RubyStackTraceElement[] getRubyStackTrace(Ruby runtime) {
        ThreadContext context = runtime.getCurrentContext();
        RubyStackTraceElement[] stack = context.createWarningBacktrace(runtime);
        return stack;
    }
}

