/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jruby.ast.MethodDefNode;
import org.jruby.ir.IRBuilder;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.parser.StaticScope;

public class IRMethod
extends IRScope {
    public final boolean isInstanceMethod;
    private Map<Integer, MethodType> signatures;
    private String jittedName;
    private MethodDefNode defn;

    public IRMethod(IRManager manager, IRScope lexicalParent, MethodDefNode defn, String name2, boolean isInstanceMethod, int lineNumber, StaticScope staticScope) {
        super(manager, lexicalParent, name2, lexicalParent.getFileName(), lineNumber, staticScope);
        this.defn = defn;
        this.isInstanceMethod = isInstanceMethod;
        this.signatures = null;
        if (!this.getManager().isDryRun() && staticScope != null) {
            staticScope.setIRScope(this);
        }
    }

    @Override
    public boolean hasBeenBuilt() {
        return this.defn == null;
    }

    public synchronized InterpreterContext lazilyAcquireInterpreterContext() {
        if (!this.hasBeenBuilt()) {
            IRBuilder.topIRBuilder(this.getManager(), this).defineMethodInner(this.defn, this.getLexicalParent());
            this.defn = null;
        }
        return this.interpreterContext;
    }

    @Override
    public synchronized BasicBlock[] prepareForInitialCompilation() {
        if (!this.hasBeenBuilt()) {
            this.lazilyAcquireInterpreterContext();
        }
        return super.prepareForInitialCompilation();
    }

    @Override
    public IRScopeType getScopeType() {
        return this.isInstanceMethod ? IRScopeType.INSTANCE_METHOD : IRScopeType.CLASS_METHOD;
    }

    @Override
    protected LocalVariable findExistingLocalVariable(String name2, int scopeDepth) {
        assert (scopeDepth == 0) : "Local variable depth in IRMethod should always be zero (" + name2 + " had depth of " + scopeDepth + ")";
        return (LocalVariable)this.localVars.get(name2);
    }

    @Override
    public LocalVariable getLocalVariable(String name2, int scopeDepth) {
        LocalVariable lvar = this.findExistingLocalVariable(name2, scopeDepth);
        if (lvar == null) {
            lvar = this.getNewLocalVariable(name2, scopeDepth);
        }
        return lvar;
    }

    public void addNativeSignature(int arity2, MethodType signature) {
        if (this.signatures == null) {
            this.signatures = new HashMap<Integer, MethodType>();
        }
        this.signatures.put(arity2, signature);
    }

    public Map<Integer, MethodType> getNativeSignatures() {
        return Collections.unmodifiableMap(this.signatures);
    }

    public String getJittedName() {
        return this.jittedName;
    }

    public void setJittedName(String jittedName) {
        this.jittedName = jittedName;
    }
}

