/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.dirgra.Edge;
import org.jruby.ir.IRClosure;
import org.jruby.ir.Operation;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.dataflow.analyses.LiveVariableNode;
import org.jruby.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.ir.dataflow.analyses.UnboxableOpsAnalysisProblem;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandBranchInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.boxing.AluInstr;
import org.jruby.ir.instructions.boxing.BoxBooleanInstr;
import org.jruby.ir.instructions.boxing.BoxFixnumInstr;
import org.jruby.ir.instructions.boxing.BoxFloatInstr;
import org.jruby.ir.instructions.boxing.UnboxBooleanInstr;
import org.jruby.ir.instructions.boxing.UnboxFixnumInstr;
import org.jruby.ir.instructions.boxing.UnboxFloatInstr;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.operands.UnboxedBoolean;
import org.jruby.ir.operands.UnboxedFixnum;
import org.jruby.ir.operands.UnboxedFloat;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;

public class UnboxableOpsAnalysisNode
extends FlowGraphNode<UnboxableOpsAnalysisProblem, UnboxableOpsAnalysisNode> {
    UnboxState inState;
    UnboxState outState;
    UnboxState tmpState;

    public UnboxableOpsAnalysisNode(UnboxableOpsAnalysisProblem prob, BasicBlock n) {
        super(prob, n);
    }

    @Override
    public void init() {
        this.outState = new UnboxState();
    }

    @Override
    public void buildDataFlowVars(Instr i2) {
    }

    @Override
    public void applyPreMeetHandler() {
        if (((UnboxableOpsAnalysisProblem)this.problem).getScope() instanceof IRClosure && this.basicBlock.isEntryBB()) {
            if (this.inState == null) {
                this.inState = new UnboxState();
            }
        } else {
            this.inState = new UnboxState();
        }
    }

    @Override
    public void compute_MEET(Edge e, UnboxableOpsAnalysisNode pred2) {
        if (!pred2.basicBlock.isRescueEntry()) {
            this.inState.computeMEET(pred2.outState);
        }
    }

    private Class getOperandType(UnboxState state2, Operand o) {
        if (o instanceof Float) {
            return Float.class;
        }
        if (o instanceof Fixnum) {
            return Fixnum.class;
        }
        if (o instanceof Bignum) {
            return Bignum.class;
        }
        if (o instanceof Boolean) {
            return Boolean.class;
        }
        if (o instanceof Variable) {
            return state2.types.get((Variable)o);
        }
        return null;
    }

    private void setOperandType(UnboxState state2, Variable v, Class newType) {
        if (v != null && newType != null) {
            state2.types.put(v, newType);
        }
    }

    private void markLocalVariables(Collection<Variable> varsToBox, Set<Variable> varsToCheck) {
        for (Variable v : varsToCheck) {
            if (!(v instanceof LocalVariable)) continue;
            varsToBox.add(v);
        }
    }

    private void updateUnboxedVarsInfo(Instr i2, UnboxState state2, Variable dst, boolean hasRescuer, boolean isDFBarrier) {
        Operation op;
        boolean isBranch;
        HashSet<Variable> varsToBox = new HashSet<Variable>();
        if (i2.canRaiseException()) {
            if (hasRescuer) {
                state2.unboxedDirtyVars.clear();
            } else if (((UnboxableOpsAnalysisProblem)this.problem).getScope() instanceof IRClosure) {
                this.markLocalVariables(varsToBox, state2.unboxedDirtyVars);
                state2.unboxedDirtyVars.removeAll(varsToBox);
            }
        }
        if (isDFBarrier) {
            this.markLocalVariables(varsToBox, state2.unboxedDirtyVars);
            state2.unboxedDirtyVars.removeAll(varsToBox);
            ArrayList<Variable> lvs = new ArrayList<Variable>();
            this.markLocalVariables(lvs, state2.unboxedVars.keySet());
            state2.unboxedVars.keySet().removeAll(lvs);
        }
        boolean bl = isBranch = (op = i2.getOperation()) == Operation.B_TRUE || op == Operation.B_FALSE;
        if (!isBranch) {
            state2.unboxedDirtyVars.removeAll(i2.getUsedVariables());
        }
        if (dst != null) {
            state2.unboxedVars.remove(dst);
            state2.unboxedDirtyVars.remove(dst);
        }
    }

    @Override
    public void initSolution() {
        this.tmpState = new UnboxState(this.inState);
    }

    @Override
    public void applyTransferFunction(Instr i2) {
        Variable dst = null;
        Class dstType = Object.class;
        boolean unboxedAndDirty = false;
        boolean hitDFBarrier = false;
        if (i2 instanceof ResultInstr) {
            dst = ((ResultInstr)((Object)i2)).getResult();
        }
        if (i2 instanceof CopyInstr) {
            Class srcType;
            Operand src = ((CopyInstr)i2).getSource();
            dstType = srcType = this.getOperandType(this.tmpState, src);
            if (srcType == Float.class || srcType == Fixnum.class) {
                unboxedAndDirty = true;
            }
            this.tmpState.unboxedVars.put(dst, dstType);
        } else if (i2 instanceof ClosureAcceptingInstr) {
            Operand o = ((ClosureAcceptingInstr)((Object)i2)).getClosureArg();
            if (i2 instanceof CallBase && o == null) {
                CallBase c = (CallBase)i2;
                String m = c.getName();
                Operand r = c.getReceiver();
                if (dst != null && c.getArgsCount() == 1 && ((UnboxableOpsAnalysisProblem)this.problem).isUnboxableMethod(m)) {
                    Class argType;
                    Operand a = c.getArg1();
                    Class receiverType = this.getOperandType(this.tmpState, r);
                    if (((UnboxableOpsAnalysisProblem)this.problem).acceptsArgTypes(m, receiverType, argType = this.getOperandType(this.tmpState, a))) {
                        Class unboxedType = ((UnboxableOpsAnalysisProblem)this.problem).getUnboxedType(m, receiverType, argType);
                        unboxedAndDirty = true;
                        dstType = ((UnboxableOpsAnalysisProblem)this.problem).getUnboxedResultType(m, unboxedType);
                        this.tmpState.unboxedVars.put(dst, dstType);
                        if (r instanceof Variable) {
                            this.tmpState.unboxedVars.put((Variable)r, unboxedType);
                        }
                        if (a instanceof Variable) {
                            this.tmpState.unboxedVars.put((Variable)a, unboxedType);
                        }
                    } else if (c.targetRequiresCallersBinding()) {
                        hitDFBarrier = true;
                    }
                }
            } else if (o instanceof WrappedIRClosure) {
                IRClosure cl = ((WrappedIRClosure)o).getClosure();
                UnboxableOpsAnalysisProblem subProblem = cl.getUnboxableOpsAnalysisProblem();
                if (subProblem == null) {
                    subProblem = new UnboxableOpsAnalysisProblem();
                    subProblem.setup(cl);
                    cl.putUnboxableOpsAnalysisProblem(subProblem);
                }
                UnboxableOpsAnalysisNode exitNode = (UnboxableOpsAnalysisNode)subProblem.getExitNode();
                UnboxableOpsAnalysisNode entryNode = (UnboxableOpsAnalysisNode)subProblem.getEntryNode();
                entryNode.inState = new UnboxState();
                for (Variable v : this.tmpState.types.keySet()) {
                    if (!(v instanceof LocalVariable)) continue;
                    entryNode.inState.types.put(v, this.tmpState.types.get(v));
                }
                entryNode.inState.computeMEET(exitNode.outState);
                subProblem.compute_MOP_Solution();
                this.tmpState.computeMEETForTypes(exitNode.outState, true);
                hitDFBarrier = true;
            } else {
                hitDFBarrier = true;
            }
        }
        this.setOperandType(this.tmpState, dst, dstType);
        if (unboxedAndDirty) {
            this.tmpState.unboxedDirtyVars.add(dst);
        } else {
            this.updateUnboxedVarsInfo(i2, this.tmpState, dst, this.hasExceptionsRescued(), hitDFBarrier);
        }
    }

    @Override
    public boolean solutionChanged() {
        return !this.tmpState.equals(this.outState);
    }

    @Override
    public void finalizeSolution() {
        this.outState = this.tmpState;
    }

    private boolean matchingTypes(Class c, TemporaryVariableType t) {
        switch (t) {
            case FLOAT: {
                return c == Float.class;
            }
            case FIXNUM: {
                return c == Fixnum.class;
            }
            case BOOLEAN: {
                return c == Boolean.class;
            }
        }
        return c != Float.class && c != Boolean.class && c != Fixnum.class;
    }

    private TemporaryLocalVariable getUnboxedVar(Class reqdType, Map<Variable, TemporaryLocalVariable> unboxMap, Variable v, boolean createNew) {
        TemporaryLocalVariable unboxedVar = unboxMap.get(v);
        if (unboxedVar == null && createNew || !this.matchingTypes(reqdType, unboxedVar.getType())) {
            unboxedVar = ((UnboxableOpsAnalysisProblem)this.problem).getScope().getNewUnboxedVariable(reqdType);
            unboxMap.put(v, unboxedVar);
        } else if (unboxedVar == null) {
            System.out.println("ERROR: No unboxed var for : " + v);
        }
        return unboxedVar;
    }

    private TemporaryLocalVariable getUnboxedVar(Class reqdType, Map<Variable, TemporaryLocalVariable> unboxMap, Variable v) {
        return this.getUnboxedVar(reqdType, unboxMap, v, true);
    }

    public void boxVar(UnboxState state2, Class reqdType, Map<Variable, TemporaryLocalVariable> unboxMap, Variable v, List<Instr> newInstrs) {
        TemporaryLocalVariable unboxedV = this.getUnboxedVar(reqdType, unboxMap, v);
        TemporaryVariableType vType = unboxedV.getType();
        if (vType == TemporaryVariableType.BOOLEAN) {
            newInstrs.add(new BoxBooleanInstr(v, unboxedV));
        } else if (vType == TemporaryVariableType.FLOAT) {
            newInstrs.add(new BoxFloatInstr(v, unboxedV));
        } else if (vType == TemporaryVariableType.FIXNUM) {
            newInstrs.add(new BoxFixnumInstr(v, unboxedV));
        }
        state2.unboxedDirtyVars.remove(v);
    }

    public void unboxVar(UnboxState state2, Class reqdType, Map<Variable, TemporaryLocalVariable> unboxMap, Variable v, List<Instr> newInstrs) {
        TemporaryLocalVariable unboxedV = this.getUnboxedVar(reqdType, unboxMap, v);
        if (reqdType == Boolean.class) {
            newInstrs.add(new UnboxBooleanInstr(unboxedV, v));
        } else if (reqdType == Float.class) {
            newInstrs.add(new UnboxFloatInstr(unboxedV, v));
        } else if (reqdType == Fixnum.class) {
            newInstrs.add(new UnboxFixnumInstr(unboxedV, v));
        }
        state2.unboxedVars.put(v, reqdType);
    }

    private Operand unboxOperand(UnboxState state2, Class reqdType, Map<Variable, TemporaryLocalVariable> unboxMap, Operand arg2, List<Instr> newInstrs) {
        if (arg2 instanceof Variable) {
            Variable v = (Variable)arg2;
            boolean isUnboxed = state2.unboxedVars.get(v) == reqdType;
            TemporaryLocalVariable unboxedVar = this.getUnboxedVar(reqdType, unboxMap, v);
            if (!isUnboxed) {
                this.unboxVar(state2, reqdType, unboxMap, v, newInstrs);
            }
            return unboxedVar;
        }
        if (arg2 instanceof Float) {
            return new UnboxedFloat(((Float)arg2).getValue());
        }
        if (arg2 instanceof Fixnum) {
            return new UnboxedFixnum(((Fixnum)arg2).getValue());
        }
        if (arg2 instanceof Boolean) {
            return new UnboxedBoolean(((Boolean)arg2).isTrue());
        }
        return arg2;
    }

    private Operand getUnboxedOperand(UnboxState state2, Map<Variable, TemporaryLocalVariable> unboxMap, Operand arg2) {
        if (arg2 instanceof Variable) {
            Variable v = (Variable)arg2;
            Class unboxedType = state2.unboxedVars.get(v);
            return unboxedType == null ? arg2 : this.getUnboxedVar(unboxedType, unboxMap, v);
        }
        if (arg2 instanceof Float) {
            return new UnboxedFloat(((Float)arg2).getValue());
        }
        if (arg2 instanceof Fixnum) {
            return new UnboxedFixnum(((Fixnum)arg2).getValue());
        }
        if (arg2 instanceof Boolean) {
            return new UnboxedBoolean(((Boolean)arg2).isTrue());
        }
        return arg2;
    }

    private void boxRequiredVars(Instr i2, UnboxState state2, Map<Variable, TemporaryLocalVariable> unboxMap, Variable dst, boolean hasRescuer, boolean isDFBarrier, List<Instr> newInstrs) {
        Operation op;
        boolean isBranch;
        boolean isClosure = ((UnboxableOpsAnalysisProblem)this.problem).getScope() instanceof IRClosure;
        HashSet<Variable> varsToBox = new HashSet<Variable>();
        if (i2.canRaiseException()) {
            if (hasRescuer) {
                varsToBox.addAll(state2.unboxedDirtyVars);
            } else if (isClosure) {
                this.markLocalVariables(varsToBox, state2.unboxedDirtyVars);
            }
        }
        if (isClosure && (i2 instanceof ReturnInstr || i2 instanceof BreakInstr)) {
            this.markLocalVariables(varsToBox, state2.unboxedDirtyVars);
        }
        ArrayList<Variable> boxedLocalVars = null;
        if (isDFBarrier) {
            this.markLocalVariables(varsToBox, state2.unboxedDirtyVars);
            boxedLocalVars = new ArrayList<Variable>();
            this.markLocalVariables(boxedLocalVars, state2.unboxedVars.keySet());
        }
        boolean bl = isBranch = (op = i2.getOperation()) == Operation.B_TRUE || op == Operation.B_FALSE;
        if (!isBranch) {
            for (Variable v : i2.getUsedVariables()) {
                if (!state2.unboxedDirtyVars.contains(v)) continue;
                varsToBox.add(v);
            }
        }
        for (Variable v : varsToBox) {
            this.boxVar(state2, state2.unboxedVars.get(v), unboxMap, v, newInstrs);
        }
        if (isBranch) {
            OneOperandBranchInstr bi = (OneOperandBranchInstr)i2;
            Operand a = bi.getArg1();
            Operand ua = this.getUnboxedOperand(state2, unboxMap, a);
            if (ua == a) {
                newInstrs.add(i2);
            } else if (op == Operation.B_TRUE) {
                newInstrs.add(new BTrueInstr(bi.getJumpTarget(), ua));
            } else {
                newInstrs.add(new BFalseInstr(bi.getJumpTarget(), ua));
            }
        } else {
            newInstrs.add(i2);
        }
        if (dst != null) {
            state2.unboxedVars.remove(dst);
            state2.unboxedDirtyVars.remove(dst);
        }
        if (boxedLocalVars != null) {
            state2.unboxedVars.keySet().removeAll(boxedLocalVars);
        }
    }

    public void unbox(Map<Variable, TemporaryLocalVariable> unboxMap) {
        CFG cfg = this.getCFG();
        HashMap<Variable, Class> succUnboxedVars = new HashMap<Variable, Class>();
        for (BasicBlock b2 : cfg.getOutgoingDestinations(this.basicBlock)) {
            if (b2.isExitBB()) continue;
            Map<Variable, Class> xVars = ((UnboxableOpsAnalysisNode)((UnboxableOpsAnalysisProblem)this.problem).getFlowGraphNode((BasicBlock)b2)).inState.unboxedVars;
            for (Variable v2 : xVars.keySet()) {
                succUnboxedVars.put(v2, xVars.get(v2));
            }
        }
        for (Variable v3 : this.outState.unboxedVars.keySet()) {
            succUnboxedVars.remove(v3);
        }
        LiveVariablesProblem lvp = ((UnboxableOpsAnalysisProblem)this.problem).getScope().getLiveVariablesProblem();
        BitSet liveVarsSet = ((LiveVariableNode)lvp.getFlowGraphNode(this.basicBlock)).getLiveInBitSet();
        ArrayList<Instr> newInstrs = new ArrayList<Instr>();
        boolean unboxedLiveVars = false;
        this.initSolution();
        for (Instr i2 : this.basicBlock.getInstrs()) {
            Variable dst = null;
            Class dstType = Object.class;
            boolean unboxedAndDirty = false;
            boolean hitDFBarrier = false;
            if (i2.getOperation().transfersControl()) {
                for (Variable v : succUnboxedVars.keySet()) {
                    if (!liveVarsSet.get(lvp.getDFVar(v))) continue;
                    this.unboxVar(this.tmpState, (Class)succUnboxedVars.get(v), unboxMap, v, newInstrs);
                }
                unboxedLiveVars = true;
            } else {
                if (i2 instanceof ResultInstr) {
                    dst = ((ResultInstr)((Object)i2)).getResult();
                }
                if (i2 instanceof CopyInstr) {
                    Class srcType;
                    Operand src = ((CopyInstr)i2).getSource();
                    dstType = srcType = this.getOperandType(this.tmpState, src);
                    if (srcType == Float.class || srcType == Fixnum.class) {
                        Operand unboxedSrc = src instanceof Variable ? this.getUnboxedVar(srcType, unboxMap, (Variable)src) : src;
                        TemporaryLocalVariable unboxedDst = this.getUnboxedVar(srcType, unboxMap, dst);
                        newInstrs.add(new CopyInstr(Operation.COPY, (Variable)unboxedDst, unboxedSrc));
                        unboxedAndDirty = true;
                    }
                    this.tmpState.unboxedVars.put(dst, dstType);
                } else if (i2 instanceof ClosureAcceptingInstr) {
                    Operand o = ((ClosureAcceptingInstr)((Object)i2)).getClosureArg();
                    if (i2 instanceof CallBase && o == null) {
                        CallBase c = (CallBase)i2;
                        String m = c.getName();
                        Operand r = c.getReceiver();
                        if (dst != null && c.getArgsCount() == 1 && ((UnboxableOpsAnalysisProblem)this.problem).isUnboxableMethod(m)) {
                            Operand a = c.getArg1();
                            Class receiverType = this.getOperandType(this.tmpState, r);
                            Class argType = this.getOperandType(this.tmpState, a);
                            Operation unboxedOp = null;
                            Class unboxedType = null;
                            if (((UnboxableOpsAnalysisProblem)this.problem).acceptsArgTypes(m, receiverType, argType)) {
                                unboxedType = ((UnboxableOpsAnalysisProblem)this.problem).getUnboxedType(m, receiverType, argType);
                                unboxedOp = ((UnboxableOpsAnalysisProblem)this.problem).getUnboxedOp(m, unboxedType);
                            }
                            if (unboxedType != null && unboxedOp != null) {
                                unboxedAndDirty = true;
                                dstType = ((UnboxableOpsAnalysisProblem)this.problem).getUnboxedResultType(m, unboxedType);
                                this.tmpState.unboxedVars.put(dst, dstType);
                                TemporaryLocalVariable unboxedDst = this.getUnboxedVar(dstType, unboxMap, dst);
                                r = this.unboxOperand(this.tmpState, unboxedType, unboxMap, r, newInstrs);
                                a = this.unboxOperand(this.tmpState, unboxedType, unboxMap, a, newInstrs);
                                newInstrs.add(new AluInstr(unboxedOp, unboxedDst, r, a));
                            } else if (c.targetRequiresCallersBinding()) {
                                hitDFBarrier = true;
                            }
                        }
                    } else if (o instanceof WrappedIRClosure) {
                        hitDFBarrier = true;
                        IRClosure cl = ((WrappedIRClosure)o).getClosure();
                        UnboxableOpsAnalysisProblem subProblem = cl.getUnboxableOpsAnalysisProblem();
                        UnboxableOpsAnalysisNode exitNode = (UnboxableOpsAnalysisNode)subProblem.getExitNode();
                        subProblem.unbox();
                        this.tmpState.computeMEETForTypes(exitNode.outState, true);
                        hitDFBarrier = true;
                    } else {
                        hitDFBarrier = true;
                    }
                }
            }
            this.setOperandType(this.tmpState, dst, dstType);
            if (unboxedAndDirty) {
                this.tmpState.unboxedDirtyVars.add(dst);
                continue;
            }
            this.boxRequiredVars(i2, this.tmpState, unboxMap, dst, this.hasExceptionsRescued(), hitDFBarrier, newInstrs);
        }
        if (!unboxedLiveVars) {
            for (Variable v : succUnboxedVars.keySet()) {
                if (!liveVarsSet.get(lvp.getDFVar(v))) continue;
                this.unboxVar(this.tmpState, (Class)succUnboxedVars.get(v), unboxMap, v, newInstrs);
            }
        }
        this.basicBlock.replaceInstrs(newInstrs);
    }

    public String toString() {
        return "";
    }

    private class UnboxState {
        Map<Variable, Class> types;
        Map<Variable, Class> unboxedVars;
        Set<Variable> unboxedDirtyVars;

        public UnboxState() {
            this.types = new HashMap<Variable, Class>();
            this.unboxedVars = new HashMap<Variable, Class>();
            this.unboxedDirtyVars = new HashSet<Variable>();
        }

        public UnboxState(UnboxState init) {
            this.types = new HashMap<Variable, Class>(init.types);
            this.unboxedVars = new HashMap<Variable, Class>(init.unboxedVars);
            this.unboxedDirtyVars = new HashSet<Variable>(init.unboxedDirtyVars);
        }

        public void computeMEETForTypes(UnboxState other, boolean localVarsOnly) {
            Map<Variable, Class> otherTypes = other.types;
            for (Variable v : otherTypes.keySet()) {
                if (localVarsOnly && !(v instanceof LocalVariable)) continue;
                Class c1 = this.types.get(v);
                Class c2 = otherTypes.get(v);
                if (c1 == null) {
                    this.types.put(v, c2);
                    continue;
                }
                if (c1 == c2) continue;
                this.types.put(v, Object.class);
            }
        }

        public void computeMEETForUnboxedVars(UnboxState other) {
            Map<Variable, Class> otherVars = other.unboxedVars;
            for (Variable v : otherVars.keySet()) {
                Class c1 = this.unboxedVars.get(v);
                Class c2 = otherVars.get(v);
                if (c1 == null) {
                    this.unboxedVars.put(v, c2);
                    continue;
                }
                if (c1 == c2) continue;
                this.unboxedVars.remove(v);
            }
        }

        public void computeMEET(UnboxState other) {
            this.computeMEETForTypes(other, false);
            this.computeMEETForUnboxedVars(other);
            this.unboxedDirtyVars.addAll(other.unboxedDirtyVars);
        }

        public boolean equals(UnboxState other) {
            return this.types.equals(other.types) && this.unboxedVars.equals(other.unboxedVars) && this.unboxedDirtyVars.equals(other.unboxedDirtyVars);
        }

        public void debugOut() {
            System.out.print("-- Known types:");
            for (Variable v : this.types.keySet()) {
                if (this.types.get(v) == Object.class) continue;
                System.out.println(v + "-->" + this.types.get(v));
            }
            System.out.print("-- Unboxed vars:");
            for (Variable v : this.unboxedVars.keySet()) {
                System.out.print(" " + v + "-->" + this.unboxedVars.get(v));
            }
            System.out.println("------");
            System.out.print("-- Unboxed dirty vars:");
            for (Variable v : this.unboxedDirtyVars) {
                System.out.print(" " + v);
            }
            System.out.println("------");
        }
    }
}

