/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.ListIterator;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.analyses.StoreLocalVarPlacementProblem;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.PopBindingInstr;
import org.jruby.ir.instructions.PopFrameInstr;
import org.jruby.ir.instructions.PushBindingInstr;
import org.jruby.ir.instructions.PushFrameInstr;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.LiveVariableAnalysis;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;

public class AddCallProtocolInstructions
extends CompilerPass {
    @Override
    public String getLabel() {
        return "Add Call Protocol Instructions (push/pop of dyn-scope, frame, impl-class values)";
    }

    private boolean explicitCallProtocolSupported(IRScope scope) {
        return scope instanceof IRMethod || scope instanceof IRModuleBody && !(scope instanceof IRMetaClassBody);
    }

    private void fixReturn(IRScope scope, ReturnBase i2, ListIterator<Instr> instrs) {
        Operand retVal = i2.getReturnValue();
        if (!(retVal instanceof ImmutableLiteral) && !(retVal instanceof TemporaryVariable)) {
            TemporaryLocalVariable tmp = scope.createTemporaryVariable();
            CopyInstr copy = new CopyInstr(tmp, retVal);
            i2.updateReturnValue(tmp);
            instrs.previous();
            instrs.add(copy);
            instrs.next();
        }
    }

    @Override
    public Object execute(IRScope scope, Object ... data2) {
        if (this.explicitCallProtocolSupported(scope)) {
            boolean requireBinding;
            StoreLocalVarPlacementProblem slvpp = scope.getStoreLocalVarPlacementProblem();
            boolean scopeHasLocalVarStores = false;
            boolean bindingHasEscaped = scope.bindingHasEscaped();
            CFG cfg = scope.getCFG();
            scopeHasLocalVarStores = slvpp != null && bindingHasEscaped ? slvpp.scopeHasLocalVarStores() : bindingHasEscaped;
            boolean requireFrame = this.doesItRequireFrame(scope, bindingHasEscaped);
            boolean bl = requireBinding = !scope.getFlags().contains((Object)IRFlags.DYNSCOPE_ELIMINATED);
            if (requireBinding || requireFrame) {
                BasicBlock geb;
                BasicBlock entryBB = cfg.getEntryBB();
                if (requireFrame) {
                    entryBB.addInstr(new PushFrameInstr(scope.getName()));
                }
                if (requireBinding) {
                    entryBB.addInstr(new PushBindingInstr());
                }
                if ((geb = cfg.getGlobalEnsureBB()) == null) {
                    TemporaryLocalVariable exc = scope.createTemporaryVariable();
                    geb = new BasicBlock(cfg, Label.getGlobalEnsureBlockLabel());
                    geb.addInstr(new ReceiveJRubyExceptionInstr(exc));
                    geb.addInstr(new ThrowExceptionInstr(exc));
                    cfg.addGlobalEnsureBB(geb);
                }
                for (BasicBlock bb : cfg.getBasicBlocks()) {
                    Instr i2 = null;
                    ListIterator<Instr> instrs = bb.getInstrs().listIterator();
                    while (instrs.hasNext()) {
                        i2 = instrs.next();
                        if (bb.isExitBB() || !(i2 instanceof ReturnBase)) continue;
                        if (requireBinding || requireFrame) {
                            this.fixReturn(scope, (ReturnBase)i2, instrs);
                        }
                        instrs.previous();
                        if (requireBinding) {
                            instrs.add(new PopBindingInstr());
                        }
                        if (!requireFrame) break;
                        instrs.add(new PopFrameInstr());
                        break;
                    }
                    if (bb.isExitBB() && !bb.isEmpty()) {
                        if (i2 != null && i2 instanceof ReturnBase) {
                            if (requireBinding || requireFrame) {
                                this.fixReturn(scope, (ReturnBase)i2, instrs);
                            }
                            instrs.previous();
                        }
                        if (requireBinding) {
                            instrs.add(new PopBindingInstr());
                        }
                        if (requireFrame) {
                            instrs.add(new PopFrameInstr());
                        }
                    }
                    if (bb != geb) continue;
                    if (i2 != null) {
                        assert (i2.getOperation().transfersControl()) : "Last instruction of GEB in scope: " + scope + " is " + i2 + ", not a control-xfer instruction";
                        instrs.previous();
                    }
                    if (requireBinding) {
                        instrs.add(new PopBindingInstr());
                    }
                    if (!requireFrame) continue;
                    instrs.add(new PopFrameInstr());
                }
            }
            scope.setExplicitCallProtocolFlag();
        }
        new LiveVariableAnalysis().invalidate(scope);
        return null;
    }

    private boolean doesItRequireFrame(IRScope scope, boolean bindingHasEscaped) {
        boolean requireFrame = bindingHasEscaped || scope.usesEval();
        for (IRFlags flag : scope.getFlags()) {
            switch (flag) {
                case BINDING_HAS_ESCAPED: 
                case CAN_CAPTURE_CALLERS_BINDING: 
                case REQUIRES_FRAME: 
                case REQUIRES_VISIBILITY: 
                case USES_BACKREF_OR_LASTLINE: 
                case USES_EVAL: 
                case USES_ZSUPER: {
                    requireFrame = true;
                }
            }
        }
        return requireFrame;
    }

    @Override
    public boolean invalidate(IRScope scope) {
        return false;
    }
}

