/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.EvalType;
import org.jruby.RubyArray;
import org.jruby.ir.IRScope;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class IRBlockBody
extends ContextAwareBlockBody {
    protected final String fileName;
    protected final int lineNumber;
    protected final IRScope closure;
    protected ThreadLocal<EvalType> evalType;

    public IRBlockBody(IRScope closure, Signature signature) {
        super(closure.getStaticScope(), signature);
        this.closure = closure;
        this.fileName = closure.getFileName();
        this.lineNumber = closure.getLineNumber();
        this.evalType = new ThreadLocal();
        this.evalType.set(EvalType.NONE);
    }

    @Override
    public void setEvalType(EvalType evalType) {
        this.evalType.set(evalType);
    }

    @Override
    public IRubyObject call(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.call(context, IRubyObject.NULL_ARRAY, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.call(context, new IRubyObject[]{arg0}, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.call(context, new IRubyObject[]{arg0, arg1}, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.call(context, new IRubyObject[]{arg0, arg1, arg2}, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        return this.call(context, args2, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        if (type2 == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        }
        return this.commonYieldPath(context, this.prepareArgumentsForCall(context, args2, type2), null, binding2, type2, block);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, Binding binding2, Block.Type type2) {
        IRubyObject[] args2 = IRubyObject.NULL_ARRAY;
        if (type2 == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        }
        return this.commonYieldPath(context, args2, null, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        if (arg0 instanceof RubyArray) {
            IRubyObject[] args2 = IRRuntimeHelpers.convertValueIntoArgArray(context, arg0, this.signature.arityValue(), true);
            if (type2 == Block.Type.LAMBDA) {
                this.signature.checkArity(context.runtime, args2);
            }
            return this.commonYieldPath(context, args2, null, binding2, type2, Block.NULL_BLOCK);
        }
        return this.yield(context, arg0, binding2, type2);
    }

    private IRubyObject yieldSpecificMultiArgsCommon(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        int blockArity = this.getSignature().arityValue();
        if (blockArity == 0) {
            args2 = IRubyObject.NULL_ARRAY;
        } else if (blockArity == 1) {
            args2 = new IRubyObject[]{RubyArray.newArrayNoCopy(context.runtime, args2)};
        }
        if (type2 == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        }
        return this.commonYieldPath(context, args2, null, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.yieldSpecificMultiArgsCommon(context, new IRubyObject[]{arg0, arg1}, binding2, type2);
    }

    @Override
    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.yieldSpecificMultiArgsCommon(context, new IRubyObject[]{arg0, arg1, arg2}, binding2, type2);
    }

    private IRubyObject[] toAry(ThreadContext context, IRubyObject value2) {
        IRubyObject val0 = Helpers.aryToAry(value2);
        if (!(val0 instanceof RubyArray)) {
            throw context.runtime.newTypeError(value2.getType().getName() + "#to_ary should return Array");
        }
        return ((RubyArray)val0).toJavaArray();
    }

    protected IRubyObject doYieldLambda(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        IRubyObject[] iRubyObjectArray;
        if (this.signature.required() == 1) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = value2;
        } else {
            iRubyObjectArray = this.toAry(context, value2);
        }
        IRubyObject[] args2 = iRubyObjectArray;
        this.signature.checkArity(context.runtime, args2);
        return this.commonYieldPath(context, args2, null, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject doYield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        if (type2 == Block.Type.LAMBDA) {
            return this.doYieldLambda(context, value2, binding2, type2);
        }
        int blockArity = this.getSignature().arityValue();
        IRubyObject[] args2 = blockArity >= -1 && blockArity <= 1 ? new IRubyObject[]{value2} : this.toAry(context, value2);
        return this.commonYieldPath(context, args2, null, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject doYield(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2) {
        if (type2 == Block.Type.LAMBDA) {
            this.signature.checkArity(context.runtime, args2);
        }
        return this.commonYieldPath(context, args2, self2, binding2, type2, Block.NULL_BLOCK);
    }

    protected IRubyObject useBindingSelf(Binding binding2) {
        IRubyObject self2 = binding2.getSelf();
        binding2.getFrame().setSelf(self2);
        return self2;
    }

    protected abstract IRubyObject commonYieldPath(ThreadContext var1, IRubyObject[] var2, IRubyObject var3, Binding var4, Block.Type var5, Block var6);

    @Override
    public String getFile() {
        return this.fileName;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }
}

