/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.util.StringPattern;

public class SimpleStringPattern
implements StringPattern {
    private static final char MATCH_EACH = '*';
    private static final char MATCH_ONE = '?';
    private final List subPatterns = new LinkedList();

    public SimpleStringPattern(String string) {
        this.splitInSubPattern(string);
    }

    public boolean doesMatch(String string) {
        int n = 0;
        SubPattern subPattern = null;
        Iterator iterator = this.subPatterns.iterator();
        while (iterator.hasNext()) {
            subPattern = (SubPattern)iterator.next();
            n = subPattern.doesMatch(string, n);
            if (n >= 0) continue;
            return false;
        }
        if (n == string.length()) {
            return true;
        }
        if (subPattern == null) {
            return false;
        }
        return subPattern.checkEnding(string, n);
    }

    private void splitInSubPattern(String string) {
        int n = 32;
        int n2 = 0;
        int n3 = 0;
        while (n3 >= 0) {
            String string2;
            n2 = n3;
            if ((n3 = string.indexOf(42, n2)) >= 0) {
                string2 = string.substring(n2, n3);
                this.addSubPattern(string2, (char)n);
                n = 42;
                ++n3;
                continue;
            }
            n3 = string.indexOf(63, n2);
            if (n3 < 0) continue;
            string2 = string.substring(n2, n3);
            this.addSubPattern(string2, (char)n);
            n = 63;
            ++n3;
        }
        String string3 = string.substring(n2);
        this.addSubPattern(string3, (char)n);
    }

    private void addSubPattern(String string, char c) {
        SubPattern subPattern = null;
        switch (c) {
            case '*': {
                subPattern = new MatchEachCharPattern(string);
                break;
            }
            case '?': {
                subPattern = new MatchOneCharPattern(string);
                break;
            }
            default: {
                subPattern = new MatchExactSubPattern(string);
            }
        }
        this.subPatterns.add(subPattern);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.subPatterns.iterator();
        while (iterator.hasNext()) {
            SubPattern subPattern = (SubPattern)iterator.next();
            stringBuffer.append(subPattern.toString());
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimpleStringPattern)) {
            return false;
        }
        return ((Object)this.subPatterns).equals(((SimpleStringPattern)object).subPatterns);
    }

    public int hashCode() {
        return -((Object)this.subPatterns).hashCode();
    }

    public static void main(String[] stringArray) {
        SimpleStringPattern simpleStringPattern = new SimpleStringPattern("a*b");
        SimpleStringPattern.test(simpleStringPattern, "ab", true);
        SimpleStringPattern.test(simpleStringPattern, "aab", true);
        SimpleStringPattern.test(simpleStringPattern, "ba", false);
        SimpleStringPattern.test(simpleStringPattern, "abc", false);
        simpleStringPattern = new SimpleStringPattern("*.txt");
        SimpleStringPattern.test(simpleStringPattern, "datei.txt", true);
        SimpleStringPattern.test(simpleStringPattern, ".txt", true);
        SimpleStringPattern.test(simpleStringPattern, "datei.tx", false);
        SimpleStringPattern.test(simpleStringPattern, "datei.txt.txt", true);
        simpleStringPattern = new SimpleStringPattern("datei*1*");
        SimpleStringPattern.test(simpleStringPattern, "datei0.txt", false);
        SimpleStringPattern.test(simpleStringPattern, "datei1.txt", true);
        SimpleStringPattern.test(simpleStringPattern, "datei.tx", false);
        SimpleStringPattern.test(simpleStringPattern, "datei1.txt.txt", true);
        simpleStringPattern = new SimpleStringPattern("Makefile");
        SimpleStringPattern.test(simpleStringPattern, "Makefile", true);
        SimpleStringPattern.test(simpleStringPattern, "Makefile.mak", false);
        SimpleStringPattern.test(simpleStringPattern, "Makefile1", false);
        SimpleStringPattern.test(simpleStringPattern, ".Makefile", false);
        SimpleStringPattern.test(simpleStringPattern, ".Makefile.", false);
        simpleStringPattern = new SimpleStringPattern("*~");
        SimpleStringPattern.test(simpleStringPattern, "datei~", true);
        SimpleStringPattern.test(simpleStringPattern, "datei~1", false);
        SimpleStringPattern.test(simpleStringPattern, "datei~1~", true);
        SimpleStringPattern simpleStringPattern2 = new SimpleStringPattern("*.class");
        SimpleStringPattern simpleStringPattern3 = new SimpleStringPattern("*.class");
        System.err.println(simpleStringPattern2 + ".equals(" + simpleStringPattern3 + ") = " + simpleStringPattern2.equals(simpleStringPattern3));
        simpleStringPattern2 = new SimpleStringPattern("?.class");
        simpleStringPattern3 = new SimpleStringPattern("*.class");
        System.err.println(simpleStringPattern2 + ".equals(" + simpleStringPattern3 + ") = " + simpleStringPattern2.equals(simpleStringPattern3));
        simpleStringPattern2 = new SimpleStringPattern("*.clazz");
        simpleStringPattern3 = new SimpleStringPattern("*.class");
        System.err.println(simpleStringPattern2 + ".equals(" + simpleStringPattern3 + ") = " + simpleStringPattern2.equals(simpleStringPattern3));
    }

    private static void test(StringPattern stringPattern, String string, boolean bl) {
        System.err.print('\"' + stringPattern.toString() + '\"' + ": " + string + " " + bl);
        boolean bl2 = stringPattern.doesMatch(string);
        if (bl2 == bl) {
            System.err.println(" proved");
        } else {
            System.err.println(" **denied**");
        }
    }

    private static class MatchOneCharPattern
    extends MatchExactSubPattern {
        public MatchOneCharPattern(String string) {
            super(string);
        }

        public int doesMatch(String string, int n) {
            if (string.length() < ++n) {
                return -1;
            }
            return super.doesMatch(string, n);
        }

        public String toString() {
            return '?' + this.match;
        }
    }

    private static class MatchEachCharPattern
    extends SubPattern {
        public MatchEachCharPattern(String string) {
            super(string);
        }

        public int doesMatch(String string, int n) {
            int n2 = string.indexOf(this.match, n);
            if (n2 < 0) {
                return -1;
            }
            return n2 + this.match.length();
        }

        public boolean checkEnding(String string, int n) {
            return string.endsWith(this.match);
        }

        public String toString() {
            return '*' + this.match;
        }
    }

    private static class MatchExactSubPattern
    extends SubPattern {
        public MatchExactSubPattern(String string) {
            super(string);
        }

        public int doesMatch(String string, int n) {
            if (!string.startsWith(this.match, n)) {
                return -1;
            }
            return n + this.match.length();
        }

        public String toString() {
            return this.match;
        }
    }

    private static abstract class SubPattern {
        protected final String match;

        protected SubPattern(String string) {
            this.match = string;
        }

        public abstract int doesMatch(String var1, int var2);

        public boolean checkEnding(String string, int n) {
            return false;
        }

        public boolean equals(Object object) {
            if (!this.getClass().isInstance(object)) {
                return false;
            }
            return this.match.equals(((SubPattern)object).match);
        }

        public int hashCode() {
            return -this.match.hashCode();
        }
    }
}

