/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.buffer.stax;

import com.sun.xml.stream.buffer.BaseBufferTestCase;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferProcessor;
import javax.xml.stream.XMLStreamReader;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.XMLStreamReaderEx;
import org.jvnet.staxex.XMLStreamWriterEx;

public class Base64Test
extends BaseBufferTestCase {
    byte[] bytes = new byte[]{0, 1, 2, 3};
    Base64Data data = new Base64Data();
    String base64EncodedString;

    public Base64Test() {
        this.data.set(this.bytes, null);
        this.base64EncodedString = this.data.toString();
    }

    MutableXMLStreamBuffer createBuffer() throws Exception {
        MutableXMLStreamBuffer buffer = new MutableXMLStreamBuffer();
        XMLStreamWriterEx writer = (XMLStreamWriterEx)buffer.createFromXMLStreamWriter();
        writer.writeStartDocument();
        writer.writeStartElement("foo");
        writer.writeBinary(this.bytes, 0, this.bytes.length, null);
        writer.writeEndElement();
        writer.writeEndDocument();
        Base64Test.assertTrue((boolean)buffer.isCreated());
        return buffer;
    }

    public void testReadingAsString() throws Exception {
        MutableXMLStreamBuffer buffer = this.createBuffer();
        StreamReaderBufferProcessor reader = buffer.readAsXMLStreamReader();
        Base64Test.assertEquals((int)7, (int)reader.getEventType());
        Base64Test.assertEquals((int)1, (int)reader.next());
        Base64Test.verifyTag((XMLStreamReader)((Object)reader), null, "foo");
        Base64Test.assertEquals((int)4, (int)reader.next());
        Base64Test.assertEquals((String)this.base64EncodedString, (String)reader.getText());
        Base64Test.assertEquals((int)2, (int)reader.next());
        Base64Test.verifyTag((XMLStreamReader)((Object)reader), null, "foo");
    }

    void readPCData(XMLStreamReaderEx reader) throws Exception {
        Base64Test.assertEquals((int)7, (int)reader.getEventType());
        Base64Test.assertEquals((int)1, (int)reader.next());
        Base64Test.verifyTag((XMLStreamReader)reader, null, "foo");
        Base64Test.assertEquals((int)4, (int)reader.next());
        CharSequence c = reader.getPCDATA();
        Base64Test.assertEquals((boolean)true, (boolean)(c instanceof Base64Data));
        Base64Data d = (Base64Data)c;
        byte[] b = d.getExact();
        Base64Test.assertEquals((int)this.bytes.length, (int)b.length);
        for (int i = 0; i < this.bytes.length; ++i) {
            Base64Test.assertEquals((byte)this.bytes[i], (byte)b[i]);
        }
        Base64Test.assertEquals((int)2, (int)reader.next());
        Base64Test.verifyTag((XMLStreamReader)reader, null, "foo");
    }

    public void testReadingAsPCDATA() throws Exception {
        MutableXMLStreamBuffer buffer = this.createBuffer();
        StreamReaderBufferProcessor reader = buffer.readAsXMLStreamReader();
        this.readPCData(reader);
    }

    public void testReadingAsPCDATAUsingCopyOfBuffer() throws Exception {
        MutableXMLStreamBuffer originalBuffer = this.createBuffer();
        StreamReaderBufferProcessor originalReader = originalBuffer.readAsXMLStreamReader();
        MutableXMLStreamBuffer buffer = new MutableXMLStreamBuffer();
        buffer.createFromXMLStreamReader((XMLStreamReader)((Object)originalReader));
        StreamReaderBufferProcessor reader = buffer.readAsXMLStreamReader();
        this.readPCData(reader);
    }
}

