/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.ssh.jce;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import net.adamcin.httpsig.ssh.jce.KeyFormat;
import net.adamcin.httpsig.ssh.jce.Magic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FingerprintGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FingerprintGenerator.class);
    public static final FingerprintGenerator NOP = new FingerprintGenerator(){

        @Override
        String getFingerprint(PublicKey publicKey) {
            return "";
        }
    };
    public static final FingerprintGenerator DSA = new FingerprintGenerator(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getFingerprint(PublicKey publicKey) {
            ByteArrayOutputStream byteOs = new ByteArrayOutputStream();
            try {
                if (!(publicKey instanceof DSAPublicKey)) {
                    throw new IllegalArgumentException("Not a DSA public key: " + publicKey);
                }
                Object dsaPublicKey = (DSAPublicKey)publicKey;
                DSAParams dsaParams = dsaPublicKey.getParams();
                DataOutputStream dos = new DataOutputStream(byteOs);
                dos.writeInt(KeyFormat.SSH_DSS.getIdentifier().getBytes().length);
                dos.write(KeyFormat.SSH_DSS.getIdentifier().getBytes());
                dos.writeInt(dsaParams.getP().toByteArray().length);
                dos.write(dsaParams.getP().toByteArray());
                dos.writeInt(dsaParams.getQ().toByteArray().length);
                dos.write(dsaParams.getQ().toByteArray());
                dos.writeInt(dsaParams.getG().toByteArray().length);
                dos.write(dsaParams.getG().toByteArray());
                dos.writeInt(dsaPublicKey.getY().toByteArray().length);
                dos.write(dsaPublicKey.getY().toByteArray());
                dsaPublicKey = Magic.getFingerprint(byteOs.toByteArray());
                return dsaPublicKey;
            }
            catch (IOException e) {
                LOGGER.error("[getFingerprint] failed to generate DSA fingerprint", (Throwable)e);
            }
            finally {
                try {
                    byteOs.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    };
    public static final FingerprintGenerator RSA = new FingerprintGenerator(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getFingerprint(PublicKey publicKey) {
            ByteArrayOutputStream byteOs = new ByteArrayOutputStream();
            try {
                if (!(publicKey instanceof RSAPublicKey)) {
                    throw new IllegalArgumentException("Not an RSA public key: " + publicKey);
                }
                Object rsaPublicKey = (RSAPublicKey)publicKey;
                DataOutputStream dos = new DataOutputStream(byteOs);
                dos.writeInt(KeyFormat.SSH_RSA.getIdentifier().getBytes().length);
                dos.write(KeyFormat.SSH_RSA.getIdentifier().getBytes());
                dos.writeInt(rsaPublicKey.getPublicExponent().toByteArray().length);
                dos.write(rsaPublicKey.getPublicExponent().toByteArray());
                dos.writeInt(rsaPublicKey.getModulus().toByteArray().length);
                dos.write(rsaPublicKey.getModulus().toByteArray());
                rsaPublicKey = Magic.getFingerprint(byteOs.toByteArray());
                return rsaPublicKey;
            }
            catch (IOException e) {
                LOGGER.error("[getFingerprint] failed to generate RSA fingerprint", (Throwable)e);
            }
            finally {
                try {
                    byteOs.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    };

    abstract String getFingerprint(PublicKey var1);
}

