/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.ssh.jce;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Magic {
    private static final char[] fingerPrintChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getFingerprint(byte[] keyBlob) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] foo = digest.digest(keyBlob);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < foo.length; ++i) {
                int bar = foo[i] & 0xFF;
                sb.append(fingerPrintChars[bar >>> 4 & 0xF]);
                sb.append(fingerPrintChars[bar & 0xF]);
                if (i + 1 >= foo.length) continue;
                sb.append(":");
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static byte[] extractSignatureFromDER(byte[] signatureBytes) {
        if (signatureBytes[0] == 0 && signatureBytes[1] == 0 && signatureBytes[2] == 0) {
            int i = 0;
            int j = signatureBytes[i++] << 24 & 0xFF000000 | signatureBytes[i++] << 16 & 0xFF0000 | signatureBytes[i++] << 8 & 0xFF00 | signatureBytes[i++] & 0xFF;
            i += j;
            j = signatureBytes[i++] << 24 & 0xFF000000 | signatureBytes[i++] << 16 & 0xFF0000 | signatureBytes[i++] << 8 & 0xFF00 | signatureBytes[i++] & 0xFF;
            byte[] tmp = new byte[j];
            System.arraycopy(signatureBytes, i, tmp, 0, j);
            signatureBytes = tmp;
        }
        return signatureBytes;
    }

    public static byte[] dssPadSignature(byte[] signatureBytes) {
        int len = 0;
        int index = 3;
        len = signatureBytes[index++] & 0xFF;
        byte[] r = new byte[len];
        System.arraycopy(signatureBytes, index, r, 0, r.length);
        index = index + len + 1;
        len = signatureBytes[index++] & 0xFF;
        byte[] s = new byte[len];
        System.arraycopy(signatureBytes, index, s, 0, s.length);
        byte[] result = new byte[40];
        System.arraycopy(r, r.length > 20 ? 1 : 0, result, r.length > 20 ? 0 : 20 - r.length, r.length > 20 ? 20 : r.length);
        System.arraycopy(s, s.length > 20 ? 1 : 0, result, s.length > 20 ? 20 : 40 - s.length, s.length > 20 ? 20 : s.length);
        return result;
    }

    public static byte[] dssUnpadSignature(byte[] signatureBytes) {
        int frst = (signatureBytes[0] & 0x80) != 0 ? 1 : 0;
        int scnd = (signatureBytes[20] & 0x80) != 0 ? 1 : 0;
        int length = signatureBytes.length + 6 + frst + scnd;
        byte[] result = new byte[length];
        result[0] = 48;
        result[1] = 44;
        result[1] = (byte)(result[1] + frst);
        result[1] = (byte)(result[1] + scnd);
        result[2] = 2;
        result[3] = 20;
        result[3] = (byte)(result[3] + frst);
        System.arraycopy(signatureBytes, 0, result, 4 + frst, 20);
        result[4 + result[3]] = 2;
        result[5 + result[3]] = 20;
        int n = 5 + result[3];
        result[n] = (byte)(result[n] + scnd);
        System.arraycopy(signatureBytes, 20, result, 6 + result[3] + scnd, 20);
        return result;
    }
}

