/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.ssh.jce;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import net.adamcin.httpsig.ssh.jce.Magic;

public final class SSHDSSSignature
extends Signature {
    private final Signature wrapped = Signature.getInstance("SHA1withDSA");

    public SSHDSSSignature() throws NoSuchAlgorithmException {
        super("ssh-dss");
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.wrapped.initVerify(publicKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.wrapped.initSign(privateKey);
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.wrapped.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.wrapped.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        return Magic.dssPadSignature(this.wrapped.sign());
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] extracted = Magic.extractSignatureFromDER(sigBytes);
        return this.wrapped.verify(Magic.dssUnpadSignature(extracted));
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        this.wrapped.setParameter(param, value);
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return this.wrapped.getParameter(param);
    }
}

