/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.ssh.jce;

import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.adamcin.httpsig.api.Algorithm;
import net.adamcin.httpsig.ssh.jce.FingerprintableKey;
import net.adamcin.httpsig.ssh.jce.KeyFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSHKey
implements FingerprintableKey {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSHKey.class);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final KeyFormat keyFormat;
    private final KeyPair keyPair;
    private final String fingerprint;

    public SSHKey(KeyFormat keyFormat, KeyPair keyPair) {
        if (keyFormat == null) {
            throw new IllegalArgumentException("keyFormat must not be null");
        }
        this.keyFormat = keyFormat;
        if (keyPair == null) {
            throw new IllegalArgumentException("keyFormat must not be null");
        }
        if (keyPair.getPublic() == null) {
            throw new IllegalArgumentException("publicKey must not be null");
        }
        this.keyPair = keyPair;
        this.fingerprint = keyFormat.getFingerprint(keyPair.getPublic());
    }

    public SSHKey(KeyFormat keyFormat, PublicKey publicKey, PrivateKey privateKey) {
        this(keyFormat, new KeyPair(publicKey, privateKey));
    }

    public String getId() {
        return this.fingerprint;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    public Set<Algorithm> getAlgorithms() {
        return Collections.unmodifiableSet(new LinkedHashSet<Algorithm>(this.keyFormat.getSignatureAlgorithms()));
    }

    public boolean canVerify() {
        return this.keyPair.getPublic() != null;
    }

    public boolean canSign() {
        return this.keyPair.getPrivate() != null;
    }

    public boolean verify(Algorithm algorithm, byte[] challengeHash, byte[] signatureBytes) {
        Signature signature;
        if (challengeHash == null) {
            throw new IllegalArgumentException("challengeHash cannot be null.");
        }
        if (signatureBytes == null) {
            throw new IllegalArgumentException("signatureBytes cannot be null.");
        }
        if (this.keyPair.getPublic() == null) {
            LOGGER.warn("[verify] this identity cannot be used for verification because it lacks a public key.");
        }
        if ((signature = this.keyFormat.getSignatureInstance(algorithm)) != null) {
            try {
                signature.initVerify(this.keyPair.getPublic());
                signature.update(challengeHash);
                return signature.verify(signatureBytes);
            }
            catch (SignatureException e) {
                LOGGER.error("[verify] failed to verify signature.", (Throwable)e);
            }
            catch (InvalidKeyException e) {
                LOGGER.error("[verify] failed to verify signature due to invalid public key.", (Throwable)e);
            }
        }
        return false;
    }

    public byte[] sign(Algorithm algorithm, byte[] challengeHash) {
        if (challengeHash == null) {
            throw new IllegalArgumentException("challengeHash cannot be null.");
        }
        if (this.keyPair.getPrivate() == null) {
            LOGGER.warn("[sign] this identity cannot be used for signing because it lacks a private key.");
            return null;
        }
        Signature signature = this.keyFormat.getSignatureInstance(algorithm);
        if (signature != null) {
            try {
                signature.initSign(this.keyPair.getPrivate());
                signature.update(challengeHash);
                return signature.sign();
            }
            catch (SignatureException e) {
                LOGGER.error("[sign] failed to sign challengeHash.", (Throwable)e);
            }
            catch (InvalidKeyException e) {
                LOGGER.error("[sign] failed to sign challengeHash due to invalid private key.", (Throwable)e);
            }
        }
        return EMPTY_BYTES;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSHKey that = (SSHKey)o;
        if (!this.fingerprint.equals(that.fingerprint)) {
            return false;
        }
        if (this.keyFormat != that.keyFormat) {
            return false;
        }
        if (this.keyPair.getPrivate() != null ? !this.keyPair.getPrivate().equals(that.keyPair.getPrivate()) : that.keyPair.getPrivate() != null) {
            return false;
        }
        return !(this.keyPair.getPublic() != null ? !this.keyPair.getPublic().equals(that.keyPair.getPublic()) : that.keyPair.getPublic() != null);
    }

    public int hashCode() {
        int result = this.fingerprint.hashCode();
        result = 31 * result + this.keyFormat.hashCode();
        result = 31 * result + (this.keyPair.getPublic() != null ? this.keyPair.getPublic().hashCode() : 0);
        result = 31 * result + (this.keyPair.getPrivate() != null ? this.keyPair.getPrivate().hashCode() : 0);
        return result;
    }
}

