/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import com.sun.tools.ws.WsGen;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.jaxws.AbstractJaxwsMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractWsGenMojo
extends AbstractJaxwsMojo {
    private boolean genWsdl;
    private File resourceDestDir;
    private String sei;
    private String protocol;
    private List<Artifact> pluginArtifacts;
    private File sourceDestDir;

    AbstractWsGenMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        String orginalSystemClasspath = this.initClassLoader(parent);
        try {
            ArrayList<String> args = this.getWsGenArgs();
            if (WsGen.doMain((String[])args.toArray(new String[args.size()])) != 0) {
                throw new MojoExecutionException("Error executing: wsgen " + args);
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Failed to execute wsgen", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(parent);
            System.setProperty("java.class.path", orginalSystemClasspath);
        }
    }

    private void init() throws MojoExecutionException, MojoFailureException {
        if (!this.getDestDir().exists()) {
            this.getDestDir().mkdirs();
        }
    }

    private ArrayList<String> getWsGenArgs() throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        if (this.verbose) {
            args.add("-verbose");
        }
        if (this.keep || this.sourceDestDir != null) {
            args.add("-keep");
        }
        if (this.sourceDestDir != null) {
            args.add("-s");
            args.add(this.sourceDestDir.getAbsolutePath());
            this.sourceDestDir.mkdirs();
        }
        args.add("-d");
        args.add(this.getDestDir().getAbsolutePath());
        args.add("-cp");
        StringBuilder buf = new StringBuilder();
        buf.append(this.getDestDir().getAbsolutePath());
        for (Artifact a : this.project.getArtifacts()) {
            buf.append(File.pathSeparatorChar);
            buf.append(a.getFile().getAbsolutePath());
        }
        for (Artifact a : this.pluginArtifacts) {
            buf.append(File.pathSeparatorChar);
            buf.append(a.getFile().getAbsolutePath());
        }
        args.add(buf.toString());
        if (this.genWsdl) {
            if (this.protocol != null) {
                args.add("-wsdl:" + this.protocol);
            } else {
                args.add("-wsdl");
            }
            args.add("-r");
            args.add(this.resourceDestDir.getAbsolutePath());
            this.resourceDestDir.mkdirs();
        }
        args.add(this.sei);
        this.getLog().debug((CharSequence)("jaxws:wsgen args: " + args));
        return args;
    }
}

