/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.appender;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public class RegexEventEvaluator
implements TriggeringEventEvaluator {
    private HashMap<String, Pattern> regexMap = new HashMap();

    public boolean isTriggeringEvent(LoggingEvent event) {
        String regex = (String)event.getMDC("RegexEventEvaluator");
        boolean isTriggeringEvent = false;
        if (regex != null) {
            String msg;
            Pattern re = this.regexMap.get(regex);
            if (re == null) {
                re = Pattern.compile(regex);
                this.regexMap.put(regex, re);
            }
            if (re != null && (msg = event.getRenderedMessage()) != null) {
                Matcher m = re.matcher(msg);
                isTriggeringEvent = m.matches();
            }
        }
        return isTriggeringEvent;
    }
}

