/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.log4j;

import java.util.EnumMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.logging.AbstractLoggerPluginInstance;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerPlugin;
import org.jboss.logging.LoggerPluginInstance;

public class Log4jLoggerPluginInstance
extends AbstractLoggerPluginInstance
implements LoggerPluginInstance {
    private Logger log;
    private static final Map<Logger.Level, Level> LEVELS;

    public Log4jLoggerPluginInstance(String name, String resourceBundleName, LoggerPlugin loggerPlugin) {
        super(name, resourceBundleName, loggerPlugin);
        this.log = LogManager.getLogger((String)name);
    }

    public Category getCategory() {
        return this.log;
    }

    public Logger getDelegateLogger() {
        return this.log;
    }

    public boolean isEnabled(Logger.Level level) {
        Level l = LEVELS.get(level);
        return this.log.isEnabledFor((Priority)l) && l.isGreaterOrEqual((Priority)this.log.getEffectiveLevel());
    }

    protected void log(Logger.Level level, String loggerFqcn, String message, Throwable t) {
        this.log.log(loggerFqcn, (Priority)LEVELS.get(level), (Object)message, t);
    }

    static {
        EnumMap<Logger.Level, Level> map = new EnumMap<Logger.Level, Level>(Logger.Level.class);
        map.put(Logger.Level.TRACE, Level.TRACE);
        map.put(Logger.Level.DEBUG, Level.DEBUG);
        map.put(Logger.Level.INFO, Level.INFO);
        map.put(Logger.Level.WARN, Level.WARN);
        map.put(Logger.Level.ERROR, Level.ERROR);
        map.put(Logger.Level.FATAL, Level.FATAL);
        LEVELS = map;
    }
}

