/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import pt.digitalis.utils.bytecode.ByteCodeStartupConfiguration;
import pt.digitalis.utils.bytecode.exceptions.CodeGenerationException;
import pt.digitalis.utils.bytecode.holders.AnnotationHolder;
import pt.digitalis.utils.bytecode.holders.AnnotationMemberValueHolder;
import pt.digitalis.utils.bytecode.holders.AttributeHolder;
import pt.digitalis.utils.bytecode.holders.ClassHolder;
import pt.digitalis.utils.bytecode.holders.MethodHolder;
import pt.digitalis.utils.inspection.exception.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenUtil4Javassist {
    public static CtMethod addCodeAfterMethodBody(String methodSourceToAdd, CtMethod method) throws CodeGenerationException {
        long initTime = System.currentTimeMillis();
        if (ByteCodeStartupConfiguration.isShowSource()) {
            System.out.println("Compiling source for method \"" + method.getName() + "\": \n     | " + methodSourceToAdd.replace("\n", "\n    | "));
        }
        try {
            method.insertAfter(methodSourceToAdd);
        }
        catch (CannotCompileException cannotCompileException) {
            throw new CodeGenerationException("Could not compile source code for method " + method.getName() + " ( Cause: " + cannotCompileException.getReason() + " Source code: " + methodSourceToAdd + ")", (Exception)((Object)cannotCompileException));
        }
        if (ByteCodeStartupConfiguration.isTrackTimes()) {
            System.out.println(method.getDeclaringClass().getSimpleName() + " - Added after Method: " + method.getName() + " (" + (System.currentTimeMillis() - initTime) + "ms)");
        }
        return method;
    }

    public static CtMethod addCodeBeforeMethodBody(String methodSourceToAdd, CtMethod method) throws CodeGenerationException {
        long initTime = System.currentTimeMillis();
        if (ByteCodeStartupConfiguration.isShowSource()) {
            System.out.println("Compiling source for method \"" + method.getName() + "\": \n     | " + methodSourceToAdd.replace("\n", "\n    | "));
        }
        try {
            method.insertBefore(methodSourceToAdd);
        }
        catch (CannotCompileException cannotCompileException) {
            throw new CodeGenerationException("Could not compile source code for method " + method.getName() + " ( Cause: " + cannotCompileException.getReason() + " Source code: " + methodSourceToAdd + ")", (Exception)((Object)cannotCompileException));
        }
        if (ByteCodeStartupConfiguration.isTrackTimes()) {
            System.out.println(method.getDeclaringClass().getSimpleName() + " - Added before Method: " + method.getName() + " (" + (System.currentTimeMillis() - initTime) + "ms)");
        }
        return method;
    }

    public static CtClass addInterface(CtClass interfaceClass, CtClass destinationClass) {
        if (destinationClass.isFrozen()) {
            destinationClass.defrost();
        }
        destinationClass.addInterface(interfaceClass);
        return destinationClass;
    }

    public static CtClass addMethodSourceToClass(String methodSource, CtClass clazz) throws CodeGenerationException {
        return CodeGenUtil4Javassist.addMethodSourceToClass(methodSource, clazz, false);
    }

    public static CtClass addMethodSourceToClass(String methodSource, CtClass clazz, boolean overrideExisting) throws CodeGenerationException {
        long initTime = System.currentTimeMillis();
        if (clazz.isFrozen()) {
            clazz.defrost();
        }
        CtMethod method = null;
        if (ByteCodeStartupConfiguration.isShowSource()) {
            System.out.println("Compiling new Method: \n     | " + methodSource.replace("\n", "\n    | "));
        }
        try {
            method = CtNewMethod.make((String)methodSource, (CtClass)clazz);
            if (overrideExisting || !CodeGenUtil4Javassist.methodExists(method.getName(), clazz)) {
                clazz.addMethod(method);
            }
        }
        catch (CannotCompileException cannotCompileException) {
            throw new CodeGenerationException("Could not compile source code for initialization method on class " + clazz.getName() + " (Source err?) [source = " + methodSource + "]", (Exception)((Object)cannotCompileException));
        }
        if (ByteCodeStartupConfiguration.isTrackTimes()) {
            System.out.println(clazz.getSimpleName() + " - Added Method: " + methodSource.substring(0, 50) + " (" + (System.currentTimeMillis() - initTime) + "ms)");
        }
        return clazz;
    }

    public static boolean attributeExists(String attributeName, CtClass clazz) {
        boolean result = false;
        CtField[] attributes = clazz.getDeclaredFields();
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(attributeName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static AnnotationMemberValue[] convertMemberValueToAnnotationArray(ArrayMemberValue arrayMemberValue) {
        return (AnnotationMemberValue[])arrayMemberValue.getValue();
    }

    public static Boolean convertMemberValueToBoolean(MemberValue memberValue) {
        return ((BooleanMemberValue)memberValue).getValue();
    }

    public static String convertMemberValueToString(MemberValue memberValue) {
        return ((StringMemberValue)memberValue).getValue();
    }

    public static String[] convertMemberValueToStringArray(ArrayMemberValue arrayMemberValue) {
        String[] entries = null;
        return entries;
    }

    private static MemberValue convertToMemberValue(Object originalValue) {
        Class<?> originalValueType = originalValue.getClass();
        if (originalValueType == Annotation.class) {
            AnnotationMemberValue convertedValue = new AnnotationMemberValue(new ConstPool("javassist.bytecode.AnnotationMemberValue"));
            convertedValue.setValue((Annotation)originalValue);
            return convertedValue;
        }
        if (originalValueType == Boolean.class) {
            BooleanMemberValue convertedValue = new BooleanMemberValue(new ConstPool("javassist.bytecode.BooleanMemberValue"));
            convertedValue.setValue(((Boolean)originalValue).booleanValue());
            return convertedValue;
        }
        if (originalValueType == Byte.class) {
            ByteMemberValue convertedValue = new ByteMemberValue(new ConstPool("javassist.bytecode.ByteMemberValue"));
            convertedValue.setValue(((Byte)originalValue).byteValue());
            return convertedValue;
        }
        if (originalValueType == Character.class) {
            CharMemberValue convertedValue = new CharMemberValue(new ConstPool("javassist.bytecode.CharMemberValue"));
            convertedValue.setValue(((Character)originalValue).charValue());
            return convertedValue;
        }
        if (originalValueType == Class.class) {
            ClassMemberValue convertedValue = new ClassMemberValue(new ConstPool("javassist.bytecode.ClassMemberValue"));
            convertedValue.setValue(((Class)originalValue).getCanonicalName());
            return convertedValue;
        }
        if (originalValueType == Double.class) {
            DoubleMemberValue convertedValue = new DoubleMemberValue(new ConstPool("javassist.bytecode.DoubleMemberValue"));
            convertedValue.setValue(((Double)originalValue).doubleValue());
            return convertedValue;
        }
        if (originalValueType == Enum.class) {
            EnumMemberValue convertedValue = new EnumMemberValue(new ConstPool("javassist.bytecode.EnumMemberValue"));
            convertedValue.setValue(((Enum)originalValue).name());
            return convertedValue;
        }
        if (originalValueType == Float.class) {
            FloatMemberValue convertedValue = new FloatMemberValue(new ConstPool("javassist.bytecode.FloatMemberValue"));
            convertedValue.setValue(((Float)originalValue).floatValue());
            return convertedValue;
        }
        if (originalValueType == Integer.class) {
            IntegerMemberValue convertedValue = new IntegerMemberValue(new ConstPool("javassist.bytecode.IntegerMemberValue"));
            convertedValue.setValue(((Integer)originalValue).intValue());
            return convertedValue;
        }
        if (originalValueType == Long.class) {
            LongMemberValue convertedValue = new LongMemberValue(new ConstPool("javassist.bytecode.LongMemberValue"));
            convertedValue.setValue(((Long)originalValue).longValue());
            return convertedValue;
        }
        if (originalValueType == Short.class) {
            ShortMemberValue convertedValue = new ShortMemberValue(new ConstPool("javassist.bytecode.ShortMemberValue"));
            convertedValue.setValue(((Short)originalValue).shortValue());
            return convertedValue;
        }
        if (originalValueType == String.class) {
            StringMemberValue convertedValue = new StringMemberValue(new ConstPool("javassist.bytecode.StringMemberValue"));
            convertedValue.setValue((String)originalValue);
            return convertedValue;
        }
        return null;
    }

    public static CtClass copyClassAttributes(CtClass sourceClass, CtClass destinationClass) throws CodeGenerationException {
        CtField[] sourceClassAttributes = sourceClass.getDeclaredFields();
        for (int i = 0; i < sourceClassAttributes.length; ++i) {
            if (CodeGenUtil4Javassist.attributeExists(sourceClassAttributes[i].getName(), destinationClass)) continue;
            try {
                CtField attributeByteCode = new CtField(sourceClassAttributes[i], destinationClass);
                destinationClass.addField(attributeByteCode);
                continue;
            }
            catch (CannotCompileException cannotCompileException) {
                throw new CodeGenerationException("Could not add attribute " + sourceClassAttributes[i].getName() + " to class " + destinationClass.getName() + "(" + cannotCompileException.getReason() + ")", (Exception)((Object)cannotCompileException));
            }
        }
        return destinationClass;
    }

    public static CtClass copyClassInterfaces(CtClass sourceClass, CtClass destinationClass) throws CodeGenerationException, ResourceNotFoundException {
        CtClass[] interfaces = null;
        try {
            interfaces = sourceClass.getInterfaces();
        }
        catch (NotFoundException notFoundException) {
            throw new ResourceNotFoundException("Could not get interfaces from template class " + sourceClass.getName() + " to copy!", (Exception)((Object)notFoundException));
        }
        for (int i = 0; i < interfaces.length; ++i) {
            CodeGenUtil4Javassist.addInterface(interfaces[i], destinationClass);
        }
        return destinationClass;
    }

    public static CtClass copyClassMethod(CtClass sourceClass, CtClass destinationClass, String methodName) throws CodeGenerationException {
        if (!CodeGenUtil4Javassist.methodExists(methodName, destinationClass)) {
            try {
                CtMethod methodToCopy = null;
                for (CtMethod ctMethod : sourceClass.getMethods()) {
                    if (!ctMethod.getName().equals(methodName)) continue;
                    methodToCopy = ctMethod;
                }
                if (methodToCopy == null) {
                    throw new CodeGenerationException("Could not add method " + methodName + " to class " + destinationClass.getName() + "()", null);
                }
                CtMethod methodByteCode = new CtMethod(methodToCopy, destinationClass, null);
                destinationClass.addMethod(methodByteCode);
            }
            catch (CannotCompileException cannotCompileException) {
                throw new CodeGenerationException("Could not add method " + methodName + " to class " + destinationClass.getName() + "(" + cannotCompileException.getReason() + ")", (Exception)((Object)cannotCompileException));
            }
        }
        return destinationClass;
    }

    public static CtClass copyClassMethod(CtClass sourceClass, CtClass destinationClass, String methodName, String methodSignature) throws CodeGenerationException {
        if (!CodeGenUtil4Javassist.methodExists(methodName, destinationClass)) {
            try {
                CtMethod methodByteCode = new CtMethod(sourceClass.getMethod(methodName, methodSignature), destinationClass, null);
                destinationClass.addMethod(methodByteCode);
            }
            catch (CannotCompileException cannotCompileException) {
                throw new CodeGenerationException("Could not add method " + methodName + " to class " + destinationClass.getName() + "(" + cannotCompileException.getReason() + ")", (Exception)((Object)cannotCompileException));
            }
            catch (NotFoundException notFoundException) {
                throw new CodeGenerationException("Could not add method " + methodName + " to class " + destinationClass.getName() + "(" + notFoundException.getMessage() + ")", (Exception)((Object)notFoundException));
            }
        }
        return destinationClass;
    }

    public static CtClass copyClassMethods(CtClass sourceClass, CtClass destinationClass) throws CodeGenerationException {
        CtMethod[] sourceClassMethods = sourceClass.getDeclaredMethods();
        for (int i = 0; i < sourceClassMethods.length; ++i) {
            CodeGenUtil4Javassist.copyClassMethod(sourceClass, destinationClass, sourceClassMethods[i].getName(), sourceClassMethods[i].getSignature());
        }
        return destinationClass;
    }

    public static CtClass copyClassToClass(CtClass sourceClass, CtClass destinationClass) throws CodeGenerationException, ResourceNotFoundException {
        long initTime = System.currentTimeMillis();
        destinationClass = CodeGenUtil4Javassist.copyClassInterfaces(sourceClass, destinationClass);
        destinationClass = CodeGenUtil4Javassist.copyClassAttributes(sourceClass, destinationClass);
        destinationClass = CodeGenUtil4Javassist.copyClassMethods(sourceClass, destinationClass);
        if (ByteCodeStartupConfiguration.isTrackTimes()) {
            System.out.println(destinationClass.getSimpleName() + " - Copied all from class: " + sourceClass.getSimpleName() + " (" + (System.currentTimeMillis() - initTime) + "ms)");
        }
        return destinationClass;
    }

    public static CtClass createNewClass(String className) {
        CodeGenUtil4Javassist.loadCurrentThreadClassPathContext();
        return ClassPool.getDefault().makeClass(className);
    }

    public static ClassHolder createNewClassHolder(String className) {
        CodeGenUtil4Javassist.loadCurrentThreadClassPathContext();
        return new ClassHolder(CodeGenUtil4Javassist.createNewClass(className));
    }

    public static AnnotationMemberValueHolder getAnnotationMemberValue(Annotation annotation, String memberName) throws ResourceNotFoundException {
        return CodeGenUtil4Javassist.getAnnotationMemberValues(annotation).get(memberName);
    }

    public static Map<String, AnnotationMemberValueHolder> getAnnotationMemberValues(Annotation annotation) throws ResourceNotFoundException {
        HashMap<String, AnnotationMemberValueHolder> result = new HashMap<String, AnnotationMemberValueHolder>();
        Set memberNames = annotation.getMemberNames();
        if (memberNames != null) {
            for (Object memberName : memberNames) {
                MemberValue memberValue = annotation.getMemberValue((String)memberName);
                result.put(memberName.toString(), new AnnotationMemberValueHolder(memberValue));
            }
        }
        Class<?> annotationObject = null;
        try {
            annotationObject = Class.forName(annotation.getTypeName().toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ResourceNotFoundException("Could not load class file for annotation: " + annotation.getTypeName(), (Exception)classNotFoundException);
        }
        Method[] methods = annotationObject.getMethods();
        HashMap<String, Object> defaultMemberValues = new HashMap<String, Object>();
        for (Method method : methods) {
            Object defaultValue = method.getDefaultValue();
            if (defaultValue == null) continue;
            defaultMemberValues.put(method.getName(), defaultValue);
        }
        for (String defaultMethod : defaultMemberValues.keySet()) {
            if (result.containsKey(defaultMethod)) continue;
            result.put(defaultMethod, new AnnotationMemberValueHolder(CodeGenUtil4Javassist.convertToMemberValue(defaultMemberValues.get(defaultMethod))));
        }
        return result;
    }

    public static CtClass getClass(String className) throws ResourceNotFoundException {
        if (ClassPool.doPruning) {
            ClassPool.doPruning = false;
        }
        CtClass clazz = null;
        try {
            CodeGenUtil4Javassist.loadCurrentThreadClassPathContext();
            clazz = ClassPool.getDefault().get(className);
            clazz.stopPruning(true);
        }
        catch (NotFoundException notFoundException) {
            throw new ResourceNotFoundException("Could not load class " + className + "!", (Exception)((Object)notFoundException));
        }
        if (clazz.isFrozen()) {
            clazz.defrost();
        }
        return clazz;
    }

    public static String getEnumValue(MemberValue memberValue) {
        return ((EnumMemberValue)memberValue).getValue();
    }

    public static Map<String, AnnotationHolder> getFieldAnnotations(AttributeHolder attribute) {
        HashMap<String, AnnotationHolder> annotations = new HashMap<String, AnnotationHolder>();
        Annotation[] annotationsArray = CodeGenUtil4Javassist.getFieldAnnotationsAsArray(attribute.getManagedAttribute());
        if (annotationsArray != null) {
            for (Annotation annotation : annotationsArray) {
                annotations.put(annotation.getTypeName(), new AnnotationHolder(attribute, annotation));
            }
        }
        return annotations;
    }

    public static Annotation[] getFieldAnnotationsAsArray(CtField field) {
        Annotation[] annotations = null;
        if (CodeGenUtil4Javassist.isFieldAnnotated(field)) {
            FieldInfo fieldInfo = field.getFieldInfo();
            AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
            annotations = annotationsAttribute.getAnnotations();
        }
        return annotations;
    }

    public static Map<String, AnnotationHolder> getMethodAnnotations(MethodHolder method) {
        HashMap<String, AnnotationHolder> annotations = new HashMap<String, AnnotationHolder>();
        Annotation[] annotationsArray = CodeGenUtil4Javassist.getMethodAnnotationsAsArray(method.getManagedMethod());
        if (annotationsArray != null) {
            for (Annotation annotation : annotationsArray) {
                annotations.put(annotation.getTypeName(), new AnnotationHolder(method, annotation));
            }
        }
        return annotations;
    }

    public static Annotation[] getMethodAnnotationsAsArray(CtMethod method) {
        Annotation[] annotations = null;
        if (CodeGenUtil4Javassist.isMethodAnnotated(method)) {
            MethodInfo methodInfo = method.getMethodInfo();
            AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleAnnotations");
            annotations = annotationsAttribute.getAnnotations();
        }
        return annotations;
    }

    public static String getSuperClassName(String className) {
        CodeGenUtil4Javassist.loadCurrentThreadClassPathContext();
        try {
            return ClassPool.getDefault().get(className).getSuperclass().getName();
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    public static Annotation getTypeAnnotation(String annotationName, String className) throws ResourceNotFoundException {
        Annotation annotation = null;
        Annotation[] annotations = CodeGenUtil4Javassist.getTypeAnnotationsAsArray(className);
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                if (!annotations[i].getTypeName().equals(annotationName)) continue;
                annotation = annotations[i];
                break;
            }
        }
        return annotation;
    }

    public static Map<String, AnnotationHolder> getTypeAnnotations(ClassHolder clazz) throws ResourceNotFoundException {
        HashMap<String, AnnotationHolder> annotations = new HashMap<String, AnnotationHolder>();
        Annotation[] annotationsArray = CodeGenUtil4Javassist.getTypeAnnotationsAsArray(clazz.getManagedClass());
        if (annotationsArray != null) {
            for (Annotation annotation : annotationsArray) {
                annotations.put(annotation.getTypeName(), new AnnotationHolder(clazz, annotation));
            }
        }
        return annotations;
    }

    public static List<Annotation> getTypeAnnotations(String className) throws ResourceNotFoundException {
        return Arrays.asList(CodeGenUtil4Javassist.getTypeAnnotationsAsArray(className));
    }

    public static Annotation[] getTypeAnnotationsAsArray(CtClass clazz) {
        if (clazz.isFrozen()) {
            clazz.defrost();
        }
        ClassFile classFile = clazz.getClassFile();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        Annotation[] annotations = null;
        if (annotationsAttribute != null) {
            annotations = annotationsAttribute.getAnnotations();
        }
        return annotations;
    }

    public static Annotation[] getTypeAnnotationsAsArray(String className) throws ResourceNotFoundException {
        CtClass clazz = CodeGenUtil4Javassist.getClass(className);
        Annotation[] annotations = CodeGenUtil4Javassist.getTypeAnnotationsAsArray(clazz);
        return annotations;
    }

    public static List<String> getTypeAnnotationsNames(String className) throws ResourceNotFoundException {
        Annotation[] annotations = CodeGenUtil4Javassist.getTypeAnnotationsAsArray(className);
        ArrayList<String> annotationsNames = null;
        if (annotations != null) {
            annotationsNames = new ArrayList<String>();
            for (int i = 0; i < annotations.length; ++i) {
                annotationsNames.add(annotations[i].getTypeName());
            }
        }
        return annotationsNames;
    }

    public static Map<String, AttributeHolder> getTypeFields(ClassHolder clazz) throws ResourceNotFoundException {
        HashMap<String, AttributeHolder> attributes = new HashMap<String, AttributeHolder>();
        for (CtField field : CodeGenUtil4Javassist.getTypeFieldsAsArray(clazz.getManagedClass())) {
            attributes.put(field.getName(), new AttributeHolder(clazz, field));
        }
        return attributes;
    }

    public static CtField[] getTypeFieldsAsArray(CtClass clazz) {
        ArrayList<CtField> list = new ArrayList<CtField>();
        list.addAll(Arrays.asList(clazz.getDeclaredFields()));
        for (CtField field : clazz.getFields()) {
            boolean exists = false;
            for (CtField current : list) {
                if (!current.getName().equals(field.getName())) continue;
                exists = true;
            }
            if (exists) continue;
            list.add(field);
        }
        CtField[] array = new CtField[list.size()];
        return list.toArray(array);
    }

    public static Map<String, MethodHolder> getTypeMethods(ClassHolder clazz, boolean inherited) throws ResourceNotFoundException {
        HashMap<String, MethodHolder> methods = new HashMap<String, MethodHolder>();
        for (CtMethod method : CodeGenUtil4Javassist.getTypeMethodsAsArray(clazz.getManagedClass(), inherited)) {
            methods.put(method.getName(), new MethodHolder(clazz, method));
        }
        return methods;
    }

    public static CtMethod[] getTypeMethodsAsArray(CtClass clazz, boolean inherited) {
        ArrayList<CtMethod> list = new ArrayList<CtMethod>();
        list.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        if (inherited) {
            for (CtMethod method : clazz.getMethods()) {
                boolean exists = false;
                for (CtMethod current : list) {
                    if (!current.equals((Object)method)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                list.add(method);
            }
        }
        CtMethod[] array = new CtMethod[list.size()];
        return list.toArray(array);
    }

    public static boolean hasInterface(ClassHolder clazz, String interfaceName) throws ResourceNotFoundException {
        CodeGenUtil4Javassist.loadCurrentThreadClassPathContext();
        return clazz.hasInterface(interfaceName);
    }

    public static boolean hasInterface(String className, String interfaceName) throws NotFoundException {
        CodeGenUtil4Javassist.loadCurrentThreadClassPathContext();
        return Arrays.asList(ClassPool.getDefault().get(className).getClassFile2().getInterfaces()).contains(interfaceName);
    }

    public static void implementInterface(ClassHolder clazz, String interfaceName) throws ResourceNotFoundException {
        CodeGenUtil4Javassist.loadCurrentThreadClassPathContext();
        try {
            clazz.getManagedClass().addInterface(ClassPool.getDefault().get(interfaceName));
        }
        catch (NotFoundException notFoundException) {
            throw new ResourceNotFoundException("Could not find interface " + interfaceName + "!", (Exception)((Object)notFoundException));
        }
    }

    public static void implementInterface(String className, String interfaceName) throws NotFoundException {
        CodeGenUtil4Javassist.loadCurrentThreadClassPathContext();
        ClassPool.getDefault().get(className).addInterface(ClassPool.getDefault().get(interfaceName));
    }

    public static boolean isClassAnnotated(CtClass clazz) {
        return clazz.getAvailableAnnotations().length > 0;
    }

    public static boolean isClassAnnotatedWith(String className, String annotationName) throws ResourceNotFoundException {
        boolean result = false;
        List<String> annotationsNames = CodeGenUtil4Javassist.getTypeAnnotationsNames(className);
        if (annotationsNames != null && annotationsNames.contains(annotationName)) {
            result = true;
        }
        return result;
    }

    public static boolean isFieldAnnotated(CtField field) {
        return field.getAvailableAnnotations().length > 0;
    }

    public static boolean isMethodAnnotated(CtMethod method) {
        return method.getAvailableAnnotations().length > 0;
    }

    public static void loadCurrentThreadClassPathContext() {
        ClassPool.getDefault().appendClassPath((ClassPath)new LoaderClassPath(Thread.currentThread().getContextClassLoader()));
    }

    public static boolean methodExists(String methodName, CtClass clazz) {
        boolean result = false;
        CtMethod[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static CtMethod replaceMethodBody(String methodSource, CtMethod method) throws CodeGenerationException {
        long initTime = System.currentTimeMillis();
        if (ByteCodeStartupConfiguration.isShowSource()) {
            System.out.println("Compiling source for method \"" + method.getName() + "\": \n     | " + methodSource.replace("\n", "\n    | "));
        }
        try {
            if (method.getDeclaringClass().isFrozen()) {
                method.getDeclaringClass().defrost();
            }
            method.setBody(methodSource);
        }
        catch (CannotCompileException cannotCompileException) {
            throw new CodeGenerationException("Could not compile source code for method " + method.getName() + " ( Cause: " + cannotCompileException.getReason() + " Source code: " + methodSource + ")", (Exception)((Object)cannotCompileException));
        }
        if (ByteCodeStartupConfiguration.isTrackTimes()) {
            System.out.println(method.getDeclaringClass().getSimpleName() + " - Updated Method: " + method.getName() + " (" + (System.currentTimeMillis() - initTime) + "ms)");
        }
        return method;
    }

    public static void setSuperClass(ClassHolder clazz, String superClassName) throws CannotCompileException, ResourceNotFoundException {
        CodeGenUtil4Javassist.loadCurrentThreadClassPathContext();
        try {
            clazz.setSuperClass(ClassPool.getDefault().get(superClassName));
        }
        catch (NotFoundException notFoundException) {
            throw new ResourceNotFoundException("Could not find " + superClassName, (Exception)((Object)notFoundException));
        }
    }

    public static void setSuperClass(String className, String superClassName) throws CannotCompileException, ResourceNotFoundException {
        CodeGenUtil4Javassist.loadCurrentThreadClassPathContext();
        try {
            ClassPool.getDefault().get(className).setSuperclass(ClassPool.getDefault().get(superClassName));
        }
        catch (NotFoundException notFoundException) {
            throw new ResourceNotFoundException("Could not found class!", (Exception)((Object)notFoundException));
        }
    }

    public static Class<?> writeClass(CtClass clazz) throws CodeGenerationException {
        try {
            if (clazz.isFrozen()) {
                clazz.defrost();
            }
            return clazz.toClass(CodeGenUtil4Javassist.class.getClassLoader(), CodeGenUtil4Javassist.class.getProtectionDomain());
        }
        catch (CannotCompileException cannotCompileException) {
            throw new CodeGenerationException((Exception)((Object)cannotCompileException));
        }
    }
}

