/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.bytecode;

import java.util.Properties;

public class ByteCodeStartupConfiguration {
    public static final String CONFIGURATION_FILE = "bytecode.properties";
    private static final String TRACK_TIMES = "tracktimes";
    private static final String SHOW_SOURCE = "showsource";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static boolean trackTimes;
    private static boolean showSource;

    static String loadProperty(Properties prop, String key, String defaultValue) {
        String value = prop.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static boolean isTrackTimes() {
        return trackTimes;
    }

    public static boolean isShowSource() {
        return showSource;
    }

    static {
        Properties parameters = new Properties();
        try {
            parameters.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(CONFIGURATION_FILE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        trackTimes = Boolean.parseBoolean(ByteCodeStartupConfiguration.loadProperty(parameters, TRACK_TIMES, FALSE).toLowerCase());
        showSource = Boolean.parseBoolean(ByteCodeStartupConfiguration.loadProperty(parameters, SHOW_SOURCE, FALSE).toLowerCase());
    }
}

