/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.bytecode.holders;

import java.util.Map;
import javassist.CtField;
import javassist.NotFoundException;
import pt.digitalis.utils.CodeGenUtil4Javassist;
import pt.digitalis.utils.bytecode.holders.AnnotationHolder;
import pt.digitalis.utils.bytecode.holders.ClassHolder;
import pt.digitalis.utils.bytecode.holders.HolderRepository;
import pt.digitalis.utils.inspection.exception.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeHolder {
    private CtField field;
    private String parentClassName;

    public AttributeHolder(ClassHolder clazz, CtField field) throws ResourceNotFoundException {
        this.parentClassName = clazz.getUniqueID();
        this.field = field;
    }

    public ClassHolder getParentClass() throws ResourceNotFoundException {
        return new ClassHolder(HolderRepository.getClass(this.parentClassName));
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public String getUniqueID() {
        return this.parentClassName + "." + this.getName();
    }

    public String getName() {
        return this.field.getName();
    }

    public String getSignature() {
        return this.field.getSignature();
    }

    public Map<String, AnnotationHolder> getAnnotations() throws ResourceNotFoundException {
        Map<String, AnnotationHolder> attributeAnnotations = HolderRepository.getAnnotations(this.getUniqueID());
        if (attributeAnnotations == null) {
            attributeAnnotations = CodeGenUtil4Javassist.getFieldAnnotations(this);
            HolderRepository.addAnnotations(this.getUniqueID(), attributeAnnotations);
        }
        return attributeAnnotations;
    }

    public boolean containsAnnotation(String annotationName) throws ResourceNotFoundException {
        return this.getAnnotations().containsKey(annotationName);
    }

    public CtField getManagedAttribute() {
        return this.field;
    }

    public String getAttributeType() {
        try {
            return this.getManagedAttribute().getType().getName();
        }
        catch (NotFoundException e) {
            return null;
        }
    }
}

