/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.bytecode.holders;

import java.util.HashMap;
import java.util.Map;
import javassist.CtClass;
import pt.digitalis.utils.CodeGenUtil4Javassist;
import pt.digitalis.utils.bytecode.holders.AnnotationHolder;
import pt.digitalis.utils.bytecode.holders.AnnotationMemberValueHolder;
import pt.digitalis.utils.bytecode.holders.AttributeHolder;
import pt.digitalis.utils.bytecode.holders.MethodHolder;
import pt.digitalis.utils.inspection.exception.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HolderRepository {
    private static Map<String, CtClass> classes = new HashMap<String, CtClass>();
    private static Map<String, Map<String, MethodHolder>> methods = new HashMap<String, Map<String, MethodHolder>>();
    private static Map<String, Map<String, AttributeHolder>> attributes = new HashMap<String, Map<String, AttributeHolder>>();
    private static Map<String, Map<String, AnnotationHolder>> annotations = new HashMap<String, Map<String, AnnotationHolder>>();
    private static Map<String, Map<String, AnnotationMemberValueHolder>> annotationMembers = new HashMap<String, Map<String, AnnotationMemberValueHolder>>();

    public static CtClass getClass(String className) throws ResourceNotFoundException {
        CtClass clazz = classes.get(className);
        if (clazz == null) {
            HolderRepository.addClass(CodeGenUtil4Javassist.getClass(className));
        }
        return clazz;
    }

    public static void updateClass(CtClass clazz) {
        HolderRepository.addClass(clazz);
    }

    public static void addClass(CtClass clazz) {
        classes.put(clazz.getName(), clazz);
    }

    public static void cleanUp() {
        classes = null;
        methods = null;
        attributes = null;
        annotations = null;
        annotationMembers = null;
    }

    public static void initializeInternals() {
        if (classes == null) {
            classes = new HashMap<String, CtClass>();
        }
        if (methods == null) {
            methods = new HashMap<String, Map<String, MethodHolder>>();
        }
        if (attributes == null) {
            attributes = new HashMap<String, Map<String, AttributeHolder>>();
        }
        if (annotations == null) {
            annotations = new HashMap<String, Map<String, AnnotationHolder>>();
        }
        if (annotationMembers == null) {
            annotationMembers = new HashMap<String, Map<String, AnnotationMemberValueHolder>>();
        }
    }

    public static Map<String, AnnotationHolder> getAnnotations(String id) {
        return annotations.get(id);
    }

    public static void addAnnotations(String id, Map<String, AnnotationHolder> annotations) {
        HolderRepository.annotations.put(id, annotations);
    }

    public static Map<String, AnnotationMemberValueHolder> getAnnotationMembers(String id) {
        return annotationMembers.get(id);
    }

    public static void addAnnotationMembers(String id, Map<String, AnnotationMemberValueHolder> annotationMembers) {
        HolderRepository.annotationMembers.put(id, annotationMembers);
    }

    public static Map<String, MethodHolder> getMethods(String id) throws ResourceNotFoundException {
        return methods.get(id);
    }

    public static void addMethods(String id, Map<String, MethodHolder> methods) {
        HolderRepository.methods.put(id, methods);
    }

    public static Map<String, AttributeHolder> getAttributes(String id) {
        return attributes.get(id);
    }

    public static void addAttributes(String id, Map<String, AttributeHolder> attributes) {
        HolderRepository.attributes.put(id, attributes);
    }

    private static void deleteAnnotations(String id) {
        Map<String, AnnotationHolder> elementAnnotations = annotations.get(id);
        if (elementAnnotations != null) {
            for (AnnotationHolder annotation : elementAnnotations.values()) {
                annotationMembers.remove(annotation.getUniqueID());
            }
        }
        annotations.remove(id);
    }

    public static void deleteClassAndReferences(String id) {
        Map<String, MethodHolder> classMethods = methods.get(id);
        Map<String, AttributeHolder> classAttributes = attributes.get(id);
        if (classMethods != null) {
            for (MethodHolder method : classMethods.values()) {
                HolderRepository.deleteAnnotations(method.getUniqueID());
            }
        }
        if (classAttributes != null) {
            for (AttributeHolder attribute : classAttributes.values()) {
                HolderRepository.deleteAnnotations(attribute.getUniqueID());
            }
        }
        HolderRepository.deleteAnnotations(id);
        methods.remove(id);
        attributes.remove(id);
        classes.remove(id);
    }

    public static boolean classExists(String id) {
        if (classes == null) {
            return false;
        }
        return classes.get(id) != null;
    }
}

