/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.bytecode.holders;

import java.util.Map;
import javassist.bytecode.annotation.Annotation;
import pt.digitalis.utils.CodeGenUtil4Javassist;
import pt.digitalis.utils.bytecode.holders.AnnotationMemberValueHolder;
import pt.digitalis.utils.bytecode.holders.AttributeHolder;
import pt.digitalis.utils.bytecode.holders.ClassHolder;
import pt.digitalis.utils.bytecode.holders.HolderRepository;
import pt.digitalis.utils.bytecode.holders.MethodHolder;
import pt.digitalis.utils.inspection.exception.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHolder {
    private Annotation annotation;
    private String parentClassName;
    private String parentMethodName;
    private String parentAttributeName;
    private boolean noCacheMode = false;

    public AnnotationHolder(ClassHolder clazz, Annotation annotation, boolean noCacheMode) throws ResourceNotFoundException {
        this.parentClassName = clazz.getUniqueID();
        this.annotation = annotation;
        this.noCacheMode = noCacheMode;
    }

    public AnnotationHolder(ClassHolder clazz, Annotation annotation) throws ResourceNotFoundException {
        this(clazz, annotation, false);
    }

    public AnnotationHolder(MethodHolder method, Annotation annotation) {
        this.parentClassName = method.getParentClassName();
        this.parentMethodName = method.getName();
        this.annotation = annotation;
    }

    public AnnotationHolder(AttributeHolder attribute, Annotation annotation) {
        this(attribute, annotation, false);
    }

    public AnnotationHolder(AttributeHolder attribute, Annotation annotation, boolean noCacheMode) {
        this.parentClassName = attribute.getParentClassName();
        this.parentAttributeName = attribute.getName();
        this.annotation = annotation;
        this.noCacheMode = noCacheMode;
    }

    public String getUniqueID() {
        String id = null;
        if (this.isClassAnnotation()) {
            id = this.parentClassName + "." + this.getName();
        } else if (this.isMethodAnnotation()) {
            id = this.parentClassName + "." + this.parentMethodName + "." + this.getName();
        } else if (this.isAttributeAnnotation()) {
            id = this.parentClassName + "." + this.parentAttributeName + "." + this.getName();
        }
        return id;
    }

    public ClassHolder getParentClass() throws ResourceNotFoundException {
        return new ClassHolder(this.parentClassName);
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public MethodHolder getParentMethod() throws ResourceNotFoundException {
        Map<String, MethodHolder> classMethods;
        MethodHolder parentMethod = null;
        if (this.parentMethodName != null && (classMethods = HolderRepository.getMethods(this.parentClassName)) != null) {
            parentMethod = classMethods.get(this.parentMethodName);
        }
        return parentMethod;
    }

    public AttributeHolder getParentAttribute() {
        Map<String, AttributeHolder> classAttributes;
        AttributeHolder parentAttribute = null;
        if (this.parentAttributeName != null && (classAttributes = HolderRepository.getAttributes(this.parentClassName)) != null) {
            parentAttribute = classAttributes.get(this.parentAttributeName);
        }
        return parentAttribute;
    }

    public boolean isClassAnnotation() {
        return this.parentAttributeName == null && this.parentMethodName == null;
    }

    public boolean isMethodAnnotation() {
        return this.parentMethodName != null;
    }

    public boolean isAttributeAnnotation() {
        return this.parentAttributeName != null;
    }

    public Map<String, AnnotationMemberValueHolder> getMembers() throws ResourceNotFoundException {
        Map<String, AnnotationMemberValueHolder> annotationMembers = null;
        if (!this.noCacheMode) {
            annotationMembers = HolderRepository.getAnnotationMembers(this.getUniqueID());
        }
        if (annotationMembers == null) {
            annotationMembers = CodeGenUtil4Javassist.getAnnotationMemberValues(this.annotation);
            HolderRepository.addAnnotationMembers(this.getUniqueID(), annotationMembers);
        }
        return annotationMembers;
    }

    public String getName() {
        return this.annotation.getTypeName();
    }

    public Annotation getManagedAnnotation() {
        return this.annotation;
    }

    public Map<String, AnnotationHolder> getMetaAnnotations() throws ResourceNotFoundException {
        return new ClassHolder(this.getName()).getAnnotations();
    }
}

